/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.classmodel;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.classmodel.ClassPath;

public class CodeSourceFilter {
    private final ClassPath filter;
    private final HashSet<String> classes = new HashSet();

    public CodeSourceFilter(ClassPath filter) {
        this.filter = filter;
        try {
            if (null != filter) {
                this.initialize();
            }
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.FINE, "error occurred", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.classes.toString();
    }

    public boolean matches(String className) {
        return this.classes.contains(className);
    }

    private void initialize() throws IOException {
        for (File file : this.filter.getFileEntries()) {
            if (!file.exists()) continue;
            if (file.isFile()) {
                this.index(new JarFile(file));
                continue;
            }
            if (!file.isDirectory()) continue;
            this.index("", file);
        }
    }

    private void index(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> en = jarFile.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            this.index(entry.getName().replace("/", "."));
        }
        jarFile.close();
    }

    private void index(String baseName, File directory) {
        File[] files = directory.listFiles();
        if (null == files) {
            return;
        }
        for (File file : files) {
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                this.index(baseName + (baseName.isEmpty() ? "" : ".") + file.getName(), file);
                continue;
            }
            this.index(baseName + (baseName.isEmpty() ? "" : ".") + file.getName());
        }
    }

    private void index(String name) {
        if (name.endsWith(".class") && !this.isnum(name.charAt(0))) {
            this.classes.add(name.substring(0, name.length() - 6));
        }
    }

    private boolean isnum(char ch) {
        return ch >= '0' && ch <= '9';
    }
}

