/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.InjectionResolver;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantRequested;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.tracing.TracingThreadLocal;
import org.jvnet.hk2.tracing.TracingUtilities;

public abstract class AbstractCreatorImpl<T>
extends AbstractInhabitantImpl<T>
implements Creator<T> {
    private static final Logger logger = Logger.getLogger(AbstractCreatorImpl.class.getName());
    protected final Class<? extends T> type;
    protected final Habitat habitat;
    private final MultiMap<String, String> metadata;

    public AbstractCreatorImpl(Class<? extends T> type, Habitat habitat, MultiMap<String, String> metadata) {
        this.type = type;
        this.habitat = habitat;
        this.metadata = metadata;
    }

    @Override
    public String typeName() {
        return this.type.getName();
    }

    @Override
    public final Class<? extends T> type() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(Inhabitant onBehalfOf) throws ComponentException {
        try {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().push(this);
            }
            Object o = this.create(onBehalfOf);
            logger.log(Level.FINER, "created object {0}", o);
            this.initialize(o, onBehalfOf);
            Object object = o;
            return (T)object;
        }
        finally {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().pop();
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    @Override
    public void initialize(T t, Inhabitant onBehalfOf) throws ComponentException {
        if (t instanceof InhabitantRequested) {
            ((InhabitantRequested)t).setInhabitant(onBehalfOf);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.metadata;
    }

    protected void inject(Habitat habitat, T t, Inhabitant<?> onBehalfOf) {
        logger.log(Level.FINER, "injection starting on {0}", t);
        InjectionManager injectionMgr = this.createInjectionManager();
        InjectionResolver[] targets = this.getInjectionResolvers(habitat);
        ExecutorService es = this.getExecutorService(habitat, onBehalfOf);
        injectionMgr.inject(t, onBehalfOf, es, targets);
        if (t instanceof PostConstruct) {
            logger.log(Level.FINER, "calling PostConstruct on {0}", t);
            ((PostConstruct)t).postConstruct();
        }
        logger.log(Level.FINER, "injection finished on {0}", t);
    }

    protected InjectionManager createInjectionManager() {
        return new InjectionManager();
    }

    protected InjectionResolver[] getInjectionResolvers(Habitat h) {
        Collection<InjectionResolver> targets = this.habitat.getAllByType(InjectionResolver.class);
        assert (!targets.isEmpty());
        return targets.toArray(new InjectionResolver[targets.size()]);
    }

    protected ExecutorService getExecutorService(Habitat h, Inhabitant<?> onBehalfOf) {
        return h.getComponent(ExecutorService.class, "inhabitant-injection");
    }
}

