/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.InhabitantParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.FactoryFor;
import org.jvnet.hk2.annotations.InhabitantAnnotation;
import org.jvnet.hk2.annotations.InhabitantMetadata;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.MultiMap;

public class InhabitantIntrospectionScanner
implements Iterable<InhabitantParser> {
    final Types types;
    final Iterator<AnnotatedElement> inhabitantAnnotations;
    Iterator<AnnotatedElement> current;

    public InhabitantIntrospectionScanner(ParsingContext context) {
        this.types = context.getTypes();
        AnnotationType am = (AnnotationType)this.types.getBy(AnnotationType.class, InhabitantAnnotation.class.getName());
        if (am == null) {
            this.inhabitantAnnotations = Collections.EMPTY_LIST.iterator();
        } else {
            Collection ccc = am.allAnnotatedTypes();
            this.inhabitantAnnotations = ccc.iterator();
        }
        this.fetch();
    }

    private void fetch() {
        if (!this.inhabitantAnnotations.hasNext()) {
            this.current = Collections.EMPTY_LIST.iterator();
            return;
        }
        do {
            AnnotationType am = (AnnotationType)AnnotationType.class.cast(this.inhabitantAnnotations.next());
            this.current = am.allAnnotatedTypes().iterator();
        } while (!this.current.hasNext() && this.inhabitantAnnotations.hasNext());
    }

    public boolean isContract(AnnotatedElement type) {
        if (null == type) {
            return false;
        }
        return type.getAnnotation(Contract.class.getName()) != null;
    }

    public void findClassContracts(ClassModel cm, Set<String> interfaces, Set<String> annotationTypeInterfaces) {
        for (InterfaceModel im : cm.getInterfaces()) {
            if (!this.isContract((AnnotatedElement)im)) continue;
            interfaces.add(im.getName());
        }
        this.findContractsFromAnnotations((AnnotatedElement)cm, interfaces, annotationTypeInterfaces);
    }

    public void findInterfaceContracts(InterfaceModel im, Set<String> interfaces, Set<String> annInterfaces) {
        if (im.getParent() != null) {
            this.findInterfaceContracts((InterfaceModel)im.getParent(), interfaces, annInterfaces);
        }
        if (this.isContract((AnnotatedElement)im)) {
            if (im instanceof AnnotationType) {
                String name = im.getName();
                if (!name.equals(FactoryFor.class.getName())) {
                    annInterfaces.add(name);
                }
            } else {
                interfaces.add(im.getName());
            }
        }
        this.findContractsFromAnnotations((AnnotatedElement)im, interfaces, annInterfaces);
    }

    public void findContractsFromAnnotations(AnnotatedElement ae, Set<String> interfaces, Set<String> annInterfaces) {
        for (AnnotationModel am : ae.getAnnotations()) {
            AnnotationType at = am.getType();
            this.findInterfaceContracts((InterfaceModel)at, interfaces, annInterfaces);
            String name = at.getName();
            if (name.equals(ContractProvided.class.getName())) {
                String val = InhabitantIntrospectionScanner.scrub(am.getValues().get("value"));
                if (null == val) continue;
                interfaces.add(val);
                continue;
            }
            if (!name.equals(FactoryFor.class.getName())) continue;
            Object rawObj = am.getValues().get("value");
            if (Collection.class.isInstance(rawObj)) {
                Collection coll = (Collection)am.getValues().get("value");
                for (Object obj : coll) {
                    String val = InhabitantIntrospectionScanner.scrub(obj);
                    if (null == val) continue;
                    annInterfaces.add(name + ":" + val);
                }
                continue;
            }
            String val = InhabitantIntrospectionScanner.scrub(rawObj);
            if (null == val) continue;
            annInterfaces.add(name + ":" + val);
        }
    }

    public static String scrub(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        String mangled = obj.toString();
        if (mangled.startsWith("L") && mangled.endsWith(";")) {
            mangled = mangled.substring(1, mangled.length() - 1);
        }
        return mangled.replace("/", ".");
    }

    public void findContracts(ClassModel cm, Set<String> interfaces, Set<String> annotationTypeInterfaces) {
        for (ParameterizedInterfaceModel pim : cm.getParameterizedInterfaces()) {
            if (!this.isContract((AnnotatedElement)pim.getRawInterface())) continue;
            interfaces.add(pim.getName());
        }
        for (InterfaceModel im : cm.getInterfaces()) {
            this.getAllContractInterfaces(im, interfaces);
        }
        this.findContractsFromAnnotations((AnnotatedElement)cm, interfaces, annotationTypeInterfaces);
        ClassModel parent = (ClassModel)cm.getParent();
        if (null == parent) {
            LinkedHashSet<String> newIfaces = new LinkedHashSet<String>();
            for (String ifaceName : interfaces) {
                InterfaceModel iface = (InterfaceModel)this.types.getBy(InterfaceModel.class, ifaceName);
                this.getAllContractInterfaces(iface, newIfaces);
            }
            interfaces.addAll(newIfaces);
        } else if (!parent.getName().equals(Object.class.getName())) {
            this.findContracts(parent, interfaces, annotationTypeInterfaces);
        }
    }

    public static void populateExtraInhabitantMetaData(MultiMap<String, String> dest, AnnotatedElement ae) {
        for (AnnotationModel model : ae.getAnnotations()) {
            for (MethodModel mm : model.getType().getMethods()) {
                InhabitantIntrospectionScanner.populateExtraInhabitantMetaData(dest, model, mm);
            }
            for (AnnotationModel subModel : model.getType().getAnnotations()) {
                for (MethodModel mm : subModel.getType().getMethods()) {
                    InhabitantIntrospectionScanner.populateExtraInhabitantMetaData(dest, subModel, mm);
                }
            }
        }
    }

    private static void populateExtraInhabitantMetaData(MultiMap<String, String> dest, AnnotationModel model, MethodModel mm) {
        AnnotationModel ma;
        if (null != mm && null != (ma = mm.getAnnotation(InhabitantMetadata.class.getName()))) {
            Object tag = ma.getValues().get("value");
            Object val = model.getValues().get(mm.getName());
            if (null != tag) {
                String tagStr = tag.toString();
                if (null != val) {
                    InhabitantIntrospectionScanner.add(dest, tagStr, val.toString());
                } else {
                    tag = mm.getName();
                    val = ((AnnotationType)mm.getDeclaringType()).getDefaultValues().get(tag);
                    if (null != val) {
                        InhabitantIntrospectionScanner.add(dest, tagStr, val.toString());
                    }
                }
            }
        }
    }

    private static void add(MultiMap<String, String> dest, String key, String val) {
        List<String> vals = dest.get(key);
        if (null == vals || !vals.contains(val)) {
            dest.add(key, val);
        }
    }

    private void getAllContractInterfaces(InterfaceModel im, Collection<String> interfaces) {
        if (im == null) {
            return;
        }
        if (this.isContract((AnnotatedElement)im)) {
            interfaces.add(im.getName());
        }
        for (InterfaceModel implementedIntf : im.getInterfaces()) {
            this.getAllContractInterfaces(implementedIntf, interfaces);
        }
    }

    @Override
    public Iterator<InhabitantParser> iterator() {
        return new Iterator<InhabitantParser>(){

            @Override
            public boolean hasNext() {
                return InhabitantIntrospectionScanner.this.current.hasNext();
            }

            @Override
            public InhabitantParser next() {
                final AnnotatedElement ae = InhabitantIntrospectionScanner.this.current.next();
                InhabitantParser ip = new InhabitantParser(){

                    @Override
                    public Iterable<String> getIndexes() {
                        if (ae instanceof ClassModel) {
                            final ClassModel cm = (ClassModel)ae;
                            LinkedHashSet<String> implInterfaces = new LinkedHashSet<String>();
                            LinkedHashSet<String> implAnnotationInterfaces = new LinkedHashSet<String>();
                            InhabitantIntrospectionScanner.this.findContracts(cm, implInterfaces, implAnnotationInterfaces);
                            final Iterator interfaces = implInterfaces.iterator();
                            final Iterator annInterfaces = implAnnotationInterfaces.iterator();
                            return new Iterable<String>(){

                                @Override
                                public Iterator<String> iterator() {
                                    return new Iterator<String>(){

                                        @Override
                                        public boolean hasNext() {
                                            return interfaces.hasNext() || annInterfaces.hasNext();
                                        }

                                        @Override
                                        public String next() {
                                            if (interfaces.hasNext()) {
                                                AnnotationModel am = cm.getAnnotation(Service.class.getName());
                                                String contract = (String)interfaces.next();
                                                String name = (String)am.getValues().get("name");
                                                if (name == null || name.isEmpty()) {
                                                    return contract;
                                                }
                                                return contract + ":" + name;
                                            }
                                            String contract = (String)annInterfaces.next();
                                            return contract;
                                        }

                                        @Override
                                        public void remove() {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                            };
                        }
                        return new ArrayList<String>();
                    }

                    @Override
                    public String getImplName() {
                        return ae.getName();
                    }

                    @Override
                    public void setImplName(String name) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public String getLine() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void rewind() {
                    }

                    @Override
                    public MultiMap<String, String> getMetaData() {
                        Object metaObj;
                        MultiMap<String, String> mm = new MultiMap<String, String>();
                        AnnotationModel am = ae.getAnnotation(Service.class.getName());
                        if (null != am && null != (metaObj = am.getValues().get("metadata"))) {
                            String[] split;
                            String meta = metaObj.toString();
                            for (String entry : split = meta.split(",")) {
                                String[] split2 = entry.split("=");
                                if (2 != split2.length) continue;
                                mm.add(split2[0], split2[1]);
                            }
                        }
                        for (AnnotationModel annotationModel : ae.getAnnotations()) {
                            if (annotationModel.getType().getAnnotation("javax.inject.Qualifier") == null) continue;
                            mm.add("qualifier", annotationModel.getType().getName());
                        }
                        InhabitantIntrospectionScanner.populateExtraInhabitantMetaData(mm, ae);
                        return mm;
                    }
                };
                if (!InhabitantIntrospectionScanner.this.current.hasNext()) {
                    InhabitantIntrospectionScanner.this.fetch();
                }
                return ip;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

