/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantParser;
import com.sun.hk2.component.InhabitantStore;
import com.sun.hk2.component.Inhabitants;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantProviderInterceptor;

public class InhabitantsParser
implements InhabitantStore {
    private final Logger logger = Logger.getLogger(InhabitantsParser.class.getName());
    public final Habitat habitat;
    private final Map<String, Class<?>> replacements = new HashMap();

    public InhabitantsParser(Habitat habitat) {
        this.habitat = habitat;
    }

    public void drop(Class<?> component) {
        this.drop(component.getName());
    }

    public void drop(String fullyQualifiedClassName) {
        this.replace(fullyQualifiedClassName, null);
    }

    public void replace(Class<?> oldComponent, Class<?> newComponent) {
        this.replace(oldComponent.getName(), newComponent);
    }

    public void replace(String oldComponentFullyQualifiedClassName, Class<?> newComponent) {
        this.replacements.put(oldComponentFullyQualifiedClassName, newComponent);
    }

    public void parse(Iterable<InhabitantParser> scanner, Holder<ClassLoader> classLoader) throws IOException {
        if (scanner == null) {
            return;
        }
        List interceptors = null == this.habitat ? Collections.EMPTY_LIST : this.habitat.getAllByContract(InhabitantProviderInterceptor.class);
        for (InhabitantParser inhabitantParser : scanner) {
            String typeName;
            if (this.isFilteredInhabitant(inhabitantParser) || this.isFilteredInhabitant(typeName = inhabitantParser.getImplName())) continue;
            if (this.replacements.containsKey(typeName)) {
                Class<?> target = this.replacements.get(typeName);
                if (target == null) continue;
                inhabitantParser.setImplName(target.getName());
                Inhabitant<?> i = null;
                try {
                    i = Inhabitants.create(target, this.habitat, inhabitantParser.getMetaData());
                }
                catch (Exception e) {
                    this.reportProblem(typeName, e);
                }
                if (null == i) continue;
                this.add(i, inhabitantParser);
                this.addIndex(i, typeName, null);
                continue;
            }
            HashSet<String> indicies = new HashSet<String>();
            Iterator<String> iter = inhabitantParser.getIndexes().iterator();
            while (iter.hasNext()) {
                indicies.add(iter.next());
            }
            Inhabitant<?> i = null;
            try {
                i = Inhabitants.createInhabitant(this.habitat, interceptors.iterator(), classLoader, typeName, inhabitantParser.getMetaData(), null, this, Collections.unmodifiableSet(indicies));
            }
            catch (Exception e) {
                this.reportProblem(typeName, e);
            }
            if (null == i) continue;
            this.add(i, inhabitantParser);
        }
    }

    private void reportProblem(String typeName, Exception e) {
        this.logger.log(Level.WARNING, "Unable to create inhabitant for {0} - and therefore ignoring it; check classpath; re: {1}", new Object[]{typeName, e.getMessage()});
        this.logger.log(Level.FINER, "", e);
    }

    protected boolean isFilteredInhabitant(InhabitantParser inhabitantParser) {
        return false;
    }

    protected boolean isFilteredInhabitant(String typeName) {
        return false;
    }

    protected void add(Inhabitant<?> i, InhabitantParser parser) {
        this.add(i);
        for (String v : parser.getIndexes()) {
            int idx = v.indexOf(58);
            if (idx == -1) {
                this.addIndex(i, v, null);
                continue;
            }
            String contract = v.substring(0, idx);
            String name = v.substring(idx + 1);
            this.addIndex(i, contract, name);
        }
    }

    public static String parseIndex(String v, StringBuilder name) {
        int idx = v.indexOf(58);
        if (-1 == idx) {
            return v;
        }
        String contract = v.substring(0, idx);
        if (null != name) {
            name.append(v.substring(idx + 1));
        }
        return contract;
    }

    @Override
    public void add(Inhabitant<?> i) {
        this.logger.log(Level.FINE, "adding inhabitant: {0} to habitat {1}", new Object[]{i, this.habitat});
        this.habitat.add(i);
    }

    @Override
    public void addIndex(Inhabitant<?> i, String typeName, String name) {
        this.logger.log(Level.FINE, "adding index for inhabitant: {0} with typeName {1} and name {2} to habitat {3}", new Object[]{i, typeName, name, this.habitat});
        this.habitat.addIndex(i, typeName, name);
    }

    @Override
    public boolean remove(Inhabitant<?> i) {
        this.logger.log(Level.FINE, "removing inhabitant: {0} from habitat {1}", new Object[]{i, this.habitat});
        return this.habitat.remove(i);
    }

    @Override
    public boolean removeIndex(String index, String name) {
        this.logger.log(Level.FINE, "removing inhabitant index: {0},{1} from habitat {2}", new Object[]{index, name, this.habitat});
        return this.habitat.removeIndex(index, name);
    }

    @Override
    public boolean removeIndex(String index, Object serviceOrInhabitant) {
        this.logger.log(Level.FINE, "removing inhabitant index: {0},{1} from habitat {2}", new Object[]{index, serviceOrInhabitant, this.habitat});
        return this.habitat.removeIndex(index, serviceOrInhabitant);
    }
}

