/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Hk2ThreadContext;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.Inhabitants;
import com.sun.hk2.component.InjectionPointImpl;
import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.tiger_types.Types;

public class InjectInjectionResolver
extends InjectionResolver<Inject> {
    final Habitat habitat;

    public InjectInjectionResolver(Habitat habitat) {
        super(Inject.class);
        this.habitat = habitat;
    }

    @Override
    public boolean isOptional(AnnotatedElement element, Inject annotation) {
        return annotation.optional();
    }

    @Override
    public <V> V getValue(final Object component, final Inhabitant<?> onBehalfOf, final AnnotatedElement target, final Type genericType, final Class<V> type) throws ComponentException {
        final Inject inject = target.getAnnotation(Inject.class);
        Callable callable = new Callable<V>(){

            @Override
            public V call() throws ComponentException {
                Object result = null;
                if (type.isArray()) {
                    result = InjectInjectionResolver.this.getArrayInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type);
                } else if (Types.isSubClassOf(type, Holder.class)) {
                    result = InjectInjectionResolver.this.getHolderInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type, inject);
                } else if (genericType instanceof TypeVariable) {
                    TypeVariable<Class<?>>[] typeVariables = component.getClass().getTypeParameters();
                    for (int i = 0; i < typeVariables.length; ++i) {
                        if (!typeVariables[i].getName().equals(((TypeVariable)genericType).getName())) continue;
                        String parameterizedType = onBehalfOf.metadata().get("paramType").get(i);
                        try {
                            Class<?> clazz = component.getClass().getClassLoader().loadClass(parameterizedType);
                            if (InjectInjectionResolver.this.habitat.isContract(clazz)) {
                                result = InjectInjectionResolver.this.getServiceInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, clazz, clazz, inject);
                                continue;
                            }
                            result = InjectInjectionResolver.this.getComponentInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, clazz, clazz, inject);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            Logger.getAnonymousLogger().warning("Cannot load class " + parameterizedType);
                            return null;
                        }
                    }
                } else {
                    if (genericType instanceof ParameterizedType) {
                        // empty if block
                    }
                    result = InjectInjectionResolver.this.habitat.isContract(genericType) ? (Object)InjectInjectionResolver.this.getServiceInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type, inject) : (Object)InjectInjectionResolver.this.getComponentInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type, inject);
                }
                return result == null ? null : InjectInjectionResolver.this.validate(component, onBehalfOf, result);
            }
        };
        try {
            if (this.habitat.isContextualFactoriesPresent()) {
                InjectionPointImpl ip = new InjectionPointImpl(component, target, type, inject, onBehalfOf);
                return Hk2ThreadContext.captureIPandRun(ip, callable);
            }
            return callable.call();
        }
        catch (Exception e) {
            if (e instanceof ComponentException) {
                throw (ComponentException)((Object)ComponentException.class.cast(e));
            }
            throw new ComponentException(e);
        }
    }

    protected <V> V getArrayInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type) {
        Class<?> ct = type.getComponentType();
        Collection<?> instances = habitat.isContract(ct) ? this.getAllByContract(onBehalfOf, habitat, ct) : this.getAllByType(onBehalfOf, habitat, ct);
        V result = type.cast(instances.toArray((Object[])Array.newInstance(ct, instances.size())));
        return result;
    }

    protected <V> V getHolderInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type, Inject inject) throws ComponentException {
        Type t = Types.getTypeArgument(((Field)target).getGenericType(), 0);
        Class finalType = Types.erasure(t);
        if (habitat.isContract(finalType)) {
            Inhabitant<?> i = this.manage(onBehalfOf, habitat.getInhabitant(finalType, inject.name()));
            return type.cast(i);
        }
        try {
            if (finalType.cast(component) != null) {
                return type.cast(onBehalfOf);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        V result = type.cast(this.getInhabitantByType(onBehalfOf, habitat, finalType));
        return result;
    }

    protected <V> V getServiceInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type, Inject inject) throws ComponentException {
        V result = null;
        String name = this.getTargetName(target, inject);
        ArrayList<String> qualifiers = new ArrayList<String>();
        Annotation[] targetAnnotations = target.getAnnotations();
        Inhabitant<?> i = null;
        if (name.isEmpty() && targetAnnotations.length > 1) {
            for (Annotation annotation : target.getAnnotations()) {
                for (Annotation annotationAnnotation : annotation.annotationType().getAnnotations()) {
                    if (annotationAnnotation.annotationType() != Qualifier.class) continue;
                    qualifiers.add(annotation.annotationType().getName());
                }
            }
            if (qualifiers.isEmpty()) {
                i = this.manage(onBehalfOf, habitat.getInhabitant(genericType, name));
            } else {
                ArrayList tmpQualifiers = new ArrayList(qualifiers);
                for (Inhabitant<V> inh : habitat.getInhabitants(type)) {
                    List<String> declaredQualifiers = inh.metadata().get("qualifier");
                    for (String declaredQualifier : declaredQualifiers) {
                        tmpQualifiers.remove(declaredQualifier);
                    }
                    if (!tmpQualifiers.isEmpty()) continue;
                    i = this.manage(onBehalfOf, inh);
                    break;
                }
            }
        } else {
            i = this.manage(onBehalfOf, habitat.getInhabitant(genericType, name));
        }
        if (null != i) {
            Object service = i.get();
            try {
                result = type.cast(service);
            }
            catch (ClassCastException e) {
                Logger.getAnonymousLogger().severe("ClassCastException between contract " + type + " and service " + service);
                Logger.getAnonymousLogger().severe("Contract class loader " + type.getClassLoader());
                Logger.getAnonymousLogger().severe("Service class loader " + service.getClass().getClassLoader());
                i.release();
                throw e;
            }
        }
        return result;
    }

    protected <V> V getComponentInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type, Inject inject) throws ComponentException {
        Inhabitant<?> i = this.manage(onBehalfOf, habitat.getInhabitantByType(genericType));
        if (null != i) {
            return (V)i.get();
        }
        return null;
    }

    protected <V> V validate(Object component, Inhabitant<?> onBehalfOf, V toBeInjected) {
        Inhabitants.validate(component, toBeInjected);
        return toBeInjected;
    }

    protected Inhabitant<?> manage(Inhabitant<?> onBehalfOf, Inhabitant<?> inhabitant) {
        return inhabitant;
    }

    protected <V> Collection<V> manage(Inhabitant<?> onBehalfOf, Iterable<?> inhabitants) {
        if (null == inhabitants) {
            return null;
        }
        ArrayList managed = new ArrayList();
        for (Object iObj : inhabitants) {
            Inhabitant i = (Inhabitant)iObj;
            managed.add(this.manage(onBehalfOf, i).get());
        }
        return managed;
    }

    protected Inhabitant<?> getInhabitantByType(Inhabitant<?> onBehalfOf, Habitat habitat, Class<?> finalType) {
        return this.manage(onBehalfOf, habitat.getInhabitantByType(finalType));
    }

    protected <V> Collection<V> getInhabitants(Inhabitant<?> onBehalfOf, Habitat habitat, Class<?> finalType, String name) {
        return this.manage(onBehalfOf, habitat.getInhabitants(finalType, name));
    }

    protected <V> Collection<V> getAllByType(Inhabitant<?> onBehalfOf, Habitat habitat, Class<V> ct) {
        return this.manage(onBehalfOf, habitat.getAllInhabitantsByType(ct));
    }

    protected <V> Collection<V> getAllByContract(Inhabitant<?> onBehalfOf, Habitat habitat, Class<V> ct) {
        return this.manage(onBehalfOf, habitat.getAllInhabitantsByContract(ct.getName()));
    }

    String getTargetName(AnnotatedElement target, Inject inject) {
        Named named = target.getAnnotation(Named.class);
        String name = inject.name();
        if (named != null && !inject.name().isEmpty()) {
            throw new RuntimeException("Field or method [" + target.toString() + "] is annotated with both a @Named" + " annotation as well as a @Inject.name() value, please choose");
        }
        if (named != null) {
            name = named.value();
        }
        return name;
    }
}

