/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.EventPublishingInhabitant;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PreDestroy;

class ReferenceCountedLazyInhabitant<T>
extends EventPublishingInhabitant<T> {
    private volatile WeakReference<T> ref = new WeakReference<Object>(null);
    private WeakReference<Inhabitant<?>> onBehalfOfRef = new WeakReference<Object>(null);
    private final AtomicInteger refCount;

    public ReferenceCountedLazyInhabitant(Inhabitant<?> delegate) {
        this(delegate, 0);
    }

    public ReferenceCountedLazyInhabitant(Inhabitant<?> delegate, int startingRefCount) {
        super(delegate);
        this.refCount = new AtomicInteger(startingRefCount);
    }

    protected void finalize() throws Throwable {
        this.releaseFinal();
        super.finalize();
    }

    int getRefCount() {
        return this.refCount.get();
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        T object = null;
        int val = this.refCount.incrementAndGet();
        if (1 == val) {
            try {
                object = super.get(onBehalfOf);
                this.ref = new WeakReference<Object>(object);
            }
            catch (RuntimeException e) {
                logger.log(Level.FINE, "error encountered", (Throwable)((Object)new ComponentException(e)));
                this.refCount.decrementAndGet();
                throw e;
            }
            if (null != object && this != onBehalfOf) {
                this.onBehalfOfRef = new WeakReference<Inhabitant>(onBehalfOf);
            }
        } else {
            object = this.ref.get();
        }
        Inhabitant i = (Inhabitant)this.onBehalfOfRef.get();
        assert (onBehalfOf == i || null == i) : "wrong onBehalfOf context";
        return object;
    }

    @Override
    public void release() {
        int val = this.refCount.decrementAndGet();
        assert (val >= 0) : "too many releases";
        if (0 == val) {
            try {
                this.releaseFinal();
            }
            catch (RuntimeException e) {
                logger.log(Level.FINE, "error encountered", (Throwable)((Object)new ComponentException(e)));
                throw e;
            }
            finally {
                this.ref.clear();
                this.ref = null;
                this.onBehalfOfRef.clear();
                this.onBehalfOfRef = null;
                super.release();
            }
        }
    }

    private void releaseFinal() {
        Object object = this.ref.get();
        if (PreDestroy.class.isInstance(object)) {
            ((PreDestroy)PreDestroy.class.cast(object)).preDestroy();
        }
    }
}

