/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.AbstractCreatorImpl;
import com.sun.hk2.component.ConstructorCreator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.hk2.Binder;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.NamedBinder;
import org.glassfish.hk2.ResolvedBinder;
import org.glassfish.hk2.Scope;
import org.glassfish.hk2.TypeLiteral;
import org.jvnet.hk2.component.AbstractResolvedBinder;
import org.jvnet.hk2.component.BinderFactoryImpl;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InstanceBasedBinder;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.TypeBasedBinder;
import org.jvnet.hk2.component.TypeLiteralBasedBinder;

class BinderImpl<V>
implements Binder<V>,
ResolvedBinder<V> {
    String name;
    String typeName;
    Class<? extends Scope> scope;
    final List<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
    final List<String> contracts = new ArrayList<String>();
    final BinderFactoryImpl owner;

    BinderImpl(BinderFactoryImpl owner) {
        this.owner = owner;
    }

    public NamedBinder<V> named(String name) {
        this.name = name;
        return this;
    }

    public NamedBinder<V> annotatedWith(Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            this.annotations.add(annotation);
        }
        return this;
    }

    public ResolvedBinder<V> to(String className) {
        this.typeName = className;
        return this;
    }

    public <T extends V> ResolvedBinder<T> to(Class<? extends T> serviceClass) {
        TypeBasedBinder<? extends T> resolvedBinder = new TypeBasedBinder<T>(this, serviceClass);
        this.owner.add(resolvedBinder);
        return resolvedBinder;
    }

    public <T extends V> ResolvedBinder<T> to(TypeLiteral<T> typeLiteral) {
        TypeLiteralBasedBinder<T> resolvedBinder = new TypeLiteralBasedBinder<T>(this, typeLiteral);
        this.owner.add(resolvedBinder);
        return resolvedBinder;
    }

    public <T extends V> void toInstance(T instance) {
        InstanceBasedBinder<T> resolvedBinder = new InstanceBasedBinder<T>(this, instance);
        this.owner.add(resolvedBinder);
    }

    public <T extends V> ResolvedBinder<T> toFactory(final Factory<T> provider) {
        return new AbstractResolvedBinder<T>(this){

            @Override
            void registerIn(Habitat habitat) {
                MultiMap<String, String> metadata = super.populateMetadata();
                AbstractCreatorImpl inh = new AbstractCreatorImpl<T>(null, habitat, metadata){

                    @Override
                    public T create(Inhabitant onBehalfOf) throws ComponentException {
                        Object t = provider.get();
                        this.inject(this.habitat, t, onBehalfOf);
                        return t;
                    }
                };
                super.registerIn(habitat, inh);
            }
        };
    }

    public <T extends V> ResolvedBinder<T> toFactory(final Class<? extends Factory<? extends T>> factoryType) {
        return new AbstractResolvedBinder<T>(this){

            @Override
            void registerIn(Habitat habitat) {
                MultiMap<String, String> metadata = super.populateMetadata();
                AbstractCreatorImpl inh = new AbstractCreatorImpl<T>(null, habitat, metadata){

                    @Override
                    public T create(Inhabitant onBehalfOf) throws ComponentException {
                        Inhabitant factoryInhabitant = this.habitat.getInhabitantByType(factoryType);
                        if (factoryInhabitant == null) {
                            factoryInhabitant = new ConstructorCreator(factoryType, this.habitat, null);
                        }
                        Factory f = (Factory)factoryInhabitant.get();
                        Object t = f.get();
                        this.inject(this.habitat, t, onBehalfOf);
                        return t;
                    }
                };
                super.registerIn(habitat, inh);
            }
        };
    }

    public <T extends V> ResolvedBinder<T> toFactory(TypeLiteral<? extends Factory<? extends T>> providerType) {
        throw new UnsupportedOperationException();
    }

    public void in(Class<? extends Scope> scope) {
        this.scope = scope;
    }

    void addContract(Class<?> contract) {
        this.addContract(contract.getName());
    }

    void addContract(String contractName) {
        this.contracts.add(contractName);
    }
}

