/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.glassfish.hk2.Descriptor;
import org.jvnet.hk2.component.MultiMap;

class DescriptorImpl
implements Descriptor {
    private final String name;
    private final String typeName;
    private final List<String> qualifiers = new ArrayList<String>();
    private final List<String> contracts = new ArrayList<String>();
    private final MultiMap<String, String> metadata;
    static final Descriptor EMPTY_DESCRIPTOR = new Descriptor(){

        public String getName() {
            return null;
        }

        public MultiMap<String, String> getMetadata() {
            return MultiMap.emptyMap();
        }

        public Collection<String> getQualifiers() {
            return Collections.emptySet();
        }

        public Collection<String> getContracts() {
            return Collections.emptySet();
        }

        public String getTypeName() {
            return null;
        }
    };

    public DescriptorImpl(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
        this.metadata = new MultiMap();
    }

    public DescriptorImpl(Descriptor other) {
        this.name = other.getName();
        this.typeName = other.getTypeName();
        this.qualifiers.addAll(other.getQualifiers());
        this.contracts.addAll(other.getContracts());
        this.metadata = new MultiMap(other.getMetadata());
    }

    void addContract(String contractFQCN) {
        this.contracts.add(contractFQCN);
    }

    void addQualifierType(String annotation) {
        this.qualifiers.add(annotation);
    }

    void addMetadata(String key, String value) {
        this.metadata.add(key, value);
    }

    public String getName() {
        return this.name;
    }

    public MultiMap<String, String> getMetadata() {
        return this.metadata.readOnly();
    }

    public Collection<String> getQualifiers() {
        return Collections.unmodifiableList(this.qualifiers);
    }

    public Collection<String> getContracts() {
        return Collections.unmodifiableList(this.contracts);
    }

    public String getTypeName() {
        return this.typeName;
    }

    boolean matches(Descriptor another) {
        return DescriptorImpl.matches(this.name, another.getName()) && DescriptorImpl.matches(this.typeName, another.getTypeName()) && DescriptorImpl.matches(this.qualifiers, another.getQualifiers()) && DescriptorImpl.matches(this.contracts, another.getContracts()) && DescriptorImpl.matches(this.metadata, another.getMetadata());
    }

    private static boolean equals(Object o1, Object o2) {
        if (null == o1 && null == o2) {
            return true;
        }
        if (null == o1 || null == o2) {
            return false;
        }
        if (Collection.class.isInstance(o1)) {
            Collection c1 = (Collection)Collection.class.cast(o1);
            Collection c2 = (Collection)Collection.class.cast(o2);
            if (c1.size() != c2.size()) {
                return false;
            }
            Iterator it1 = c1.iterator();
            Iterator it2 = c2.iterator();
            while (it1.hasNext()) {
                if (it1.next().equals(it2.next())) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    private static boolean matches(Object o1, Object o2) {
        if (null == o1) {
            return true;
        }
        if (Collection.class.isInstance(o1)) {
            Collection c1 = (Collection)Collection.class.cast(o1);
            if (Collection.class.isInstance(o2)) {
                return DescriptorImpl.matches(c1, (Collection)Collection.class.cast(o2));
            }
        } else if (MultiMap.class.isInstance(o1) && org.glassfish.hk2.MultiMap.class.isInstance(o2)) {
            return ((MultiMap)MultiMap.class.cast(o1)).matches((org.glassfish.hk2.MultiMap)org.glassfish.hk2.MultiMap.class.cast(o2));
        }
        return DescriptorImpl.equals(o1, o2);
    }

    private static boolean matches(Collection<?> c1, Collection<?> c2) {
        if (null == c1 && null == c2) {
            return true;
        }
        if (null == c1 || null == c2) {
            return false;
        }
        if (c1.size() > c2.size()) {
            return false;
        }
        for (Object o : c1) {
            if (c2.contains(o)) continue;
            return false;
        }
        return true;
    }
}

