/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.ConstructorCreator;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.ScopedInhabitant;
import java.util.ArrayList;
import org.glassfish.hk2.BinderFactory;
import org.glassfish.hk2.DynamicBinderFactory;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.ScopeInstance;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.spi.HK2Provider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.BinderFactoryImpl;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Scope;

public class HK2ProviderImpl
implements HK2Provider {
    public Services create(Services parent, Class<? extends Module> ... moduleTypes) {
        final Habitat habitat = new Habitat(parent, moduleTypes.length > 0 ? this.getModuleName(moduleTypes[0]) : null);
        final DynamicBinderFactory parentBinder = parent == null ? null : parent.bindDynamically();
        final BinderFactoryImpl binderFactory = new BinderFactoryImpl((BinderFactory)parentBinder);
        ArrayList<2> inhabitants = new ArrayList<2>();
        for (Class<? extends Module> moduleType : moduleTypes) {
            ConstructorCreator<? extends Module> inhabitant = new ConstructorCreator<Module>(moduleType, habitat, null);
            final ScopedInhabitant<? extends Module> scopedInhabitant = new ScopedInhabitant<Module>(inhabitant, new Scope(){

                public ScopeInstance current() {
                    return habitat.singletonScope;
                }
            });
            String moduleName = this.getModuleName(moduleType);
            ExistingSingletonInhabitant<Services> servicesInhabitant = new ExistingSingletonInhabitant<Services>((Services)habitat){

                @Override
                public Services get(Inhabitant onBehalfOf) throws ComponentException {
                    if (!scopedInhabitant.isActive()) {
                        Module module = (Module)scopedInhabitant.get(null);
                        module.configure((BinderFactory)binderFactory);
                        if (parentBinder != null) {
                            parentBinder.commit();
                        }
                        binderFactory.registerIn(habitat);
                    }
                    return (Services)super.get(onBehalfOf);
                }
            };
            if (moduleName != null) {
                habitat.addIndex(servicesInhabitant, Module.class.getName(), moduleName);
                habitat.addIndex(servicesInhabitant, Services.class.getName(), moduleName);
            }
            inhabitants.add(servicesInhabitant);
        }
        for (Inhabitant inhabitant : inhabitants) {
            inhabitant.get();
        }
        return habitat;
    }

    public Services create(Services parent, Module ... modules) {
        Habitat habitat = new Habitat(parent, modules.length > 0 ? this.getModuleName(modules[0].getClass()) : null);
        DynamicBinderFactory parentBinder = parent == null ? null : parent.bindDynamically();
        BinderFactoryImpl binderFactory = new BinderFactoryImpl((BinderFactory)parentBinder);
        for (Module module : modules) {
            module.configure((BinderFactory)binderFactory);
            if (parentBinder != null) {
                parentBinder.commit();
            }
            binderFactory.registerIn(habitat);
        }
        return habitat;
    }

    private String getModuleName(Class<? extends Module> module) {
        Service service = module.getAnnotation(Service.class);
        if (service != null) {
            return service.name();
        }
        return null;
    }
}

