/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.UnsatisfiedDependencyException;
import org.jvnet.hk2.component.concurrent.WorkManager;

public class InjectionManager {
    public void inject(Object component, InjectionResolver ... targets) {
        this.syncDoInject(component, null, component.getClass(), targets);
    }

    public void inject(Object component, Inhabitant<?> onBehalfOf, InjectionResolver ... targets) {
        this.syncDoInject(component, onBehalfOf, component.getClass(), targets);
    }

    public void inject(Object component, Inhabitant<?> onBehalfOf, ExecutorService es, InjectionResolver ... targets) {
        try {
            if (null == es) {
                this.syncDoInject(component, onBehalfOf, component.getClass(), targets);
            } else {
                this.asyncDoInject(new InjectContext(component, onBehalfOf, component.getClass(), es, targets));
            }
        }
        catch (Exception e) {
            if (ComponentException.class.isInstance(e)) {
                throw (ComponentException)((Object)ComponentException.class.cast(e));
            }
            throw new ComponentException("injection failed on " + component + "; onBehalfOf: " + onBehalfOf, e);
        }
    }

    public void inject(Object component, Class type, InjectionResolver ... targets) {
        this.syncDoInject(component, null, type, targets);
    }

    protected void syncDoInject(Object component, Inhabitant<?> onBehalfOf, Class type, InjectionResolver ... targets) {
        assert (component != null);
        try {
            for (Class currentClass = type; currentClass != null && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
                Object inject;
                for (Field field : currentClass.getDeclaredFields()) {
                    for (InjectionResolver target : targets) {
                        inject = field.getAnnotation(target.type);
                        if (inject == null) continue;
                        Type genericType = field.getGenericType();
                        Class<?> fieldType = field.getType();
                        try {
                            Object value = target.getValue(component, onBehalfOf, field, genericType, fieldType);
                            if (value != null) {
                                field.setAccessible(true);
                                field.set(component, value);
                                this.handleInjectable(component, value);
                                continue;
                            }
                            if (target.isOptional(field, inject)) continue;
                            throw new UnsatisfiedDependencyException(field, (Annotation)inject);
                        }
                        catch (ComponentException e) {
                            this.error_injectionException(target, (Annotation)inject, field, (Throwable)((Object)e));
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                    }
                }
                for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                    for (InjectionResolver target : targets) {
                        inject = ((Method)accessibleObject).getAnnotation(target.type);
                        if (inject == null) continue;
                        Method setter = target.getSetterMethod((Method)accessibleObject, inject);
                        if (setter.getReturnType() != Void.TYPE) {
                            if (Collection.class.isAssignableFrom(setter.getReturnType())) {
                                this.injectCollection(component, setter, target.getValue(component, onBehalfOf, accessibleObject, null, setter.getReturnType()));
                                continue;
                            }
                            this.error_InjectMethodIsNotVoid((Method)accessibleObject);
                        }
                        Class<?>[] paramTypes = setter.getParameterTypes();
                        Type[] genericParamTypes = setter.getGenericParameterTypes();
                        if (!this.allowInjection((Method)accessibleObject, paramTypes)) continue;
                        try {
                            if (1 == paramTypes.length) {
                                Object value = target.getValue(component, onBehalfOf, accessibleObject, genericParamTypes[0], paramTypes[0]);
                                if (value != null) {
                                    setter.setAccessible(true);
                                    setter.invoke(component, value);
                                    this.handleInjectable(component, value);
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject, (Annotation)inject);
                            }
                            setter.setAccessible(true);
                            Type[] gparamType = setter.getGenericParameterTypes();
                            Object[] params = new Object[paramTypes.length];
                            for (int i = 0; i < paramTypes.length; ++i) {
                                Object value = target.getValue(component, onBehalfOf, accessibleObject, gparamType[i], paramTypes[i]);
                                if (value != null) {
                                    params[i] = value;
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject, (Annotation)inject);
                            }
                            setter.invoke(component, params);
                            for (Object value : params) {
                                this.handleInjectable(component, value);
                            }
                        }
                        catch (ComponentException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, (Throwable)((Object)e));
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (InvocationTargetException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                    }
                }
            }
        }
        catch (LinkageError e) {
            Class cls = type;
            LinkageError x = new LinkageError("injection failed on " + cls + " from " + cls.getClassLoader());
            x.initCause(e);
            throw x;
        }
    }

    protected void asyncDoInject(InjectContext ic) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (Class<?> classType = ic.type; null != classType && Object.class != classType; classType = classType.getSuperclass()) {
            tasks.add(0, new InjectClass(classType, ic));
        }
        WorkManager wm = new WorkManager(ic.es, tasks.size());
        wm.executeAll(tasks);
        try {
            wm.awaitCompletion();
        }
        catch (WorkManager.ExecutionException e) {
            LinkageError cause = e.getCause(LinkageError.class);
            if (null != cause) {
                LinkageError x = new LinkageError("injection failed on " + ic.type + " from " + ic.type.getClassLoader());
                x.initCause((Throwable)((Object)e));
                throw x;
            }
            throw e;
        }
    }

    protected void handleInjectable(Object component, Object value) {
        try {
            Injectable injectable = (Injectable)Injectable.class.cast(value);
            if (injectable != null) {
                injectable.injectedInto(component);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.FINER, "swallowing error", e);
        }
    }

    protected void error_injectionException(InjectionResolver target, Annotation inject, AnnotatedElement injectionPoint, Throwable e) {
        Logger.getAnonymousLogger().log(Level.FINE, "injection failure", e);
        if (UnsatisfiedDependencyException.class.isInstance(e)) {
            if (injectionPoint == ((UnsatisfiedDependencyException)((Object)e)).getUnsatisfiedElement()) {
                throw (UnsatisfiedDependencyException)((Object)e);
            }
            if (target.isOptional(injectionPoint, inject)) {
                return;
            }
            throw new UnsatisfiedDependencyException(injectionPoint, inject, e);
        }
        if (null != e.getCause() && InvocationTargetException.class.isInstance(e)) {
            e = e.getCause();
        }
        throw new ComponentException(UnsatisfiedDependencyException.injection_failed_msg(injectionPoint, inject, e), e);
    }

    protected boolean allowInjection(Method method, Class<?>[] paramTypes) {
        if (paramTypes.length > 1) {
            this.error_InjectMethodHasMultipleParams(method);
        }
        if (paramTypes.length == 0) {
            this.error_InjectMethodHasNoParams(method);
        }
        return true;
    }

    protected void error_InjectMethodHasMultipleParams(Method method) {
        throw new ComponentException("injection failed on %s : setter method takes more than 1 parameter", method.toGenericString());
    }

    protected void error_InjectMethodHasNoParams(Method method) {
        throw new ComponentException("injection failed on %s : setter method does not take a parameter", method.toGenericString());
    }

    protected void error_InjectMethodIsNotVoid(Method method) {
        throw new ComponentException("Injection failed on %s : setter method is not declared with a void return type", method.toGenericString());
    }

    private void injectCollection(Object component, Method method, Object value) {
        if (value == null) {
            return;
        }
        Collection c = (Collection)Collection.class.cast(value);
        Collection target = null;
        try {
            target = (Collection)Collection.class.cast(method.invoke(component, new Object[0]));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        target.addAll(c);
    }

    protected class InjectMethod
    implements Runnable {
        private final InjectContext ic;
        private final Method method;
        private final Annotation inject;
        private final InjectionResolver target;

        public InjectMethod(InjectClass iClass, Method method, Annotation inject, InjectionResolver target) {
            this.ic = iClass.ic;
            this.method = method;
            this.inject = inject;
            this.target = target;
        }

        @Override
        public void run() {
            Class<?>[] paramTypes;
            Method setter = this.target.getSetterMethod(this.method, this.inject);
            if (Void.TYPE != setter.getReturnType()) {
                if (Collection.class.isAssignableFrom(setter.getReturnType())) {
                    InjectionManager.this.injectCollection(this.ic.component, setter, this.target.getValue(this.ic.component, this.ic.onBehalfOf, this.method, null, setter.getReturnType()));
                } else {
                    InjectionManager.this.error_InjectMethodIsNotVoid(this.method);
                }
            }
            if (InjectionManager.this.allowInjection(this.method, paramTypes = setter.getParameterTypes())) {
                try {
                    if (1 == paramTypes.length) {
                        Object value = this.target.getValue(this.ic.component, this.ic.onBehalfOf, this.method, null, paramTypes[0]);
                        if (value != null) {
                            setter.setAccessible(true);
                            setter.invoke(this.ic.component, value);
                            InjectionManager.this.handleInjectable(this.ic.component, value);
                        } else if (!this.target.isOptional(this.method, this.inject)) {
                            throw new UnsatisfiedDependencyException(this.method, this.inject);
                        }
                    } else {
                        setter.setAccessible(true);
                        Type[] gparamType = setter.getGenericParameterTypes();
                        Object[] params = new Object[paramTypes.length];
                        for (int i = 0; i < paramTypes.length; ++i) {
                            Object value = this.target.getValue(this.ic.component, this.ic.onBehalfOf, this.method, gparamType[i], paramTypes[i]);
                            if (value != null) {
                                params[i] = value;
                                continue;
                            }
                            if (this.target.isOptional(this.method, this.inject)) continue;
                            throw new UnsatisfiedDependencyException(this.method, this.inject);
                        }
                        setter.invoke(this.ic.component, params);
                        for (Object value : params) {
                            InjectionManager.this.handleInjectable(this.ic.component, value);
                        }
                    }
                }
                catch (ComponentException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, (Throwable)((Object)e));
                }
                catch (IllegalAccessException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, e);
                }
                catch (InvocationTargetException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, e);
                }
                catch (RuntimeException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, e);
                }
            }
        }
    }

    protected class InjectField
    implements Runnable {
        private final InjectContext ic;
        private final Field field;
        private final Annotation inject;
        private final InjectionResolver target;

        public InjectField(InjectClass iClass, Field field, Annotation inject, InjectionResolver target) {
            this.ic = iClass.ic;
            this.field = field;
            this.inject = inject;
            this.target = target;
        }

        @Override
        public void run() {
            Type genericType = this.field.getGenericType();
            Class<?> fieldType = this.field.getType();
            try {
                Object value = this.target.getValue(this.ic.component, this.ic.onBehalfOf, this.field, genericType, fieldType);
                if (value != null) {
                    this.field.setAccessible(true);
                    this.field.set(this.ic.component, value);
                    InjectionManager.this.handleInjectable(this.ic.component, value);
                } else if (!this.target.isOptional(this.field, this.inject)) {
                    throw new UnsatisfiedDependencyException(this.field, this.inject);
                }
            }
            catch (ComponentException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, (Throwable)((Object)e));
            }
            catch (IllegalAccessException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
            catch (RuntimeException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
        }
    }

    protected class InjectMethods
    implements Runnable {
        private final InjectClass iClass;

        public InjectMethods(InjectClass iClass) {
            this.iClass = iClass;
        }

        @Override
        public void run() {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            for (Method method : this.iClass.classType.getDeclaredMethods()) {
                for (InjectionResolver target : ((InjectClass)this.iClass).ic.targets) {
                    Object inject = method.getAnnotation(target.type);
                    if (inject == null) continue;
                    tasks.add(new InjectMethod(this.iClass, method, (Annotation)inject, target));
                }
            }
            WorkManager wm = new WorkManager(((InjectClass)this.iClass).ic.es, tasks.size());
            wm.executeAll(tasks);
            wm.awaitCompletion();
        }
    }

    protected class InjectFields
    implements Runnable {
        private final InjectClass iClass;

        public InjectFields(InjectClass iClass) {
            this.iClass = iClass;
        }

        @Override
        public void run() {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            for (Field field : this.iClass.classType.getDeclaredFields()) {
                for (InjectionResolver target : ((InjectClass)this.iClass).ic.targets) {
                    Object inject = field.getAnnotation(target.type);
                    if (inject == null) continue;
                    tasks.add(new InjectField(this.iClass, field, (Annotation)inject, target));
                }
            }
            WorkManager wm = new WorkManager(((InjectClass)this.iClass).ic.es, tasks.size());
            wm.executeAll(tasks);
            wm.awaitCompletion();
        }
    }

    protected class InjectClass
    implements Runnable {
        private final Class<?> classType;
        private final InjectContext ic;

        public InjectClass(Class type, InjectContext ic) {
            this.classType = type;
            this.ic = ic;
        }

        @Override
        public void run() {
            WorkManager wm = new WorkManager(this.ic.es, 2);
            wm.execute(new InjectMethods(this));
            wm.execute(new InjectFields(this));
            wm.awaitCompletion();
        }
    }

    protected static class InjectContext {
        public final Object component;
        public final Inhabitant<?> onBehalfOf;
        public final Class<?> type;
        public final ExecutorService es;
        public final InjectionResolver[] targets;

        public InjectContext(Object component, Inhabitant<?> onBehalfOf, Class type, ExecutorService es, InjectionResolver[] targets) {
            assert (null != component);
            this.component = component;
            this.onBehalfOf = onBehalfOf;
            this.type = type;
            this.es = es;
            this.targets = targets;
        }
    }
}

