/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.RunLevelInhabitant;
import com.sun.hk2.component.SoftCache;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Enableable;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatFactory;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantsParserFactory;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.classmodel.ClassPath;
import org.jvnet.hk2.component.classmodel.FileCachingClassPathAdvisor;
import org.jvnet.hk2.component.classmodel.InhabitantsFeed;
import org.jvnet.hk2.component.classmodel.InhabitantsParsingContextGenerator;

public class Hk2TestServices {
    private final Logger logger = Logger.getLogger(Hk2TestServices.class.getName());
    private static final boolean USE_CACHE = true;
    private static final SoftCache<ClassPath, InhabitantsParsingContextGenerator> ipcgCache = new SoftCache();
    private final boolean extendedFileCaching = Boolean.getBoolean("hk2testservices.file.caching");
    private Habitat habitat;
    private final HabitatFactory habitatFactory;
    private final InhabitantsParserFactory ipFactory;
    private final boolean defaultRLSEnabled;
    private FileFilter classpathFilter;

    public Hk2TestServices() {
        this(null, null, true, true, null);
    }

    protected Hk2TestServices(Class<? extends HabitatFactory> habitatFactoryClass, Class<? extends InhabitantsParserFactory> ipFactoryClass, boolean defaultRLSEnabled, boolean rlsConstraintsEnabled, Class<? extends FileFilter> classpathFilter) {
        if (null == habitatFactoryClass || habitatFactoryClass.isInterface()) {
            this.habitatFactory = null;
        } else {
            try {
                this.habitatFactory = habitatFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null == ipFactoryClass || ipFactoryClass.isInterface()) {
            this.ipFactory = null;
        } else {
            try {
                this.ipFactory = ipFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null == classpathFilter || classpathFilter.isInterface()) {
            this.classpathFilter = null;
        } else {
            try {
                this.classpathFilter = classpathFilter.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null == classpathFilter && this.extendedFileCaching) {
            this.classpathFilter = new FileCachingClassPathAdvisor();
        }
        this.defaultRLSEnabled = defaultRLSEnabled;
        RunLevelInhabitant.enable(rlsConstraintsEnabled);
        this.logger.log(Level.FINER, "Singleton created");
        this.habitat = this.createHabitat();
        InhabitantsParser ip = this.createInhabitantsParser(this.habitat);
        this.populateHabitat(this.habitat, ip);
        this.preInitialized();
        this.habitat.initialized();
    }

    protected void populateHabitat(final Habitat habitat, InhabitantsParser ip) {
        final ClassPath classpath = ClassPath.create(habitat, true);
        Callable<InhabitantsParsingContextGenerator> populator = new Callable<InhabitantsParsingContextGenerator>(){

            @Override
            public InhabitantsParsingContextGenerator call() throws Exception {
                InhabitantsParsingContextGenerator ipcgen = InhabitantsParsingContextGenerator.create(habitat, null, null, Hk2TestServices.this.classpathFilter);
                Set<String> cpSet = classpath.getEntries();
                for (String fileName : cpSet) {
                    File f = new File(fileName);
                    if (!f.exists()) continue;
                    try {
                        ipcgen.parse(f);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return ipcgen;
            }
        };
        try {
            InhabitantsFeed feed = InhabitantsFeed.create(habitat, ip);
            InhabitantsParsingContextGenerator ipcgen = ipcgCache.get(classpath, populator);
            feed.populate(ipcgen);
            if (this.logger.isLoggable(Level.FINER)) {
                Iterator<String> contracts = habitat.getAllContracts();
                while (contracts.hasNext()) {
                    String contract = contracts.next();
                    this.logger.log(Level.FINER, "Found contract: {0}", contract);
                    for (Inhabitant<?> t : habitat.getInhabitantsByContract(contract)) {
                        this.logger.log(Level.FINER, " --> {0} {1}", new Object[]{t.typeName(), t.metadata()});
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void preInitialized() {
        RunLevelService rls = this.habitat.getComponent(RunLevelService.class, "default");
        if (Enableable.class.isInstance(rls)) {
            ((Enableable)((Object)rls)).enable(this.defaultRLSEnabled);
        }
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public Habitat createHabitat() throws ComponentException {
        if (null != this.habitatFactory) {
            return this.habitatFactory.newHabitat();
        }
        return new Habitat();
    }

    public Habitat createPopulatedHabitat() throws ComponentException {
        Habitat habitat = this.createHabitat();
        InhabitantsParser ip = this.createInhabitantsParser(habitat);
        this.populateHabitat(habitat, ip);
        habitat.initialized();
        return habitat;
    }

    public InhabitantsParser createInhabitantsParser(Habitat h) throws ComponentException {
        if (null != this.ipFactory) {
            return this.ipFactory.createInhabitantsParser(h);
        }
        return new InhabitantsParser(h);
    }
}

