/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.BCELMethod;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Method;
import com.sun.enterprise.tools.verifier.apiscan.classfile.MethodRef;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BCELClassFile
implements ClassFile {
    private JavaClass jc;
    private Set<String> classNames;
    private HashSet<BCELMethod> methods = new HashSet();
    private static Logger logger = Logger.getLogger("apiscan.classfile");
    private static final String myClassName = "apiscan.classfile.BCELClassFile";

    public BCELClassFile(InputStream is, String file_name) throws IOException {
        logger.entering(myClassName, "<init>(InputStream, String)", file_name);
        this.jc = new ClassParser(is, file_name).parse();
    }

    public BCELClassFile(String file_path) throws IOException {
        logger.entering(myClassName, "<init>(String)", file_path);
        this.jc = new ClassParser(file_path).parse();
    }

    @Override
    public synchronized Collection getAllReferencedClassNamesInInternalForm() {
        if (this.classNames == null) {
            this.classNames = new HashSet<String>();
            logger.logp(Level.FINER, myClassName, "getAllReferencedClassNames", "Starting to visit");
            this.jc.accept((org.apache.bcel.classfile.Visitor)new DescendingVisitor(this.jc, (org.apache.bcel.classfile.Visitor)new Visitor(this)));
            logger.logp(Level.FINER, myClassName, "getAllReferencedClassNames", "Finished visting");
            this.classNames = Collections.unmodifiableSet(this.classNames);
        }
        return this.classNames;
    }

    @Override
    public synchronized Collection<String> getAllReferencedClassNames() {
        if (this.classNames == null) {
            this.getAllReferencedClassNamesInInternalForm();
        }
        HashSet<String> extClassNames = new HashSet<String>(this.classNames.size());
        Iterator<String> i = this.classNames.iterator();
        while (i.hasNext()) {
            extClassNames.add(Util.convertToExternalClassName(i.next()));
        }
        return extClassNames;
    }

    @Override
    public String getName() {
        return this.jc.getClassName();
    }

    @Override
    public String getInternalName() {
        return Util.convertToInternalClassName(this.getName());
    }

    @Override
    public String getPackageName() {
        return this.jc.getPackageName();
    }

    @Override
    public Collection<? extends Method> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public Method getMethod(MethodRef methodRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNameOfSuperClass() {
        return this.jc.getSuperclassName();
    }

    @Override
    public String getInternalNameOfSuperClass() {
        return Util.convertToInternalClassName(this.getNameOfSuperClass());
    }

    @Override
    public String[] getNamesOfInterfaces() {
        return this.jc.getInterfaceNames();
    }

    @Override
    public String[] getInternalNamesOfInterfaces() {
        String[] result = this.getNamesOfInterfaces();
        for (int i = 0; i < result.length; ++i) {
            result[i] = Util.convertToInternalClassName(result[i]);
        }
        return result;
    }

    @Override
    public boolean isInterface() {
        return !this.jc.isClass();
    }

    @Override
    public boolean isPublic() {
        return this.jc.isPublic();
    }

    public String toString() {
        return "External Name: " + this.getName() + "\n" + "Internal Name: " + this.getInternalName() + "\n" + this.jc.toString() + "\n------------CONSTANT POOL BEGIN--------------\n" + this.jc.getConstantPool() + "\n------------CONSTANT POOL END--------------";
    }

    private static List<String> signatureToClassNames(String signature) {
        int j;
        logger.entering(myClassName, "signatureToClassNames", signature);
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((i = signature.indexOf(76, i)) != -1 && (j = signature.indexOf(59, i)) > i) {
            String className = signature.substring(i + 1, j);
            if (!Util.isPrimitive(className)) {
                result.add(className);
            }
            i = j + 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer("Class Names are {");
            int size = result.size();
            for (int k = 0; k < size; ++k) {
                sb.append((String)result.get(k));
                if (k == size - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            logger.finer(sb.toString());
        }
        return result;
    }

    private class Visitor
    extends EmptyVisitor {
        BCELClassFile cf;

        public Visitor(BCELClassFile cf) {
            this.cf = cf;
        }

        public void visitConstantClass(ConstantClass obj) {
            logger.entering(BCELClassFile.myClassName, "visitConstantClass", obj);
            String className = obj.getBytes(BCELClassFile.this.jc.getConstantPool());
            logger.finer("Class name is " + className);
            if (className.indexOf(59) != -1 || className.indexOf(91) != -1) {
                BCELClassFile.this.classNames.addAll(BCELClassFile.signatureToClassNames(className));
            } else {
                BCELClassFile.this.classNames.add(className);
            }
        }

        public void visitField(Field field) {
            logger.entering(BCELClassFile.myClassName, "visitField", field);
            String signature = field.getSignature();
            logger.finer("Signature is " + signature);
            BCELClassFile.this.classNames.addAll(BCELClassFile.signatureToClassNames(signature));
        }

        public synchronized void visitMethod(org.apache.bcel.classfile.Method method) {
            logger.entering(BCELClassFile.myClassName, "visitMethod", method);
            String signature = method.getSignature();
            logger.finer("Signature is " + signature);
            BCELClassFile.this.methods.add(new BCELMethod(this.cf, method));
            BCELClassFile.this.classNames.addAll(BCELClassFile.signatureToClassNames(signature));
        }
    }
}

