/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.hk2;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.common_impl.DefaultModuleDefinition;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDependencyAnalyser {
    ModuleDefinition moduleDef;
    ClosureCompilerImpl closure;
    Repository moduleRepository;
    String[] excludedPatterns = new String[]{"java.", "org.jvnet.hk2.", "com.sun.hk2.", "com.sun.enterprise.module."};
    private File moduleJar;

    public ModuleDependencyAnalyser(ModuleDefinition moduleDef, Repository moduleRepository) throws IOException {
        this.moduleDef = moduleDef;
        this.moduleRepository = moduleRepository;
        this.moduleJar = new File(moduleDef.getLocations()[0]);
        String classpath = this.moduleJar.getAbsolutePath();
        ClassFileLoader cfl = ClassFileLoaderFactory.newInstance(new Object[]{classpath});
        this.closure = new ClosureCompilerImpl(cfl);
        for (String pattern : this.excludedPatterns) {
            this.closure.addExcludedPattern(pattern);
        }
        this.excludeImportedPackages();
        this.excludeExportedClasses();
    }

    public synchronized boolean analyse() throws IOException {
        this.closure.buildClosure(new JarFile(this.moduleJar));
        if (System.getProperty("debugOutput") != null) {
            Logger.getLogger("apiscan.classfile").setLevel(Level.FINER);
            PrintStream out = new PrintStream(new FileOutputStream(System.getProperty("debugOutput")));
            out.println(this.closure);
        }
        return this.closure.getFailed().isEmpty();
    }

    public void excludePatterns(Collection<String> patterns) {
        for (String p : patterns) {
            this.closure.addExcludedPattern(p.trim());
        }
    }

    public void excludePackages(Collection<String> packages) {
        for (String p : packages) {
            this.closure.addExcludedPackage(p);
        }
    }

    public void excludeClasses(Collection<String> classes) {
        for (String c : classes) {
            this.closure.addExcludedClass(c);
        }
    }

    public Map<String, Collection<String>> getResult() {
        return this.closure.getFailed();
    }

    private void excludeImportedPackages() {
        Attributes attributes = this.moduleDef.getManifest().getMainAttributes();
        String exportedPkgsAttr = attributes.getValue("Import-Package");
        if (exportedPkgsAttr == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(exportedPkgsAttr, ",", false);
        HashSet<String> importedPkgs = new HashSet<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int idx = token.indexOf(59);
            String pkg = idx == -1 ? token : token.substring(0, idx);
            importedPkgs.add(pkg);
        }
        for (String pkg : importedPkgs) {
            this.closure.addExcludedPackage(pkg);
        }
    }

    private void excludeExportedClasses() throws IOException {
        ModuleDependency[] dependencies;
        for (ModuleDependency dependency : dependencies = this.moduleDef.getDependencies()) {
            ModuleDefinition requiredModuleDef = this.moduleRepository.find(dependency.getName(), dependency.getVersion());
            for (String cls : this.getExportedClasses(requiredModuleDef)) {
                this.closure.addExcludedClass(cls);
            }
        }
    }

    private Set<String> getExportedClasses(ModuleDefinition moduleDef) throws IOException {
        HashSet<String> exportedPkgs = new HashSet<String>();
        Manifest m = moduleDef.getManifest();
        if (m == null) {
            return exportedPkgs;
        }
        Attributes attributes = m.getMainAttributes();
        String exportedPkgsAttr = attributes.getValue("Export-Package");
        StringTokenizer st = new StringTokenizer(exportedPkgsAttr, ",", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int idx = token.indexOf(59);
            String pkg = idx == -1 ? token : token.substring(0, idx);
            exportedPkgs.add(pkg);
        }
        HashSet<String> exportedClasses = new HashSet<String>();
        JarFile moduleJar = new JarFile(new File(moduleDef.getLocations()[0]));
        Enumeration<JarEntry> moduleEntries = moduleJar.entries();
        while (moduleEntries.hasMoreElements()) {
            String clsName;
            String pkgName;
            String entry = moduleEntries.nextElement().getName();
            if (!entry.endsWith(".class") || !exportedPkgs.contains(pkgName = Util.getPackageName(clsName = Util.convertToExternalClassName(entry.substring(0, entry.length() - ".class".length()))))) continue;
            exportedClasses.add(clsName);
        }
        return exportedClasses;
    }

    public String getResultAsString() {
        StringBuilder sb = new StringBuilder();
        Map failed = this.closure.getFailed();
        if (failed.isEmpty()) {
            return "";
        }
        for (String referencingPath : failed.keySet()) {
            int idx = referencingPath.lastIndexOf(47);
            String referencingClass = idx == -1 ? referencingPath : referencingPath.substring(idx + 1);
            sb.append("\t").append(referencingClass);
            sb.append(" -> {");
            String[] notFoundClasses = ((Collection)failed.get(referencingPath)).toArray(new String[0]);
            for (int i = 0; i < notFoundClasses.length; ++i) {
                sb.append(notFoundClasses[i]);
                if (i == notFoundClasses.length - 1) continue;
                sb.append(", ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public void printResult(PrintStream out) {
        out.println(this.getResultAsString());
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: java " + ModuleDependencyAnalyser.class.getName() + " <Repository Dir Path> [Path to module]...");
            System.out.println("Examples:\n1. Following command verifies all modules in the specified repository:\n java " + ModuleDependencyAnalyser.class.getName() + " /tmp/glassfish/modules/\n\n" + "2. Following command verifies only the specified modules in the specified repository:\n" + " java " + ModuleDependencyAnalyser.class.getName() + " /tmp/glassfish/modules/ kernel-10.0-SNAPSHOT.jar amx-impl-10.0SNAPSHOT.jar\n\n");
            return;
        }
        String repoPath = args[0];
        File f = new File(repoPath){

            public File[] listFiles() {
                ArrayList<File> files = new ArrayList<File>();
                for (File f : super.listFiles()) {
                    if (f.isDirectory()) {
                        for (File f2 : f.listFiles()) {
                            if (!f2.isFile() || !f2.getName().endsWith(".jar")) continue;
                            files.add(f2);
                        }
                        continue;
                    }
                    if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                    files.add(f);
                }
                return files.toArray(new File[files.size()]);
            }
        };
        DirectoryBasedRepository moduleRepository = new DirectoryBasedRepository("repo", f);
        moduleRepository.initialize();
        List<ModuleDefinition> moduleDefs = new ArrayList();
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                File moduleFile = new File(args[i]);
                if (!moduleFile.isAbsolute()) {
                    moduleFile = new File(repoPath, args[i]);
                }
                ModuleDefinition moduleDef = new DefaultModuleDefinition(moduleFile);
                moduleDefs.add(moduleDef);
            }
        } else {
            moduleDefs = moduleRepository.findAll();
        }
        ArrayList<URI> badModules = new ArrayList<URI>();
        for (ModuleDefinition moduleDef : moduleDefs) {
            ModuleDependencyAnalyser analyser = new ModuleDependencyAnalyser(moduleDef, (Repository)moduleRepository);
            if (System.getProperty("ExcludedPatterns") != null) {
                StringTokenizer st = new StringTokenizer(System.getProperty("ExcludedPatterns"), ",", false);
                HashSet<String> patterns = new HashSet<String>();
                while (st.hasMoreTokens()) {
                    patterns.add(st.nextToken());
                }
                analyser.excludePatterns(patterns);
            }
            if (analyser.analyse()) continue;
            URI badModule = moduleRepository.getLocation().relativize(moduleDef.getLocations()[0]);
            badModules.add(badModule);
            System.out.println("<Module name = " + badModule + ">");
            System.out.println(analyser.getResultAsString());
            System.out.println("</Module>");
        }
        if (badModules.isEmpty()) {
            System.out.println("All modules are OK");
        } else {
            System.out.println("Dependencies are not correctly set up for following modules:");
            for (URI badModule : badModules) {
                System.out.print(badModule + " ");
            }
            System.out.println("");
        }
    }
}

