/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.hk2;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.osgiadapter.OSGiDirectoryBasedRepository;
import org.jvnet.hk2.osgiadapter.OSGiFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageAnalyser {
    private Set<Bundle> bundles;
    private Logger logger;
    private Repository moduleRepository;

    public PackageAnalyser(Repository moduleRepository) {
        this(moduleRepository, Logger.getAnonymousLogger());
    }

    public PackageAnalyser(Repository repo, Logger logger) {
        this.moduleRepository = repo;
        this.logger = logger;
    }

    public void analyse(Bundle bundle) throws IOException {
        bundle.requiredBundles = this.computeRequiredBundles(bundle);
        bundle.exportedPkgs = this.computeExportedPackages(bundle);
        bundle.requiredPkgs = this.computeRequiredPackages(bundle);
    }

    private Set<String> computeRequiredPackages(Bundle bundle) throws IOException {
        HashSet<String> requiredPkgs = new HashSet<String>();
        File moduleFile = new File(bundle.md.getLocations()[0]);
        String classpath = moduleFile.getAbsolutePath();
        JarFile moduleJar = new JarFile(moduleFile);
        ClassFileLoader cfl = ClassFileLoaderFactory.newInstance(new Object[]{classpath});
        String classExt = ".class";
        Enumeration<JarEntry> entries = moduleJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            if (!je.getName().endsWith(".class")) continue;
            String className = Util.convertToExternalClassName(je.getName().substring(0, je.getName().length() - ".class".length()));
            ClassFile cf = null;
            try {
                cf = cfl.load(className);
                for (String c : cf.getAllReferencedClassNames()) {
                    requiredPkgs.add(Util.getPackageName(c));
                }
            }
            catch (IOException e) {
                this.logger.logp(Level.FINE, "PackageAnalyser", "computeRequiredPackages", "Skipping analysis of {0} as the following exception was thrown:\n {1}", new Object[]{className, e});
            }
        }
        return requiredPkgs;
    }

    private Set<String> computeExportedPackages(Bundle bundle) {
        int i1;
        HashSet<String> exportedPkgs = new HashSet<String>();
        String exportedPkgsAttr = bundle.md.getManifest().getMainAttributes().getValue("Export-Package");
        if (exportedPkgsAttr == null) {
            return exportedPkgs;
        }
        while ((i1 = exportedPkgsAttr.indexOf(34)) != -1) {
            int i2 = exportedPkgsAttr.indexOf(34, i1 + 1);
            StringBuilder sb = new StringBuilder();
            sb.append(exportedPkgsAttr.substring(0, i1));
            sb.append(exportedPkgsAttr.substring(i2 + 1));
            exportedPkgsAttr = sb.toString();
        }
        StringTokenizer st = new StringTokenizer(exportedPkgsAttr, ",", false);
        while (st.hasMoreTokens()) {
            String pkg;
            String pkgGroups = st.nextToken().trim();
            int idx = pkgGroups.indexOf(59);
            StringTokenizer st2 = new StringTokenizer(pkgGroups, ";", false);
            while (st2.hasMoreTokens() && (pkg = st2.nextToken()).indexOf(61) == -1) {
                exportedPkgs.add(pkg);
            }
        }
        return exportedPkgs;
    }

    private Set<Bundle> computeRequiredBundles(Bundle bundle) {
        HashSet<Bundle> requiredBundles = new HashSet<Bundle>();
        for (ModuleDependency dep : bundle.md.getDependencies()) {
            ModuleDefinition md = this.moduleRepository.find(dep.getName(), dep.getVersion());
            if (md != null) {
                requiredBundles.add(new Bundle(md));
                continue;
            }
            System.out.println("WARNING: Missing dependency: [" + dep + "] for module [" + bundle.getName() + "]");
        }
        return requiredBundles;
    }

    public Collection<Wire> analyseWirings() throws IOException {
        List moduleDefs = this.moduleRepository.findAll();
        this.bundles = new HashSet<Bundle>();
        for (ModuleDefinition moduleDef : moduleDefs) {
            Bundle bundle = new Bundle(moduleDef);
            this.bundles.add(bundle);
            this.analyse(bundle);
        }
        HashSet<Wire> wires = new HashSet<Wire>();
        for (Bundle importer : this.bundles) {
            for (String pkg : importer.requiredPkgs) {
                for (Bundle exporter : this.bundles) {
                    if (!exporter.exportedPkgs.contains(pkg)) continue;
                    Wire w = new Wire(pkg, importer, exporter);
                    wires.add(w);
                }
            }
        }
        ArrayList<Wire> sorted = new ArrayList<Wire>(wires);
        Collections.sort(sorted, new Comparator<Wire>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(Wire o1, Wire o2) {
                return this.collator.compare(o1.pkg, o2.pkg);
            }
        });
        return sorted;
    }

    public Collection<SplitPackage> findSplitPackages() {
        assert (this.bundles != null);
        HashMap<String, HashSet<Bundle>> packages = new HashMap<String, HashSet<Bundle>>();
        for (Bundle b : this.bundles) {
            for (String p : b.exportedPkgs) {
                HashSet<Bundle> exporters = (HashSet<Bundle>)packages.get(p);
                if (exporters == null) {
                    exporters = new HashSet<Bundle>();
                    packages.put(p, exporters);
                }
                exporters.add(b);
            }
        }
        HashSet<SplitPackage> splitPkgs = new HashSet<SplitPackage>();
        for (Map.Entry entry : packages.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            splitPkgs.add(new SplitPackage((String)entry.getKey(), (Set)entry.getValue()));
        }
        ArrayList<SplitPackage> sortedSplitPkgs = new ArrayList<SplitPackage>(splitPkgs);
        Collections.sort(sortedSplitPkgs, new Comparator<SplitPackage>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(SplitPackage o1, SplitPackage o2) {
                return this.collator.compare(o1.name, o2.name);
            }
        });
        return sortedSplitPkgs;
    }

    public Collection<String> findAllExportedPackages() {
        HashSet<String> packages = new HashSet<String>();
        for (Bundle b : this.bundles) {
            packages.addAll(b.exportedPkgs);
        }
        ArrayList<String> sorted = new ArrayList<String>(packages);
        Collections.sort(sorted, new Comparator<String>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(String o1, String o2) {
                return this.collator.compare(o1, o2);
            }
        });
        return sorted;
    }

    public Set<Bundle> findAllBundles() {
        return this.bundles;
    }

    public Collection<String> findUnusedExports() {
        ArrayList<String> unusedPackages = new ArrayList<String>();
        for (Bundle exporter : this.bundles) {
            for (String p : exporter.exportedPkgs) {
                boolean used = false;
                for (Bundle importer : this.bundles) {
                    if (importer == exporter || !importer.requiredPkgs.contains(p)) continue;
                    used = true;
                    break;
                }
                if (used) continue;
                unusedPackages.add(p);
            }
        }
        Collections.sort(unusedPackages, new Comparator<String>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(String o1, String o2) {
                return this.collator.compare(o1, o2);
            }
        });
        return unusedPackages;
    }

    public void generateWiringReport(Collection<String> exportedPkgs, Collection<Wire> wires, PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.println("<?xml-stylesheet type=\"text/xsl\" href=\"wires.xsl\"?>");
        out.println("<Wires>");
        for (String p : exportedPkgs) {
            StringBuilder sb = new StringBuilder();
            sb.append("\t<Package name = \"" + p + "\">\n");
            sb.append("\t\t<Exporters>\n");
            HashSet<String> exporters = new HashSet<String>();
            for (Wire w : wires) {
                if (!w.getPkg().equals(p)) continue;
                exporters.add(w.getExporter().getName());
            }
            for (String e : exporters) {
                sb.append(e + " ");
            }
            sb.append("\n\t\t</Exporters>\n");
            sb.append("\t\t<Importers>\n");
            for (Wire w : wires) {
                if (!w.getPkg().equals(p)) continue;
                sb.append(w.getImporter().getName() + " ");
            }
            sb.append("\n\t\t</Importers>\n");
            sb.append("\t</Package>");
            out.println(sb);
        }
        out.println("</Wires>");
    }

    public void generateBundleReport(PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.println("<?xml-stylesheet type=\"text/xsl\" href=\"bundles.xsl\"?>");
        out.println("<Bundles>");
        for (Bundle b : this.bundles) {
            StringBuilder sb = new StringBuilder();
            sb.append("\t<Bundle name = \"" + b.getName() + "\">\n");
            sb.append("\t\t<Exports>\n");
            ArrayList<String> sorted = new ArrayList<String>(b.exportedPkgs);
            Collections.sort(sorted, new Comparator<String>(){
                Collator collator = Collator.getInstance();

                @Override
                public int compare(String o1, String o2) {
                    return this.collator.compare(o1, o2);
                }
            });
            int i = 0;
            for (String p : sorted) {
                sb.append("\t\t\t" + p);
                if (++i < sorted.size()) {
                    sb.append(",\\");
                }
                sb.append("\n");
            }
            sb.append("\t\t</Exports>\n");
            sb.append("\t</Bundle>");
            out.println(sb);
        }
        out.println("</Bundles>");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.out.println("Usage: java " + PackageAnalyser.class.getName() + " <Repository Dir Path> <output file name for bundle details>" + " <output file name for wiring details> <output file name for split-packages> <output file name for unused packages>");
            System.out.println("Example(s):\nFollowing command analyses all modules in the specified repository:\n java " + PackageAnalyser.class.getName() + " /tmp/glassfish/modules/ bundles.xml wires.xml sp.txt unused.txt\n\n");
            return;
        }
        String repoPath = args[0];
        PrintStream bundleOut = new PrintStream(new FileOutputStream(args[1]));
        PrintStream wireOut = new PrintStream(new FileOutputStream(args[2]));
        PrintStream spOut = new PrintStream(new FileOutputStream(args[3]));
        PrintStream unusedPkgOut = new PrintStream(new FileOutputStream(args[4]));
        File f = new File(repoPath){

            public File[] listFiles() {
                ArrayList<File> files = new ArrayList<File>();
                for (File f : super.listFiles()) {
                    if (f.isDirectory()) {
                        for (File f2 : f.listFiles()) {
                            if (!f2.isFile() || !f2.getName().endsWith(".jar")) continue;
                            files.add(f2);
                        }
                        continue;
                    }
                    if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                    files.add(f);
                }
                return files.toArray(new File[files.size()]);
            }
        };
        OSGiFactoryImpl.initialize(null);
        OSGiDirectoryBasedRepository moduleRepository = new OSGiDirectoryBasedRepository("repo", f);
        moduleRepository.initialize();
        PackageAnalyser analyser = new PackageAnalyser((Repository)moduleRepository);
        Collection<Wire> wires = analyser.analyseWirings();
        Collection<String> exportedPkgs = analyser.findAllExportedPackages();
        analyser.generateBundleReport(bundleOut);
        analyser.generateWiringReport(exportedPkgs, wires, wireOut);
        Collection<SplitPackage> splitPkgs = analyser.findSplitPackages();
        for (SplitPackage p : splitPkgs) {
            spOut.println(p + "\n");
        }
        spOut.println("Total number of Split Packages = " + splitPkgs.size());
        Collection<String> unusedPackages = analyser.findUnusedExports();
        for (String p : unusedPackages) {
            unusedPkgOut.println(p + "\n");
        }
        spOut.println("Total number of Unused Packages = " + unusedPackages.size());
        System.out.println("******** GROSS STATISTICS *********");
        System.out.println("Total number of bundles in this repository: " + analyser.findAllBundles().size());
        System.out.println("Total number of wires = " + wires.size());
        System.out.println("Total number of exported packages = " + exportedPkgs.size());
        System.out.println("Total number of split-packages = " + splitPkgs.size());
        System.out.println("Total number of unused-packages = " + unusedPackages.size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitPackage {
        String name;
        Set<Bundle> exporters = new HashSet<Bundle>();

        public SplitPackage(String name, Set<Bundle> exporters) {
            this.name = name;
            this.exporters = exporters;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SplitPackage) {
                return this.name.equals(SplitPackage.class.cast(obj));
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("name " + this.name + " (" + this.exporters.size() + " times):\n");
            for (Bundle b : this.exporters) {
                sb.append(b.md.getName() + "\n");
            }
            return sb.toString();
        }
    }

    public static class Wire {
        String pkg;
        Bundle exporter;
        Bundle importer;

        public Wire(String pkg, Bundle importer, Bundle exporter) {
            this.exporter = exporter;
            this.importer = importer;
            this.pkg = pkg;
        }

        public String getPkg() {
            return this.pkg;
        }

        public Bundle getExporter() {
            return this.exporter;
        }

        public Bundle getImporter() {
            return this.importer;
        }

        public int hashCode() {
            return this.pkg.hashCode();
        }

        public boolean equals(Object obj) {
            boolean b = false;
            if (obj instanceof Wire) {
                Wire other = (Wire)Wire.class.cast(obj);
                b = this.pkg.equals(other.pkg);
                if (b) {
                    if (this.exporter != null) {
                        b = this.exporter.equals(other.exporter);
                    } else {
                        boolean bl = b = other.exporter == null;
                    }
                    if (b) {
                        b = this.importer != null ? this.importer.equals(other.importer) : other.importer == null;
                    }
                }
            }
            return b;
        }

        public String toString() {
            return "Wire [Package = " + this.pkg + ", Importer = " + this.importer.md.getName() + ", Exporter = " + this.exporter.md.getName() + "]";
        }
    }

    public static class Bundle {
        ModuleDefinition md;
        Set<String> exportedPkgs = new HashSet<String>();
        Set<String> requiredPkgs = new HashSet<String>();
        Set<Bundle> requiredBundles = new HashSet<Bundle>();

        Bundle(ModuleDefinition md) {
            this.md = md;
        }

        public int hashCode() {
            return this.md.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bundle) {
                return this.md.equals(((Bundle)Bundle.class.cast((Object)obj)).md);
            }
            return false;
        }

        public String getName() {
            return this.md.getName();
        }
    }
}

