/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.AbstractRepositoryImpl;
import com.sun.enterprise.module.common_impl.ModuleId;
import com.sun.enterprise.module.maven.IOException2;
import com.sun.enterprise.module.maven.MavenModuleDefinition;
import com.sun.enterprise.module.maven.Packager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectRepository
extends AbstractRepositoryImpl {
    private final MavenProject project;
    private final ArtifactResolver artifactResolver;
    private final ArtifactRepository localRepository;
    private final ArtifactFactory artifactFactory;
    private final Map<String, Artifact> artifacts = new HashMap<String, Artifact>();
    private static final String TOKEN = "([^:]+)";
    private static final Pattern ID_PATTERN = Pattern.compile(MessageFormat.format("{0}:{0}:{0}(?:\\:{0})?:{0}", "([^:]+)"));
    private static final Logger logger = Logger.getLogger(MavenProjectRepository.class.getName());

    public MavenProjectRepository(MavenProject project, ArtifactResolver artifactResolver, ArtifactRepository localRepository, ArtifactFactory artifactFactory) {
        super(project.getName(), project.getFile().toURI());
        this.project = project;
        this.artifactResolver = artifactResolver;
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        Artifact ma = project.getArtifact();
        if (ma.getFile() != null) {
            this.artifacts.put(ma.getId(), ma);
        }
        for (Artifact a : project.getArtifacts()) {
            this.artifacts.put(a.getId(), a);
        }
    }

    public static void prepareProject(MavenProject project) throws IOException {
        Artifact ma = project.getArtifact();
        if (!project.getPackaging().equals("pom") && ma.getFile() == null) {
            File outdir = new File(project.getBuild().getOutputDirectory());
            if (!outdir.exists()) {
                logger.warning("No output directory " + outdir);
            } else {
                ma.setFile(outdir);
            }
        }
        if (ma.getFile() != null && ma.getFile().isDirectory()) {
            new Packager().writeManifest(project, ma.getFile());
        }
    }

    protected void loadModuleDefs(Map<ModuleId, ModuleDefinition> moduleDefs, List<URI> libraries) throws IOException {
        logger.info("Loading modules list from " + this.project.getFile());
        MavenModuleDefinition main = this.buildModule(this.project.getArtifact(), moduleDefs, libraries);
        if (main != null) {
            main.addClasspath(new File(this.project.getBuild().getOutputDirectory()));
            for (Resource res : this.project.getBuild().getResources()) {
                main.addClasspath(new File(res.getDirectory()));
            }
        }
        for (Artifact a : this.project.getAttachedArtifacts()) {
            this.buildModule(a, moduleDefs, libraries);
        }
        for (Artifact a : this.project.getArtifacts()) {
            this.buildModule(a, moduleDefs, libraries);
        }
        if (moduleDefs.isEmpty()) {
            logger.warning("No modules found");
        }
    }

    private MavenModuleDefinition buildModule(Artifact a, Map<ModuleId, ModuleDefinition> moduleDefs, List<URI> libraries) throws IOException {
        File jarFile = a.getFile();
        if (jarFile == null || !jarFile.getName().endsWith(".jar") && !jarFile.isDirectory()) {
            return null;
        }
        MavenModuleDefinition moduleDef = this.loadJar(jarFile);
        if (moduleDef.getManifest().getMainAttributes().getValue("HK2-Bundle-Name") == null) {
            libraries.add(jarFile.toURI());
            return null;
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Adding module " + a.getId() + " trail: " + a.getDependencyTrail());
        }
        moduleDefs.put(AbstractFactory.getInstance().createModuleId((ModuleDefinition)moduleDef), (ModuleDefinition)moduleDef);
        return moduleDef;
    }

    File resolveArtifact(String id) throws IOException {
        Artifact artifact = this.artifacts.get(id);
        if (artifact != null) {
            return artifact.getFile();
        }
        try {
            Matcher m = ID_PATTERN.matcher(id);
            if (!m.matches()) {
                throw new IllegalArgumentException("Wrong ID: " + id);
            }
            Artifact a = this.artifactFactory.createArtifactWithClassifier(m.group(1), m.group(2), m.group(5), m.group(3), m.group(4));
            this.artifactResolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
            this.artifacts.put(a.getId(), a);
            return a.getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new IOException2("Failed to resolve " + id, e);
        }
        catch (ArtifactNotFoundException e) {
            throw new IOException2("Failed to resolve " + id, e);
        }
    }

    protected MavenModuleDefinition loadJar(File jar) throws IOException {
        return new MavenModuleDefinition(this, jar);
    }
}

