/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.ImportPolicy;
import com.sun.enterprise.module.LifecyclePolicy;
import com.sun.enterprise.module.common_impl.Jar;
import com.sun.enterprise.module.maven.TokenListBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeManifest(MavenProject pom, File classesDirectory) throws IOException {
        Manifest mf = new Manifest();
        for (Map.Entry<String, String> e : this.configureManifest(pom, null, classesDirectory).entrySet()) {
            mf.getMainAttributes().put(new Attributes.Name(e.getKey()), e.getValue());
        }
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        File manifest = new File(classesDirectory, "META-INF/MANIFEST.MF");
        manifest.getParentFile().mkdir();
        FileOutputStream os = new FileOutputStream(manifest);
        try {
            mf.write(os);
        }
        finally {
            os.close();
        }
    }

    public Map<String, String> configureManifest(MavenProject pom, MavenArchiveConfiguration archive, File classesDirectory) throws IOException {
        HashMap<String, String> entries = archive != null ? archive.getManifestEntries() : new HashMap<String, String>();
        entries.put("HK2-Bundle-Name", pom.getGroupId() + ':' + pom.getArtifactId());
        this.configureImportPolicy(classesDirectory, entries, ImportPolicy.class, "HK2-Module-Import-Policy");
        this.configureImportPolicy(classesDirectory, entries, LifecyclePolicy.class, "HK2-Module-Lifecycle-Policy");
        TokenListBuilder dependencyModuleNames = new TokenListBuilder();
        HashSet<String> dependencyModules = new HashSet<String>();
        for (Artifact a : pom.getDependencyArtifacts()) {
            Jar jar;
            if (a.getScope() != null && a.getScope().equals("test")) continue;
            if (a.getFile() == null) {
                throw new AssertionError((Object)(a.getId() + " is not resolved. a=" + a));
            }
            try {
                jar = Jar.create((File)a.getFile());
            }
            catch (IOException ioe) {
                continue;
            }
            Manifest manifest = jar.getManifest();
            String name = null;
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                name = attributes.getValue("HK2-Bundle-Name");
            }
            if (name == null) continue;
            if (!a.isOptional()) {
                dependencyModuleNames.add(name);
            }
            dependencyModules.add(a.getGroupId() + '.' + a.getArtifactId() + ':' + a.getVersion());
        }
        if (!dependencyModuleNames.isEmpty()) {
            entries.put("HK2-Import-Bundles", dependencyModuleNames.toString());
        }
        TokenListBuilder classPathNames = new TokenListBuilder(" ");
        TokenListBuilder classPathIds = new TokenListBuilder(" ");
        for (Artifact a : pom.getArtifacts()) {
            boolean throughModule = false;
            for (String module : dependencyModules) {
                throughModule |= a.getDependencyTrail().get(1).toString().startsWith(module);
            }
            if (throughModule || a.getScope().equals("system") || a.getScope().equals("provided") || a.getScope().equals("test") || a.isOptional()) continue;
            classPathNames.add(Packager.stripVersion(a));
            classPathIds.add(a.getId());
        }
        if (!classPathNames.isEmpty()) {
            String existingClassPath = (String)entries.get("Class-Path");
            if (existingClassPath != null) {
                entries.put("Class-Path", existingClassPath + " " + classPathNames);
            } else {
                entries.put("Class-Path", classPathNames.toString());
            }
            entries.put("HK2-Class-Path-Id", classPathIds.toString());
        }
        return entries;
    }

    private void configureImportPolicy(File classesDirectory, Map<String, String> entries, Class<?> clazz, String entryName) throws IOException {
        File importPolicy = new File(classesDirectory, "META-INF/services/" + clazz.getName());
        if (importPolicy.exists()) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(importPolicy), "UTF-8"));
            entries.put(entryName, in.readLine());
            in.close();
        }
    }

    private static String stripVersion(Artifact a) {
        String origName;
        String newName = origName = a.getFile().getName();
        int idx = origName.lastIndexOf(a.getVersion());
        if (idx != -1) {
            String baseFilename = origName.substring(0, idx - 1);
            String extension = origName.substring(idx + a.getVersion().length());
            newName = baseFilename + extension;
        }
        return newName;
    }
}

