/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2;

import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.istack.test.AntXmlFormatter;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;
import org.jvnet.hk2.HK2TestCase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class TestRunner
implements ModuleStartup {
    StartupContext context;
    @Inject
    Habitat habitat;

    public void setStartupContext(StartupContext context) {
        this.context = context;
    }

    public void start() {
        File reportDir = null;
        if (this.context.getArguments().containsKey("-r")) {
            reportDir = new File(this.context.getArguments().getProperty("-r"));
        }
        this.runTests(reportDir);
    }

    public void stop() {
    }

    public TestResult runTests(final File reportDir) {
        TestSuite ts = new TestSuite();
        for (Inhabitant testCase : this.habitat.getInhabitants(HK2TestCase.class)) {
            ts.addTestSuite(testCase.type());
        }
        junit.textui.TestRunner testRunner = new junit.textui.TestRunner(){
            private AntXmlFormatter formatter;

            protected TestResult createTestResult() {
                TestResult result = super.createTestResult();
                if (TestRunner.this.context.getArguments().containsKey("-r")) {
                    reportDir.mkdirs();
                    this.formatter = new AntXmlFormatter(XMLJUnitResultFormatter.class, reportDir);
                    result.addListener((TestListener)this.formatter);
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TestResult doRun(Test test) {
                try {
                    TestResult testResult = super.doRun(test);
                    return testResult;
                }
                finally {
                    if (this.formatter != null) {
                        this.formatter.close();
                    }
                }
            }
        };
        return testRunner.doRun((Test)ts);
    }
}

