/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.compiler;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.UIText;
import com.sun.facelets.el.ELText;
import com.sun.facelets.tag.TextHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.util.FastWriter;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

final class UITextHandler
implements FaceletHandler,
TextHandler {
    private final ELText txt;
    private final String alias;
    private final int length;

    public UITextHandler(String alias, ELText txt) {
        this.alias = alias;
        this.txt = txt;
        this.length = txt.toString().length();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent != null) {
            try {
                ELText nt = this.txt.apply(ctx.getExpressionFactory(), ctx);
                UIText c = new UIText(this.alias, nt);
                c.setId(ComponentSupport.getViewRoot(ctx, parent).createUniqueId());
                parent.getChildren().add(c);
            }
            catch (Exception e) {
                throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
            }
        }
    }

    public String toString() {
        return this.txt.toString();
    }

    public String getText() {
        return this.txt.toString();
    }

    public String getText(FaceletContext ctx) {
        FastWriter writer = new FastWriter(this.length);
        try {
            this.txt.apply(ctx.getExpressionFactory(), ctx).write(writer, ctx);
        }
        catch (IOException e) {
            throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
        }
        return ((Object)writer).toString();
    }
}

