/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.compiler;

import com.sun.facelets.compiler.Instruction;
import com.sun.facelets.el.ELAdaptor;
import com.sun.facelets.el.ELText;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

final class AttributeInstruction
implements Instruction {
    private final String alias;
    private final String attr;
    private final ELText txt;

    public AttributeInstruction(String alias, String attr, ELText txt) {
        this.alias = alias;
        this.attr = attr;
        this.txt = txt;
    }

    public void write(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        try {
            ELContext elContext = ELAdaptor.getELContext(context);
            String val = this.txt.toString(elContext);
            out.writeAttribute(this.attr, (Object)val, null);
        }
        catch (ELException e) {
            throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(this.alias + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        ELText nt = this.txt.apply(factory, ctx);
        if (nt == this.txt) {
            return this;
        }
        return new AttributeInstruction(this.alias, this.attr, nt);
    }

    public boolean isLiteral() {
        return this.txt.isLiteral();
    }
}

