/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.DescriptionBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.PropertyBean;
import com.sun.faces.generate.AbstractGenerator;
import com.sun.faces.generate.GeneratorUtil;
import com.sun.faces.generate.PropertyManager;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HtmlComponentGenerator
extends AbstractGenerator {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webcontainer.jsf.config.generate", "com.sun.faces.ToolsLogStrings");
    private ComponentBean cb;
    private FacesConfigBean configBean;
    private List<PropertyBean> properties;
    private AbstractGenerator.CodeWriter writer;
    private PropertyManager propManager;
    private boolean useBehavior;

    public HtmlComponentGenerator(PropertyManager propManager) {
        this.propManager = propManager;
    }

    @Override
    public void generate(FacesConfigBean configBean) {
        this.configBean = configBean;
        try {
            this.generateClasses();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void generateClasses() throws Exception {
        ComponentBean[] cbs;
        String compPackage = "javax.faces.component.html";
        String packagePath = "javax.faces.component.html".replace('.', File.separatorChar);
        File dir = new File(System.getProperty("user.dir") + File.separatorChar + this.propManager.getProperty("base.output.dir") + File.separatorChar + packagePath);
        for (ComponentBean cb1 : cbs = this.configBean.getComponents()) {
            String componentClass;
            if (cb1.isIgnore() || !(componentClass = cb1.getComponentClass()).startsWith("javax.faces.component.html")) continue;
            this.cb = cb1;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Generating concrete HTML component class " + this.cb.getComponentClass());
            }
            this.properties = new ArrayList<PropertyBean>();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = this.cb.getComponentClass();
            fileName = fileName.substring(fileName.lastIndexOf(46) + 1) + ".java";
            File file = new File(dir, fileName);
            this.writer = new AbstractGenerator.CodeWriter(new FileWriter(file));
            this.useBehavior = false;
            for (PropertyBean property : this.cb.getProperties()) {
                if (null == property.getBehaviors() || property.getBehaviors().isEmpty()) continue;
                this.useBehavior = true;
                break;
            }
            this.prefix();
            this.properties();
            this.suffix();
            this.writer.flush();
            this.writer.close();
        }
    }

    private void prefix() throws Exception {
        PropertyBean[] pbs;
        String[] stringArray;
        ComponentBean base = this.configBean.getComponent(this.cb.getBaseComponentType());
        if (base == null) {
            throw new IllegalArgumentException("No base component type for '" + this.cb.getComponentType() + "'");
        }
        this.writer.writeBlockComment(this.propManager.getProperty("copyright"));
        this.writer.writePackage("javax.faces.component.html");
        this.writer.write(10);
        this.writer.writeImport("java.io.IOException");
        this.writer.writeImport("java.util.ArrayList");
        this.writer.writeImport("java.util.Arrays");
        if (this.useBehavior) {
            this.writer.writeImport("java.util.Collection");
            this.writer.writeImport("java.util.Collections");
        }
        this.writer.writeImport("java.util.List");
        this.writer.write(10);
        this.writer.writeImport("javax.faces.context.FacesContext");
        if (this.useBehavior) {
            this.writer.writeImport("javax.faces.component.behavior.ClientBehaviorHolder");
        }
        this.writer.writeImport("javax.el.MethodExpression");
        this.writer.writeImport("javax.el.ValueExpression");
        this.writer.write("\n\n");
        this.writer.writeBlockComment("******* GENERATED CODE - DO NOT EDIT *******");
        this.writer.write("\n\n");
        DescriptionBean db = this.cb.getDescription("");
        String rendererType = this.cb.getRendererType();
        String description = null;
        if (db != null) {
            description = db.getDescription().trim();
        }
        if (rendererType != null) {
            if (description == null) {
                description = "";
            }
            description = description + "\n<p>By default, the <code>rendererType</code> property must be set to \"<code>" + rendererType + "</code>\".\nThis value can be changed by calling the <code>setRendererType()</code> method.</p>\n";
        }
        if (description != null && description.length() > 0) {
            this.writer.writeJavadocComment(description);
        }
        String string = HtmlComponentGenerator.shortName(this.cb.getComponentClass());
        String string2 = base.getComponentClass();
        if (this.useBehavior) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "ClientBehaviorHolder";
        } else {
            stringArray = null;
        }
        this.writer.writePublicClassDeclaration(string, string2, stringArray, false, false);
        this.writer.write("\n\n");
        this.writer.indent();
        this.writer.fwrite("private static final String OPTIMIZED_PACKAGE = \"javax.faces.component.\";\n\n");
        this.writer.fwrite("public ");
        this.writer.write(HtmlComponentGenerator.shortName(this.cb.getComponentClass()));
        this.writer.write("() {\n");
        this.writer.indent();
        this.writer.fwrite("super();\n");
        if (rendererType != null) {
            this.writer.fwrite("setRendererType(\"");
            this.writer.write(rendererType);
            this.writer.write("\");\n");
        }
        for (PropertyBean pb : pbs = this.cb.getProperties()) {
            if (!pb.isPassThrough() || pb.getDefaultValue() == null) continue;
            this.writer.fwrite("handleAttribute(\"");
            this.writer.write(pb.getPropertyName());
            this.writer.write("\", ");
            this.writer.write(pb.getDefaultValue());
            this.writer.write(");\n");
        }
        this.writer.outdent();
        this.writer.fwrite("}\n\n\n");
        this.writer.writeJavadocComment("<p>The standard component type for this component.</p>\n");
        this.writer.fwrite("public static final String COMPONENT_TYPE = \"");
        this.writer.write(this.cb.getComponentType());
        this.writer.write("\";\n\n\n");
    }

    private void properties() throws Exception {
        ComponentBean base = this.configBean.getComponent(this.cb.getBaseComponentType());
        PropertyBean[] pbs = this.cb.getProperties();
        this.writer.fwrite("protected enum PropertyKeys {\n");
        this.writer.indent();
        for (PropertyBean pb : pbs) {
            if (base.getProperty(pb.getPropertyName()) != null) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Skipping base class property '" + pb.getPropertyName() + "'");
                continue;
            }
            if ("for".equals(pb.getPropertyName())) {
                this.writer.fwrite(pb.getPropertyName());
                this.writer.write("Val(\"for\")");
            } else if ("public".equals(pb.getPropertyName())) {
                this.writer.fwrite(pb.getPropertyName());
                this.writer.write("Val(\"public\")");
            } else {
                this.writer.fwrite(pb.getPropertyName());
            }
            this.writer.write(",\n");
        }
        this.writer.write(";\n");
        this.writer.fwrite("String toString;\n");
        this.writer.fwrite("PropertyKeys(String toString) { this.toString = toString; }\n");
        this.writer.fwrite("PropertyKeys() { }\n");
        this.writer.fwrite("public String toString() {\n");
        this.writer.indent();
        this.writer.fwrite("return ((toString != null) ? toString : super.toString());\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
        this.writer.outdent();
        this.writer.write("}\n\n");
        for (PropertyBean pb : pbs) {
            String temp;
            if (base.getProperty(pb.getPropertyName()) != null) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Skipping base class property '" + pb.getPropertyName() + "'");
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Generating property variable/getter/setter for '" + pb.getPropertyName() + "'");
            }
            this.properties.add(pb);
            String type = pb.getPropertyClass();
            String var = HtmlComponentGenerator.mangle(pb.getPropertyName());
            String description = "<p>Return the value of the <code>" + pb.getPropertyName() + "</code> property.</p>";
            DescriptionBean db = pb.getDescription("");
            if (db != null && (temp = db.getDescription().trim()) != null && temp.length() > 0) {
                description = description + "\n<p>Contents: " + temp;
            }
            this.writer.writeJavadocComment(description.trim());
            this.writer.fwrite("public ");
            this.writer.write(type);
            if ("boolean".equals(type)) {
                this.writer.write(" is");
            } else {
                this.writer.write(" get");
            }
            this.writer.write(HtmlComponentGenerator.capitalize(pb.getPropertyName()));
            this.writer.write("() {\n");
            this.writer.indent();
            this.writer.fwrite("return (");
            this.writer.write(HtmlComponentGenerator.primitive(type) ? GeneratorUtil.convertToObject(type) : type);
            this.writer.write(") getStateHelper().eval(PropertyKeys.");
            this.writer.write(pb.getPropertyName().equals("for") || pb.getPropertyName().equals("public") ? pb.getPropertyName() + "Val" : pb.getPropertyName());
            if (HtmlComponentGenerator.primitive(type) || pb.getDefaultValue() != null) {
                this.writer.write(", ");
                this.writer.write(pb.getDefaultValue() != null ? pb.getDefaultValue() : (String)TYPE_DEFAULTS.get(type));
            }
            this.writer.write(");\n\n");
            this.writer.outdent();
            this.writer.fwrite("}\n\n");
            this.writer.writeJavadocComment("<p>Set the value of the <code>" + pb.getPropertyName() + "</code> property.</p>\n");
            this.writer.fwrite("public void set");
            this.writer.write(HtmlComponentGenerator.capitalize(pb.getPropertyName()));
            this.writer.write("(");
            this.writer.write(type);
            this.writer.write(32);
            this.writer.write(var);
            this.writer.write(") {\n");
            this.writer.indent();
            this.writer.fwrite("getStateHelper().put(PropertyKeys.");
            this.writer.write(pb.getPropertyName().equals("for") || pb.getPropertyName().equals("public") ? pb.getPropertyName() + "Val" : pb.getPropertyName());
            this.writer.write(", ");
            this.writer.write(var);
            this.writer.write(");\n");
            if (pb.isPassThrough() && pb.getDefaultValue() == null || this.cb.getComponentClass().contains("HtmlCommandButton") && "onclick".equals(pb.getPropertyName())) {
                this.writer.fwrite("handleAttribute(\"");
                this.writer.write(pb.getPropertyName());
                this.writer.write("\", ");
                this.writer.write(var);
                this.writer.write(");\n");
            }
            this.writer.outdent();
            this.writer.fwrite("}\n\n");
            this.writer.write("\n");
        }
    }

    private void suffix() throws Exception {
        if (this.useBehavior) {
            this.writer.fwrite("private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(");
            boolean first = true;
            String defaultEventName = null;
            for (PropertyBean property : this.cb.getProperties()) {
                if (null == property.getBehaviors() || property.getBehaviors().isEmpty()) continue;
                String behaviorName = null;
                for (String behavior : property.getBehaviors()) {
                    if (!first) {
                        this.writer.write(",");
                    } else {
                        first = false;
                    }
                    this.writer.write("\"");
                    if (0 == behavior.length()) {
                        behaviorName = property.getPropertyName();
                        if (behaviorName.length() > 2 && behaviorName.startsWith("on")) {
                            StringBuilder buffer = new StringBuilder(behaviorName.substring(2, 3).toLowerCase());
                            buffer.append(behaviorName.substring(3));
                            behaviorName = buffer.toString();
                        }
                    } else {
                        behaviorName = behavior;
                    }
                    this.writer.write(behaviorName);
                    this.writer.write("\"");
                }
                if (!property.isDefaultBehavior()) continue;
                defaultEventName = behaviorName;
            }
            this.writer.write("));\n\n");
            this.writer.fwrite("public Collection<String> getEventNames() {\n");
            this.writer.indent();
            this.writer.fwrite("return EVENT_NAMES;");
            this.writer.outdent();
            this.writer.fwrite("}\n\n\n");
            this.writer.fwrite("public String getDefaultEventName() {\n");
            this.writer.indent();
            if (null == defaultEventName) {
                this.writer.fwrite("return null;");
            } else {
                this.writer.fwrite("return \"" + defaultEventName + "\";");
            }
            this.writer.outdent();
            this.writer.fwrite("}\n\n\n");
        }
        this.writer.fwrite("private void handleAttribute(String name, Object value) {\n");
        this.writer.indent();
        this.writer.fwrite("List<String> setAttributes = (List<String>) this.getAttributes().get(\"javax.faces.component.UIComponentBase.attributesThatAreSet\");\n");
        this.writer.fwrite("if (setAttributes == null) {\n");
        this.writer.indent();
        this.writer.fwrite("String cname = this.getClass().getName();\n");
        this.writer.fwrite("if (cname != null && cname.startsWith(OPTIMIZED_PACKAGE)) {\n");
        this.writer.indent();
        this.writer.fwrite("setAttributes = new ArrayList<String>(6);\n");
        this.writer.fwrite("this.getAttributes().put(\"javax.faces.component.UIComponentBase.attributesThatAreSet\", setAttributes);\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
        this.writer.fwrite("if (setAttributes != null) {\n");
        this.writer.indent();
        this.writer.fwrite("if (value == null) {\n");
        this.writer.indent();
        this.writer.fwrite("ValueExpression ve = getValueExpression(name);\n");
        this.writer.fwrite("if (ve == null) {\n");
        this.writer.indent();
        this.writer.fwrite("setAttributes.remove(name);\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
        this.writer.outdent();
        this.writer.fwrite("} else if (!setAttributes.contains(name)) {\n");
        this.writer.indent();
        this.writer.fwrite("setAttributes.add(name);\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
        this.writer.outdent();
        this.writer.fwrite("}\n");
        this.writer.outdent();
        this.writer.fwrite("}\n\n");
        this.writer.outdent();
        this.writer.write("}\n");
    }

    public static void main(String[] args) throws Exception {
        PropertyManager propManager = PropertyManager.newInstance(args[0]);
        HtmlComponentGenerator generator = new HtmlComponentGenerator(propManager);
        generator.generate(GeneratorUtil.getConfigBean(args[1]));
    }
}

