/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.tools;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

@SupportedOptions(value={"com.sun.tools.javac.sym.Jar", "com.sun.tools.javac.sym.ExtraApiClassPath", "com.sun.tools.javac.sym.Dest"})
@SupportedAnnotationTypes(value={"*"})
public class StripClassesForApiJar
extends AbstractProcessor {
    static Set<String> getLegacyPackages() {
        return Collections.emptySet();
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment renv) {
        if (!renv.processingOver()) {
            return true;
        }
        Set<String> legacy = StripClassesForApiJar.getLegacyPackages();
        Set<String> legacyProprietary = StripClassesForApiJar.getLegacyPackages();
        HashSet<String> documented = new HashSet<String>();
        Set<Symbol.PackageSymbol> packages = ((JavacProcessingEnvironment)this.processingEnv).getSpecifiedPackages();
        String jarName = this.processingEnv.getOptions().get("com.sun.tools.javac.sym.Jar");
        if (jarName == null) {
            throw new RuntimeException("Must use -Acom.sun.tools.javac.sym.Jar=LOCATION_OF_JAR");
        }
        String extraApiClassPath = this.processingEnv.getOptions().get("com.sun.tools.javac.sym.ExtraApiClassPath");
        if (extraApiClassPath == null) {
            throw new RuntimeException("Must use -Acom.sun.tools.javac.sym.ExtraApiClassPath=extra api class path");
        }
        String destName = this.processingEnv.getOptions().get("com.sun.tools.javac.sym.Dest");
        if (destName == null) {
            throw new RuntimeException("Must use -Acom.sun.tools.javac.sym.Dest=LOCATION_OF_JAR");
        }
        for (Symbol.PackageSymbol psym : packages) {
            String name = psym.getQualifiedName().toString();
            legacyProprietary.remove(name);
            documented.add(name);
        }
        JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fm = tool.getStandardFileManager(null, null, null);
        JavaFileManager.Location jarLocation = StandardLocation.locationFor(jarName);
        File jarFile = new File(jarName);
        String[] segments = extraApiClassPath.split(File.pathSeparator);
        ArrayList<File> extraClassPathSegments = new ArrayList<File>(segments.length);
        for (String string : segments) {
            extraClassPathSegments.add(new File(string));
        }
        File ExtraApiClassPathFile = new File(extraApiClassPath);
        try {
            fm.setLocation(jarLocation, List.of(jarFile));
            fm.setLocation(StandardLocation.CLASS_PATH, List.nil());
            fm.setLocation(StandardLocation.SOURCE_PATH, List.nil());
            ArrayList<File> bootClassPath = new ArrayList<File>();
            bootClassPath.add(jarFile);
            for (File file : extraClassPathSegments) {
                bootClassPath.add(file);
            }
            for (File file : fm.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
                bootClassPath.add(file);
            }
            System.err.println("Using boot class path = " + bootClassPath);
            fm.setLocation(StandardLocation.PLATFORM_CLASS_PATH, bootClassPath);
            File destDir = new File(destName);
            if (!destDir.exists() && !destDir.mkdirs()) {
                throw new RuntimeException("Could not create " + destDir);
            }
            fm.setLocation(StandardLocation.CLASS_OUTPUT, List.of(destDir));
        }
        catch (IOException ioe) {
            System.err.println("Unable to set location");
            return false;
        }
        HashSet<String> hiddenPackages = new HashSet<String>();
        HashSet<String> crisp = new HashSet<String>();
        List<String> list = List.of("-XDdev");
        JavacTaskImpl task = (JavacTaskImpl)tool.getTask(null, fm, null, list, null, null);
        com.sun.tools.javac.main.JavaCompiler compiler = com.sun.tools.javac.main.JavaCompiler.instance(task.getContext());
        ClassReader reader = ClassReader.instance(task.getContext());
        ClassWriter writer = ClassWriter.instance(task.getContext());
        Type.moreInfo = true;
        Pool pool = new Pool();
        Symbol.ClassSymbol cs = null;
        try {
            for (JavaFileObject file : fm.list(jarLocation, "", EnumSet.of(JavaFileObject.Kind.CLASS), true)) {
                String pckName;
                String className = fm.inferBinaryName(jarLocation, file);
                int index = className.lastIndexOf(46);
                String string = pckName = index == -1 ? "" : className.substring(0, index);
                if (documented.contains(pckName)) {
                    if (!legacy.contains(pckName)) {
                        crisp.add(pckName);
                    }
                } else if (!legacyProprietary.contains(pckName)) {
                    hiddenPackages.add(pckName);
                    continue;
                }
                Symbol.TypeSymbol sym = (Symbol.TypeSymbol)compiler.resolveIdent(className);
                if (sym.kind != 2) {
                    if (className.indexOf(36) >= 0) continue;
                    System.err.println("Ignoring (other) " + className + " : " + sym);
                    System.err.println("   " + sym.getClass().getSimpleName() + " " + sym.type);
                    continue;
                }
                sym.complete();
                if (((Symbol)sym.getEnclosingElement()).getKind() != ElementKind.PACKAGE) {
                    System.err.println("Ignoring (bad) " + sym.getQualifiedName());
                }
                cs = (Symbol.ClassSymbol)sym;
                this.writeClass(pool, cs, writer);
                cs = null;
            }
        }
        catch (IOException ex) {
            this.reportError(ex, cs);
        }
        catch (Symbol.CompletionFailure ex) {
            this.reportError(ex, cs);
        }
        catch (RuntimeException ex) {
            this.reportError(ex, cs);
        }
        return true;
    }

    void reportError(Throwable ex, Element element) {
        if (element != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getLocalizedMessage(), element);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getLocalizedMessage());
        }
    }

    void writeClass(Pool pool, Symbol.ClassSymbol cs, ClassWriter writer) {
        try {
            pool.reset();
            cs.pool = pool;
            writer.writeClass(cs);
            Scope.Entry e = cs.members().elems;
            while (e != null) {
                if (e.sym.kind == 2) {
                    Symbol.ClassSymbol nestedClass = (Symbol.ClassSymbol)e.sym;
                    nestedClass.complete();
                    this.writeClass(pool, nestedClass, writer);
                }
                e = e.sibling;
            }
        }
        catch (ClassWriter.StringOverflow ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassWriter.PoolOverflow ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

