/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.facelets.util.DevTools;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.SelectItemsIterator;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitUtils {
    private static final String XHTML_ATTR_PREFIX = "xml:";
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"disabled", "ismap", "readonly"};
    private static final String[] XHTML_PREFIX_ATTRIBUTES = new String[]{"lang"};
    private static final int MAX_CONTENT_TYPE_PARTS = 4;
    private static final String CONTENT_TYPE_DELIMITER = ",";
    private static final String CONTENT_TYPE_SUBTYPE_DELIMITER = "/";
    private static final String OPTIMIZED_PACKAGE = "javax.faces.component.";
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
    protected static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();

    private RenderKitUtils() {
    }

    public static RenderKit getCurrentRenderKit(FacesContext context) {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
    }

    public static ResponseStateManager getResponseStateManager(FacesContext context, String renderKitId) throws FacesException {
        assert (null != renderKitId);
        assert (null != context);
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            RenderKitFactory factory = (RenderKitFactory)RequestStateManager.get(context, "com.sun.faces.renderKitImplForRequest");
            if (factory != null) {
                renderKit = factory.getRenderKit(context, renderKitId);
            } else {
                factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                if (factory == null) {
                    throw new IllegalStateException();
                }
                RequestStateManager.set(context, "com.sun.faces.renderKitImplForRequest", factory);
                renderKit = factory.getRenderKit(context, renderKitId);
            }
        }
        return renderKit.getResponseStateManager();
    }

    public static Iterator<SelectItem> getSelectItems(FacesContext context, UIComponent component) {
        Util.notNull("context", context);
        Util.notNull("component", component);
        return new SelectItemsIterator(context, component);
    }

    public static void renderPassThruAttributes(FacesContext context, ResponseWriter writer, UIComponent component, Attribute[] attributes) throws IOException {
        assert (null != context);
        assert (null != writer);
        assert (null != component);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        }
        if (null != behaviors && behaviors.size() > 0 && Util.componentIsDisabled(component)) {
            behaviors = null;
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, attributes, behaviors);
    }

    public static void renderPassThruAttributes(FacesContext context, ResponseWriter writer, UIComponent component, Attribute[] attributes, Map<String, List<ClientBehavior>> behaviors) throws IOException {
        assert (null != writer);
        assert (null != component);
        if (behaviors == null) {
            behaviors = Collections.emptyMap();
        }
        if (RenderKitUtils.canBeOptimized(component, behaviors)) {
            List setAttributes = (List)component.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
            if (setAttributes != null) {
                RenderKitUtils.renderPassThruAttributesOptimized(context, writer, component, attributes, setAttributes, behaviors);
            }
        } else {
            RenderKitUtils.renderPassThruAttributesUnoptimized(context, writer, component, attributes, behaviors);
        }
    }

    public static void renderOnchange(FacesContext context, UIComponent component, boolean incExec) throws IOException {
        List<ClientBehaviorContext.Parameter> params;
        Map behaviors;
        String handlerName = "onchange";
        Object userHandler = component.getAttributes().get("onchange");
        String behaviorEventName = "valueChange";
        if (component instanceof ClientBehaviorHolder && null != (behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()) && behaviors.containsKey("change")) {
            behaviorEventName = "change";
        }
        if (!incExec) {
            params = Collections.emptyList();
        } else {
            params = new LinkedList();
            params.add(new ClientBehaviorContext.Parameter("incExec", (Object)true));
        }
        RenderKitUtils.renderHandler(context, component, params, "onchange", userHandler, behaviorEventName, null, false, incExec);
    }

    public static void renderSelectOnclick(FacesContext context, UIComponent component, boolean incExec) throws IOException {
        List<ClientBehaviorContext.Parameter> params;
        Map behaviors;
        String handlerName = "onclick";
        Object userHandler = component.getAttributes().get("onclick");
        String behaviorEventName = "valueChange";
        if (component instanceof ClientBehaviorHolder && null != (behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()) && behaviors.containsKey("click")) {
            behaviorEventName = "click";
        }
        if (!incExec) {
            params = Collections.emptyList();
        } else {
            params = new LinkedList();
            params.add(new ClientBehaviorContext.Parameter("incExec", (Object)true));
        }
        RenderKitUtils.renderHandler(context, component, params, "onclick", userHandler, behaviorEventName, null, false, incExec);
    }

    public static void renderOnclick(FacesContext context, UIComponent component, Collection<ClientBehaviorContext.Parameter> params, String submitTarget, boolean needsSubmit) throws IOException {
        Map behaviors;
        String handlerName = "onclick";
        Object userHandler = component.getAttributes().get("onclick");
        String behaviorEventName = "action";
        if (component instanceof ClientBehaviorHolder && null != (behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()) && behaviors.containsKey("click")) {
            behaviorEventName = "click";
        }
        RenderKitUtils.renderHandler(context, component, params, "onclick", userHandler, behaviorEventName, submitTarget, needsSubmit, false);
    }

    public static String prefixAttribute(String attrName, ResponseWriter writer) {
        return RenderKitUtils.prefixAttribute(attrName, "application/xhtml+xml".equals(writer.getContentType()));
    }

    public static String prefixAttribute(String attrName, boolean isXhtml) {
        if (isXhtml) {
            if (Arrays.binarySearch(XHTML_PREFIX_ATTRIBUTES, attrName) > -1) {
                return XHTML_ATTR_PREFIX + attrName;
            }
            return attrName;
        }
        return attrName;
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        assert (writer != null);
        assert (component != null);
        Map attrMap = component.getAttributes();
        for (String attrName : BOOLEAN_ATTRIBUTES) {
            Object val = attrMap.get(attrName);
            if (val == null || !Boolean.valueOf(val.toString()).booleanValue()) continue;
            writer.writeAttribute(attrName, (Object)true, attrName);
        }
    }

    public static String determineContentType(String accept, String serverSupportedTypes, String preferredType) {
        String[][] preferredContentType;
        String[][] serverContentTypes;
        String contentType = null;
        if (null == accept || null == serverSupportedTypes) {
            return contentType;
        }
        String[][] clientContentTypes = RenderKitUtils.buildTypeArrayFromString(accept);
        String[][] matchedInfo = RenderKitUtils.findMatch(clientContentTypes, serverContentTypes = RenderKitUtils.buildTypeArrayFromString(serverSupportedTypes), preferredContentType = RenderKitUtils.buildTypeArrayFromString(preferredType));
        if (matchedInfo[0][1] != null && !matchedInfo[0][2].equals("*")) {
            contentType = matchedInfo[0][1] + CONTENT_TYPE_SUBTYPE_DELIMITER + matchedInfo[0][2];
        }
        return contentType;
    }

    public static boolean isXml(String contentType) {
        return "application/xhtml+xml".equals(contentType) || "application/xml".equals(contentType) || "text/xml".equals(contentType);
    }

    private static boolean canBeOptimized(UIComponent component, Map<String, List<ClientBehavior>> behaviors) {
        assert (component != null);
        assert (behaviors != null);
        String name = component.getClass().getName();
        if (name != null && name.startsWith(OPTIMIZED_PACKAGE)) {
            return behaviors.size() < 2;
        }
        return false;
    }

    private static void renderPassThruAttributesOptimized(FacesContext context, ResponseWriter writer, UIComponent component, Attribute[] knownAttributes, List<String> setAttributes, Map<String, List<ClientBehavior>> behaviors) throws IOException {
        assert (behaviors != null && behaviors.size() < 2);
        String behaviorEventName = RenderKitUtils.getSingleBehaviorEventName(behaviors);
        boolean renderedBehavior = false;
        Collections.sort(setAttributes);
        boolean isXhtml = "application/xhtml+xml".equals(writer.getContentType());
        Map attrMap = component.getAttributes();
        for (String name : setAttributes) {
            Object value;
            int index = Arrays.binarySearch(knownAttributes, Attribute.attr(name));
            if (index < 0 || (value = attrMap.get(name)) == null || !RenderKitUtils.shouldRenderAttribute(value)) continue;
            Attribute attr = knownAttributes[index];
            if (RenderKitUtils.isBehaviorEventAttribute(attr, behaviorEventName)) {
                RenderKitUtils.renderHandler(context, component, null, name, value, behaviorEventName, null, false, false);
                renderedBehavior = true;
                continue;
            }
            writer.writeAttribute(RenderKitUtils.prefixAttribute(name, isXhtml), value, name);
        }
        if (behaviorEventName != null && !renderedBehavior) {
            for (int i = 0; i < knownAttributes.length; ++i) {
                Attribute attr = knownAttributes[i];
                String[] events = attr.getEvents();
                if (events == null || events.length <= 0 || !behaviorEventName.equals(events[0])) continue;
                RenderKitUtils.renderHandler(context, component, null, attr.getName(), null, behaviorEventName, null, false, false);
            }
        }
    }

    private static void renderPassThruAttributesUnoptimized(FacesContext context, ResponseWriter writer, UIComponent component, Attribute[] knownAttributes, Map<String, List<ClientBehavior>> behaviors) throws IOException {
        boolean isXhtml = "application/xhtml+xml".equals(writer.getContentType());
        Map attrMap = component.getAttributes();
        for (Attribute attribute : knownAttributes) {
            String attrName = attribute.getName();
            String[] events = attribute.getEvents();
            boolean hasBehavior = events != null && events.length > 0 && behaviors.containsKey(events[0]);
            Object value = attrMap.get(attrName);
            if (value != null && RenderKitUtils.shouldRenderAttribute(value) && !hasBehavior) {
                writer.writeAttribute(RenderKitUtils.prefixAttribute(attrName, isXhtml), value, attrName);
                continue;
            }
            if (!hasBehavior) continue;
            RenderKitUtils.renderHandler(context, component, null, attrName, value, events[0], null, false, false);
        }
    }

    private static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof String) {
            return true;
        }
        if (attributeVal instanceof Boolean && Boolean.FALSE.equals(attributeVal)) {
            return false;
        }
        if (attributeVal instanceof Integer && (Integer)attributeVal == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Double && (Double)attributeVal == Double.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Character && ((Character)attributeVal).charValue() == '\u0000') {
            return false;
        }
        if (attributeVal instanceof Float && ((Float)attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Short && (Short)attributeVal == Short.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Byte && (Byte)attributeVal == -128) {
            return false;
        }
        return !(attributeVal instanceof Long) || (Long)attributeVal != Long.MIN_VALUE;
    }

    private static String[][] buildTypeArrayFromString(String accept) {
        if (accept == null || accept.length() == 0) {
            return new String[0][0];
        }
        String level = null;
        String quality = null;
        Map appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        String[] types = Util.split(appMap, accept, CONTENT_TYPE_DELIMITER);
        String[][] arrayAccept = new String[types.length][4];
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            String subtype;
            String type;
            StringBuilder typeSubType;
            String token = types[i].trim();
            ++index;
            if (token.contains(";")) {
                String[] typeParts = Util.split(appMap, token, ";");
                typeSubType = new StringBuilder(typeParts[0].trim());
                for (int j = 1; j < typeParts.length; ++j) {
                    quality = "not set";
                    token = typeParts[j].trim();
                    if (token.contains("level")) {
                        typeSubType.append(';').append(token);
                        String[] levelParts = Util.split(appMap, token, "=");
                        level = levelParts[0].trim();
                        if (!level.equalsIgnoreCase("level")) continue;
                        level = levelParts[1].trim();
                        continue;
                    }
                    quality = token;
                    String[] qualityParts = Util.split(appMap, quality, "=");
                    if ((quality = qualityParts[0].trim()).equalsIgnoreCase("q")) {
                        quality = qualityParts[1].trim();
                        break;
                    }
                    quality = "not set";
                }
            } else {
                typeSubType = new StringBuilder(token);
                quality = "not set";
            }
            if (typeSubType.indexOf(CONTENT_TYPE_SUBTYPE_DELIMITER) >= 0) {
                String[] typeSubTypeParts = Util.split(appMap, typeSubType.toString(), CONTENT_TYPE_SUBTYPE_DELIMITER);
                if (typeSubTypeParts.length == 1) {
                    type = typeSubTypeParts[0].trim();
                    subtype = "*";
                } else {
                    type = typeSubTypeParts[0].trim();
                    subtype = typeSubTypeParts[1].trim();
                }
            } else {
                type = typeSubType.toString();
                subtype = "";
            }
            if ("not set".equals(quality)) {
                quality = type.equals("*") && subtype.equals("*") ? "0.01" : (!type.equals("*") && subtype.equals("*") ? "0.02" : (type.equals("*") && subtype.length() == 0 ? "0.01" : "1"));
            }
            arrayAccept[index][0] = quality;
            arrayAccept[index][1] = type;
            arrayAccept[index][2] = subtype;
            arrayAccept[index][3] = level;
        }
        return arrayAccept;
    }

    private static String[][] findMatch(String[][] clientContentTypes, String[][] serverSupportedContentTypes, String[][] preferredContentType) {
        ArrayList<String[]> resultList = new ArrayList<String[]>(serverSupportedContentTypes.length);
        double highestQFactor = 0.0;
        int idx = 0;
        int slen = serverSupportedContentTypes.length;
        for (int sidx = 0; sidx < slen; ++sidx) {
            String serverType = serverSupportedContentTypes[sidx][1];
            if (serverType == null) continue;
            int clen = clientContentTypes.length;
            for (int cidx = 0; cidx < clen; ++cidx) {
                String browserType = clientContentTypes[cidx][1];
                if (browserType == null || !browserType.equalsIgnoreCase(serverType) && !browserType.equals("*") || !clientContentTypes[cidx][2].equalsIgnoreCase(serverSupportedContentTypes[sidx][2]) && !clientContentTypes[cidx][2].equals("*")) continue;
                double cLevel = 0.0;
                double sLevel = 0.0;
                if (clientContentTypes[cidx][3] != null) {
                    cLevel = Double.parseDouble(clientContentTypes[cidx][3]) * 0.1;
                }
                if (serverSupportedContentTypes[sidx][3] != null) {
                    sLevel = Double.parseDouble(serverSupportedContentTypes[sidx][3]) * 0.1;
                }
                double cQfactor = Double.parseDouble(clientContentTypes[cidx][0]) + cLevel;
                double sQfactor = Double.parseDouble(serverSupportedContentTypes[sidx][0]) + sLevel;
                double resultQuality = cQfactor * sQfactor;
                String[] curResult = new String[4];
                resultList.add(curResult);
                curResult[0] = String.valueOf(resultQuality);
                if (clientContentTypes[cidx][2].equals("*")) {
                    curResult[1] = clientContentTypes[cidx][1];
                    curResult[2] = clientContentTypes[cidx][2];
                } else {
                    curResult[1] = serverSupportedContentTypes[sidx][1];
                    curResult[2] = serverSupportedContentTypes[sidx][2];
                    curResult[3] = serverSupportedContentTypes[sidx][3];
                }
                if (!(resultQuality > highestQFactor)) continue;
                idx = resultList.size() - 1;
                highestQFactor = resultQuality;
            }
        }
        String[][] match = new String[1][3];
        if (preferredContentType.length != 0 && preferredContentType[0][0] != null) {
            BigDecimal highestQual = BigDecimal.valueOf(highestQFactor);
            int len = resultList.size();
            for (int i = 0; i < len; ++i) {
                String[] result = (String[])resultList.get(i);
                if (BigDecimal.valueOf(Double.parseDouble(result[0])).compareTo(highestQual) != 0 || !result[1].equals(preferredContentType[0][1]) || !result[2].equals(preferredContentType[0][2])) continue;
                match[0][0] = result[0];
                match[0][1] = result[1];
                match[0][2] = result[2];
                return match;
            }
        }
        if (!resultList.isEmpty()) {
            String[] fallBack = (String[])resultList.get(idx);
            match[0][0] = fallBack[0];
            match[0][1] = fallBack[1];
            match[0][2] = fallBack[2];
        }
        return match;
    }

    public static String createValidECMAIdentifier(String origIdentifier) {
        return origIdentifier.replace("-", "$_");
    }

    public static void renderJsfJs(FacesContext context) throws IOException {
        if (RenderKitUtils.hasScriptBeenRendered(context)) {
            return;
        }
        String name = "jsf.js";
        String library = "javax.faces";
        if (RenderKitUtils.hasResourceBeenInstalled(context, "jsf.js", "javax.faces")) {
            RenderKitUtils.setScriptAsRendered(context);
            return;
        }
        ResourceHandler handler = context.getApplication().getResourceHandler();
        Resource resource = handler.createResource("jsf.js", "javax.faces");
        ResponseWriter writer = context.getResponseWriter();
        writer.write(10);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)(resource != null ? resource.getRequestPath() : ""), null);
        writer.endElement("script");
        writer.append('\r');
        writer.append('\n');
        RenderKitUtils.setScriptAsRendered(context);
    }

    public static boolean hasResourceBeenInstalled(FacesContext ctx, String name, String library) {
        String rlibrary;
        String rname;
        UIComponent resource;
        UIViewRoot viewRoot = ctx.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(ctx, "head").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!name.equals(rname) || !library.equals(rlibrary)) continue;
            return true;
        }
        iter = viewRoot.getComponentResources(ctx, "body").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!name.equals(rname) || !library.equals(rlibrary)) continue;
            return true;
        }
        iter = viewRoot.getComponentResources(ctx, "form").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!name.equals(rname) || !library.equals(rlibrary)) continue;
            return true;
        }
        return false;
    }

    public static void renderUnhandledMessages(FacesContext ctx) {
        if (ctx.isProjectStage(ProjectStage.Development)) {
            Application app = ctx.getApplication();
            HtmlMessages messages = (HtmlMessages)app.createComponent("javax.faces.HtmlMessages");
            messages.setId("javax_faces_developmentstage_messages");
            Renderer messagesRenderer = ctx.getRenderKit().getRenderer("javax.faces.Messages", "javax.faces.Messages");
            messages.setErrorStyle("Color: red");
            messages.setWarnStyle("Color: orange");
            messages.setInfoStyle("Color: blue");
            messages.setFatalStyle("Color: red");
            messages.setTooltip(true);
            messages.setTitle("Project Stage[Development]: Unhandled Messages");
            messages.setRedisplay(false);
            try {
                messagesRenderer.encodeBegin(ctx, (UIComponent)messages);
                messagesRenderer.encodeEnd(ctx, (UIComponent)messages);
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        } else {
            Iterator clientIds = ctx.getClientIdsWithMessages();
            int messageCount = 0;
            if (clientIds.hasNext()) {
                StringBuilder builder = new StringBuilder();
                while (clientIds.hasNext()) {
                    String clientId = (String)clientIds.next();
                    Iterator messages = ctx.getMessages(clientId);
                    while (messages.hasNext()) {
                        FacesMessage message = (FacesMessage)messages.next();
                        if (message.isRendered()) continue;
                        ++messageCount;
                        builder.append("\n");
                        builder.append("sourceId=").append(clientId);
                        builder.append("[severity=(").append(message.getSeverity());
                        builder.append("), summary=(").append(message.getSummary());
                        builder.append("), detail=(").append(message.getDetail()).append(")]");
                    }
                }
                if (messageCount > 0 && LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.non_displayed_message", builder.toString());
                }
            }
        }
    }

    public static void renderHtmlErrorPage(FacesContext ctx, FacesException fe) {
        ExternalContext extContext = ctx.getExternalContext();
        if (!extContext.isResponseCommitted()) {
            block6: {
                extContext.responseReset();
                extContext.setResponseContentType("text/html; charset=UTF-8");
                extContext.setResponseStatus(500);
                try {
                    Writer w = extContext.getResponseOutputWriter();
                    DevTools.debugHtml(w, ctx, fe.getCause());
                    w.flush();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                    LOGGER.log(Level.SEVERE, "Unable to generate Facelets error page.", ioe);
                }
            }
            ctx.responseComplete();
        } else {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.facelets.error.page.response.committed");
            }
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, fe.toString(), fe);
            }
        }
    }

    public static boolean isPartialOrBehaviorAction(FacesContext context, String clientId) {
        if (clientId == null || clientId.length() == 0) {
            return false;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String source = (String)params.get("javax.faces.source");
        if (!clientId.equals(source)) {
            return false;
        }
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (null != behaviorEvent) {
            return "action".equals(behaviorEvent);
        }
        String partialEvent = (String)params.get("javax.faces.partial.event");
        return "click".equals(partialEvent);
    }

    public static String getFormClientId(UIComponent component, FacesContext context) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm form = (UIForm)parent;
        if (form != null) {
            return form.getClientId(context);
        }
        return null;
    }

    public static boolean hasScriptBeenRendered(FacesContext context) {
        return RequestStateManager.containsKey(context, "com.sun.faces.SCRIPT_STATE");
    }

    public static void setScriptAsRendered(FacesContext context) {
        RequestStateManager.set(context, "com.sun.faces.SCRIPT_STATE", Boolean.TRUE);
    }

    public static String getImageSource(FacesContext context, UIComponent component, String attrName) {
        String resName = (String)component.getAttributes().get("name");
        if (resName != null) {
            String libName = (String)component.getAttributes().get("library");
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(resName, libName);
            if (res == null) {
                if (context.isProjectStage(ProjectStage.Development)) {
                    String msg = "Unable to find resource " + resName;
                    context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
                }
                return "RES_NOT_FOUND";
            }
            return res.getRequestPath();
        }
        String value = (String)component.getAttributes().get(attrName);
        if (value == null || value.length() == 0) {
            return "";
        }
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }

    private static void appendScriptToChain(StringBuilder builder, String script) {
        if (script == null || script.length() == 0) {
            return;
        }
        if (builder.charAt(builder.length() - 1) != ',') {
            builder.append(',');
        }
        RenderKitUtils.appendQuotedValue(builder, script);
    }

    public static void appendProperty(StringBuilder builder, String name, Object value) {
        RenderKitUtils.appendProperty(builder, name, value, true);
    }

    public static void appendProperty(StringBuilder builder, String name, Object value, boolean quoteValue) {
        if (null == name || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        char lastChar = builder.charAt(builder.length() - 1);
        if (lastChar != ',' && lastChar != '{') {
            builder.append(',');
        }
        RenderKitUtils.appendQuotedValue(builder, name);
        builder.append(":");
        if (value == null) {
            builder.append("''");
        } else if (quoteValue) {
            RenderKitUtils.appendQuotedValue(builder, value.toString());
        } else {
            builder.append(value.toString());
        }
    }

    private static void appendQuotedValue(StringBuilder builder, String script) {
        builder.append("'");
        int length = script.length();
        for (int i = 0; i < length; ++i) {
            char c = script.charAt(i);
            if (c == '\'' || c == '\\') {
                builder.append('\\');
            }
            builder.append(c);
        }
        builder.append("'");
    }

    private static boolean appendBehaviorsToChain(StringBuilder builder, FacesContext context, UIComponent component, List<ClientBehavior> behaviors, String behaviorEventName, Collection<ClientBehaviorContext.Parameter> params) {
        if (behaviors == null || behaviors.isEmpty()) {
            return false;
        }
        ClientBehaviorContext bContext = RenderKitUtils.createClientBehaviorContext(context, component, behaviorEventName, params);
        boolean submitting = false;
        for (ClientBehavior behavior : behaviors) {
            String script = behavior.getScript(bContext);
            if (script == null || script.length() <= 0) continue;
            RenderKitUtils.appendScriptToChain(builder, script);
            if (!RenderKitUtils.isSubmitting(behavior)) continue;
            submitting = true;
        }
        return submitting;
    }

    private static String getSingleBehaviorEventName(Map<String, List<ClientBehavior>> behaviors) {
        assert (behaviors != null);
        int size = behaviors.size();
        if (size == 0) {
            return null;
        }
        assert (size == 1);
        Iterator<String> keys = behaviors.keySet().iterator();
        assert (keys.hasNext());
        return keys.next();
    }

    private static boolean isBehaviorEventAttribute(Attribute attr, String behaviorEventName) {
        String[] events = attr.getEvents();
        return behaviorEventName != null && events != null && events.length > 0 && behaviorEventName.equals(events[0]);
    }

    private static String getNonEmptyUserHandler(Object handlerObject) {
        String handler = null;
        if (null != handlerObject) {
            handler = handlerObject.toString();
            if ((handler = handler.trim()).length() == 0) {
                handler = null;
            }
        }
        return handler;
    }

    private static List<ClientBehavior> getClientBehaviors(UIComponent component, String behaviorEventName) {
        ClientBehaviorHolder bHolder;
        Map behaviors;
        if (component instanceof ClientBehaviorHolder && null != (behaviors = (bHolder = (ClientBehaviorHolder)component).getClientBehaviors())) {
            return (List)behaviors.get(behaviorEventName);
        }
        return null;
    }

    private static String getSubmitHandler(FacesContext context, UIComponent component, Collection<ClientBehaviorContext.Parameter> params, String submitTarget, boolean preventDefault) {
        StringBuilder builder = new StringBuilder(256);
        String formClientId = RenderKitUtils.getFormClientId(component, context);
        String componentClientId = component.getClientId(context);
        builder.append("mojarra.jsfcljs(document.getElementById('");
        builder.append(formClientId);
        builder.append("'),{");
        RenderKitUtils.appendProperty(builder, componentClientId, componentClientId);
        if (null != params && !params.isEmpty()) {
            for (ClientBehaviorContext.Parameter param : params) {
                RenderKitUtils.appendProperty(builder, param.getName(), param.getValue());
            }
        }
        builder.append("},'");
        if (submitTarget != null) {
            builder.append(submitTarget);
        }
        builder.append("')");
        if (preventDefault) {
            builder.append(";return false");
        }
        return builder.toString();
    }

    private static String getChainedHandler(FacesContext context, UIComponent component, List<ClientBehavior> behaviors, Collection<ClientBehaviorContext.Parameter> params, String behaviorEventName, String userHandler, String submitTarget, boolean needsSubmit) {
        boolean hasParams;
        StringBuilder builder = new StringBuilder(100);
        builder.append("jsf.util.chain(this,event,");
        RenderKitUtils.appendScriptToChain(builder, userHandler);
        boolean submitting = RenderKitUtils.appendBehaviorsToChain(builder, context, component, behaviors, behaviorEventName, params);
        boolean bl = hasParams = null != params && !params.isEmpty();
        if (!submitting && (hasParams || needsSubmit)) {
            String submitHandler = RenderKitUtils.getSubmitHandler(context, component, params, submitTarget, false);
            RenderKitUtils.appendScriptToChain(builder, submitHandler);
            submitting = true;
        }
        builder.append(")");
        if (submitting && ("action".equals(behaviorEventName) || "click".equals(behaviorEventName))) {
            builder.append(";return false");
        }
        return builder.toString();
    }

    private static String getSingleBehaviorHandler(FacesContext context, UIComponent component, ClientBehavior behavior, Collection<ClientBehaviorContext.Parameter> params, String behaviorEventName, String submitTarget, boolean needsSubmit) {
        boolean preventDefault;
        ClientBehaviorContext bContext = RenderKitUtils.createClientBehaviorContext(context, component, behaviorEventName, params);
        String script = behavior.getScript(bContext);
        boolean bl = preventDefault = !(!needsSubmit && !RenderKitUtils.isSubmitting(behavior) || !"action".equals(behaviorEventName) && !"click".equals(behaviorEventName));
        if (script == null) {
            if (needsSubmit) {
                script = RenderKitUtils.getSubmitHandler(context, component, params, submitTarget, preventDefault);
            }
        } else if (preventDefault) {
            script = script + ";return false";
        }
        return script;
    }

    private static ClientBehaviorContext createClientBehaviorContext(FacesContext context, UIComponent component, String behaviorEventName, Collection<ClientBehaviorContext.Parameter> params) {
        return ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)behaviorEventName, null, params);
    }

    private static boolean isSubmitting(ClientBehavior behavior) {
        return behavior.getHints().contains(ClientBehaviorHint.SUBMITTING);
    }

    private static void renderHandler(FacesContext context, UIComponent component, Collection<ClientBehaviorContext.Parameter> params, String handlerName, Object handlerValue, String behaviorEventName, String submitTarget, boolean needsSubmit, boolean includeExec) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String userHandler = RenderKitUtils.getNonEmptyUserHandler(handlerValue);
        List<ClientBehavior> behaviors = RenderKitUtils.getClientBehaviors(component, behaviorEventName);
        if (null != behaviors && behaviors.size() > 0 && Util.componentIsDisabled(component)) {
            behaviors = null;
        }
        if (params == null) {
            params = Collections.emptyList();
        }
        String handler = null;
        switch (RenderKitUtils.getHandlerType(behaviors, params, userHandler, needsSubmit, includeExec)) {
            case USER_HANDLER_ONLY: {
                handler = userHandler;
                break;
            }
            case SINGLE_BEHAVIOR_ONLY: {
                handler = RenderKitUtils.getSingleBehaviorHandler(context, component, behaviors.get(0), params, behaviorEventName, submitTarget, needsSubmit);
                break;
            }
            case SUBMIT_ONLY: {
                handler = RenderKitUtils.getSubmitHandler(context, component, params, submitTarget, true);
                break;
            }
            case CHAIN: {
                handler = RenderKitUtils.getChainedHandler(context, component, behaviors, params, behaviorEventName, userHandler, submitTarget, needsSubmit);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        writer.writeAttribute(handlerName, (Object)handler, null);
    }

    private static HandlerType getHandlerType(List<ClientBehavior> behaviors, Collection<ClientBehaviorContext.Parameter> params, String userHandler, boolean needsSubmit, boolean includeExec) {
        ClientBehavior behavior;
        if (behaviors == null || behaviors.isEmpty()) {
            if (params.isEmpty() && !needsSubmit || includeExec) {
                return HandlerType.USER_HANDLER_ONLY;
            }
            return userHandler == null ? HandlerType.SUBMIT_ONLY : HandlerType.CHAIN;
        }
        if (behaviors.size() == 1 && userHandler == null && (RenderKitUtils.isSubmitting(behavior = behaviors.get(0)) || params.isEmpty() && !needsSubmit)) {
            return HandlerType.SINGLE_BEHAVIOR_ONLY;
        }
        return HandlerType.CHAIN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HandlerType {
        USER_HANDLER_ONLY,
        SINGLE_BEHAVIOR_ONLY,
        SUBMIT_ONLY,
        CHAIN;

    }
}

