/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiViewHandler
extends ViewHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private String[] configuredExtensions;
    private boolean extensionsSet;
    private ViewDeclarationLanguageFactory vdlFactory;

    public MultiViewHandler() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.configuredExtensions = config.getOptionValue(WebConfiguration.WebContextInitParameter.DefaultSuffix, " ");
        this.extensionsSet = config.isSet(WebConfiguration.WebContextInitParameter.DefaultSuffix);
        this.vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
    }

    public void initView(FacesContext context) throws FacesException {
        if (context.getExternalContext().getRequestCharacterEncoding() == null) {
            super.initView(context);
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        Util.notNull("context", context);
        Util.notNull("viewToRender", viewToRender);
        this.vdlFactory.getViewDeclarationLanguage(viewToRender.getViewId()).renderView(context, viewToRender);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String actualViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(actualViewId).restoreView(context, actualViewId);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String actualViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(actualViewId).createView(context, actualViewId);
    }

    public Locale calculateLocale(FacesContext context) {
        Locale perf;
        Util.notNull("context", context);
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = (Locale)locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        Util.notNull("context", context);
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String result = (String)requestParamMap.get("javax.faces.RenderKitId");
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        Util.notNull("context", context);
        if (!context.getPartialViewContext().isPartialRequest() && !context.getViewRoot().isTransient()) {
            WriteBehindStateWriter writer;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Begin writing marker for viewId " + context.getViewRoot().getViewId());
            }
            if ((writer = WriteBehindStateWriter.getCurrentInstance()) != null) {
                writer.writingState();
            }
            context.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End writing marker for viewId " + context.getViewRoot().getViewId());
            }
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        if (viewId.charAt(0) != '/') {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", viewId);
            }
            throw new IllegalArgumentException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String contextPath = extContext.getRequestContextPath();
        String mapping = Util.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (Util.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(46);
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        ExternalContext extContext = context.getExternalContext();
        if (path.charAt(0) == '/') {
            return extContext.getRequestContextPath() + path;
        }
        return path;
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeBookmarkableURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeRedirectURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        String actualViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(actualViewId);
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        return this.derivePhysicalViewId(context, rawViewId, true);
    }

    protected String normalizeRequestURI(String uri, String mapping) {
        if (mapping == null || !Util.isPrefixMapped(mapping)) {
            return uri;
        }
        int length = mapping.length() + 1;
        StringBuilder builder = new StringBuilder(length);
        builder.append(mapping).append('/');
        String mappingMod = builder.toString();
        boolean logged = false;
        while (uri.startsWith(mappingMod)) {
            if (!logged && logger.isLoggable(Level.WARNING)) {
                logged = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{uri, mapping});
            }
            uri = uri.substring(length - 1);
        }
        return uri;
    }

    protected String convertViewId(FacesContext context, String viewId) {
        int extIdx = viewId.lastIndexOf(46);
        int length = viewId.length();
        StringBuilder buffer = new StringBuilder(length);
        for (String ext : this.configuredExtensions) {
            if (viewId.endsWith(ext)) {
                return viewId;
            }
            this.appendOrReplaceExtension(viewId, ext, length, extIdx, buffer);
            String convertedViewId = buffer.toString();
            try {
                if (context.getExternalContext().getResource(convertedViewId) == null) continue;
                return convertedViewId;
            }
            catch (MalformedURLException e) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return this.legacyConvertViewId(viewId, length, extIdx, buffer);
    }

    protected String derivePhysicalViewId(FacesContext ctx, String rawViewId, boolean checkPhysical) {
        String mapping;
        if (rawViewId != null && (mapping = Util.getFacesMapping(ctx)) != null) {
            String viewId;
            if (!Util.isPrefixMapped(mapping)) {
                viewId = this.convertViewId(ctx, rawViewId);
            } else {
                viewId = this.normalizeRequestURI(rawViewId, mapping);
                if (viewId.equals(mapping)) {
                    this.send404Error(ctx);
                }
            }
            try {
                if (checkPhysical) {
                    return ctx.getExternalContext().getResource(viewId) != null ? viewId : null;
                }
                return viewId;
            }
            catch (MalformedURLException mue) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, mue.toString(), mue);
                }
                return null;
            }
        }
        return rawViewId;
    }

    protected Map<String, List<String>> getFullParameterList(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        LinkedHashMap<Object, Object> copy = existingParameters == null || existingParameters.isEmpty() ? new LinkedHashMap(4) : new LinkedHashMap<String, List<String>>(existingParameters);
        this.addViewParameters(ctx, viewId, copy);
        return copy;
    }

    protected void addViewParameters(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        Collection toViewParams;
        UIViewRoot currentRoot = ctx.getViewRoot();
        String currentViewId = currentRoot.getViewId();
        boolean currentIsSameAsNew = false;
        Collection currentViewParams = ViewMetadata.getViewParameters((UIViewRoot)currentRoot);
        if (currentViewId.equals(viewId)) {
            currentIsSameAsNew = true;
            toViewParams = currentViewParams;
        } else {
            ViewDeclarationLanguage pdl = this.getViewDeclarationLanguage(ctx, viewId);
            ViewMetadata viewMetadata = pdl.getViewMetadata(ctx, viewId);
            UIViewRoot root = viewMetadata.createMetadataView(ctx);
            toViewParams = ViewMetadata.getViewParameters((UIViewRoot)root);
        }
        if (toViewParams.isEmpty()) {
            return;
        }
        for (UIViewParameter viewParam : toViewParams) {
            String value;
            if (existingParameters.containsKey(viewParam.getName()) || (value = MultiViewHandler.paramHasValueExpression(viewParam) ? viewParam.getStringValueFromModel(ctx) : (currentIsSameAsNew ? viewParam.getStringValue(ctx) : MultiViewHandler.getStringValueToTransfer(ctx, viewParam, currentViewParams))) == null) continue;
            List<String> existing = existingParameters.get(viewParam.getName());
            if (existing == null) {
                existing = new ArrayList<String>(4);
                existingParameters.put(viewParam.getName(), existing);
            }
            existing.add(value);
        }
    }

    protected Locale findMatch(FacesContext context, Locale pref) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (pref.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!pref.getLanguage().equals(supportedLocale.getLanguage()) || supportedLocale.getCountry().length() != 0) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (pref.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (pref.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().length() == 0) {
                result = defaultLocale;
            }
        }
        return result;
    }

    protected void send404Error(FacesContext context) {
        try {
            context.responseComplete();
            context.getExternalContext().responseSendError(404, "");
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    private static boolean paramHasValueExpression(UIViewParameter param) {
        return param.getValueExpression("value") != null;
    }

    private static String getStringValueToTransfer(FacesContext context, UIViewParameter param, Collection<UIViewParameter> viewParams) {
        Iterator<UIViewParameter> iterator;
        if (viewParams != null && !viewParams.isEmpty() && (iterator = viewParams.iterator()).hasNext()) {
            UIViewParameter candidate = iterator.next();
            if (null != candidate.getName() && null != param.getName() && candidate.getName().equals(param.getName())) {
                return candidate.getStringValue(context);
            }
            return param.getStringValue(context);
        }
        return null;
    }

    private void appendOrReplaceExtension(String viewId, String ext, int length, int extIdx, StringBuilder buffer) {
        buffer.setLength(0);
        buffer.append(viewId);
        if (extIdx != -1) {
            buffer.replace(extIdx, length, ext);
        } else {
            buffer.append(ext);
        }
    }

    private String legacyConvertViewId(String viewId, int length, int extIdx, StringBuilder buffer) {
        String ext;
        String string = ext = this.extensionsSet && this.configuredExtensions.length != 0 ? this.configuredExtensions[0] : ".jsp";
        if (viewId.endsWith(ext)) {
            return viewId;
        }
        this.appendOrReplaceExtension(viewId, ext, length, extIdx, buffer);
        return buffer.toString();
    }
}

