/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiKeyConcurrentHashMap<K, V> {
    static int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_SEGMENTS = 16;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;

    static int hash(Object x1, Object x2, Object x3, Object x4) {
        int h = 0;
        h ^= x1.hashCode();
        if (x2 != null) {
            h ^= x2.hashCode();
        }
        if (x3 != null) {
            h ^= x3.hashCode();
        }
        if (x4 != null) {
            h ^= x4.hashCode();
        }
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    final Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public MultiKeyConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    public MultiKeyConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public MultiKeyConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f, 16);
    }

    public boolean isEmpty() {
        int i;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments.length; ++i) {
                segments[i].lock();
            }
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public V get(Object key) {
        int hash = MultiKeyConcurrentHashMap.hash(key, null, null, null);
        return this.segmentFor(hash).get(key, null, null, null, hash);
    }

    public V get(Object key1, Object key2) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, null, null);
        return this.segmentFor(hash).get(key1, key2, null, null, hash);
    }

    public V get(Object key1, Object key2, Object key3) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, null);
        return this.segmentFor(hash).get(key1, key2, key3, null, hash);
    }

    public V get(Object key1, Object key2, Object key3, Object key4) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, key4);
        return this.segmentFor(hash).get(key1, key2, key3, key4, hash);
    }

    public boolean containsKey(Object key) {
        int hash = MultiKeyConcurrentHashMap.hash(key, null, null, null);
        return this.segmentFor(hash).containsKey(key, null, null, null, hash);
    }

    public boolean containsKey(Object key1, Object key2) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, null, null);
        return this.segmentFor(hash).containsKey(key1, key2, null, null, hash);
    }

    public boolean containsKey(Object key1, Object key2, Object key3) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, null);
        return this.segmentFor(hash).containsKey(key1, key2, key3, null, hash);
    }

    public boolean containsKey(Object key1, Object key2, Object key3, Object key4) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, key4);
        return this.segmentFor(hash).containsKey(key1, key2, key3, key4, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        int i;
        if (value == null) {
            throw new NullPointerException();
        }
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
                if (!segments[i2].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i3 = 0; i3 < segments.length; ++i3) {
                    if (mc[i3] == segments[i3].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (int i4 = 0; i4 < segments.length; ++i4) {
            segments[i4].lock();
        }
        boolean found = false;
        try {
            for (i = 0; i < segments.length; ++i) {
                if (!segments[i].containsValue(value)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        return found;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key, null, null, null);
        return this.segmentFor(hash).put(key, null, null, null, hash, value, false);
    }

    public V put(K key1, K key2, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, null, null);
        return this.segmentFor(hash).put(key1, key2, null, null, hash, value, false);
    }

    public V put(K key1, K key2, K key3, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, null);
        return this.segmentFor(hash).put(key1, key2, key3, null, hash, value, false);
    }

    public V put(K key1, K key2, K key3, K key4, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, key4);
        return this.segmentFor(hash).put(key1, key2, key3, key4, hash, value, false);
    }

    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key, null, null, null);
        return this.segmentFor(hash).put(key, null, null, null, hash, value, true);
    }

    public V putIfAbsent(K key1, K key2, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, null, null);
        return this.segmentFor(hash).put(key1, key2, null, null, hash, value, true);
    }

    public V putIfAbsent(K key1, K key2, K key3, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, null);
        return this.segmentFor(hash).put(key1, key2, key3, null, hash, value, true);
    }

    public V putIfAbsent(K key1, K key2, K key3, K key4, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, key4);
        return this.segmentFor(hash).put(key1, key2, key3, key4, hash, value, true);
    }

    public V remove(K key) {
        int hash = MultiKeyConcurrentHashMap.hash(key, null, null, null);
        return this.segmentFor(hash).remove(key, null, null, null, hash, null);
    }

    public V remove(K key1, K key2) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, null, null);
        return this.segmentFor(hash).remove(key1, key2, null, null, hash, null);
    }

    public V remove(K key1, K key2, K key3) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, null);
        return this.segmentFor(hash).remove(key1, key2, null, null, hash, null);
    }

    public V remove(K key1, K key2, K key3, K key4) {
        int hash = MultiKeyConcurrentHashMap.hash(key1, key2, key3, key4);
        return this.segmentFor(hash).remove(key1, key2, key3, key4, hash, null);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key, null, null, null);
        return this.segmentFor(hash).replace(key, null, null, null, hash, oldValue, newValue);
    }

    public V replace(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MultiKeyConcurrentHashMap.hash(key, null, null, null);
        return this.segmentFor(hash).replace(key, null, null, null, hash, value);
    }

    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Segment<K, V>
    extends ReentrantLock {
        volatile int count;
        int modCount;
        int threshold;
        volatile HashEntry[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new HashEntry[initialCapacity]);
        }

        void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry<K, V> getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        V readValueUnderLock(HashEntry<K, V> e) {
            this.lock();
            try {
                Object v = e.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object key1, Object key2, Object key3, Object key4, int hash) {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key1.equals(e.key1) && (key2 == null && e.key2 == null || key2 != null && key2.equals(e.key2)) && (key3 == null && e.key3 == null || key3 != null && key3.equals(e.key3)) && (key4 == null && e.key4 == null || key4 != null && key4.equals(e.key2))) {
                        Object v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        boolean containsKey(Object key1, Object key2, Object key3, Object key4, int hash) {
            if (this.count != 0) {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key1.equals(e.key1) && (key2 == null && e.key2 == null || key2 != null && key2.equals(e.key2)) && (key3 == null && e.key3 == null || key3 != null && key3.equals(e.key3)) && (key4 == null && e.key4 == null || key4 != null && key4.equals(e.key2))) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean containsValue(Object value) {
            if (this.count != 0) {
                for (HashEntry hashEntry : this.table) {
                    void var5_5;
                    while (var5_5 != null) {
                        Object v = var5_5.value;
                        if (v == null) {
                            v = this.readValueUnderLock((HashEntry<K, V>)var5_5);
                        }
                        if (value.equals(v)) {
                            return true;
                        }
                        HashEntry hashEntry2 = var5_5.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key1, K key2, K key3, K key4, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null && (e.hash != hash || key1 != null && !key1.equals(e.key1) || key2 != null && !key2.equals(e.key2) || key3 != null && !key3.equals(e.key3) || key4 != null && !key4.equals(e.key4))) {
                    e = e.next;
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(e.value)) {
                    replaced = true;
                    e.value = newValue;
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key1, K key2, K key3, K key4, int hash, V newValue) {
            this.lock();
            try {
                HashEntry<K, V> e = this.getFirst(hash);
                while (e != null && (e.hash != hash || key1 != null && !key1.equals(e.key1) || key2 != null && !key2.equals(e.key2) || key3 != null && !key3.equals(e.key3) || key4 != null && !key4.equals(e.key4))) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    e.value = newValue;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key1, K key2, K key3, K key4, int hash, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                V oldValue;
                HashEntry first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (e != null && (e.hash != hash || key1 != null && !key1.equals(e.key1) || key2 != null && !key2.equals(e.key2) || key3 != null && !key3.equals(e.key3) || key4 != null && !key4.equals(e.key4))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = new HashEntry(key1, key2, key3, key4, hash, first, value);
                    this.count = c;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.key1, p.key2, p.key3, p.key4, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key1, Object key2, Object key3, Object key4, int hash, Object value) {
            this.lock();
            try {
                HashEntry first;
                int c = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (e != null && (e.hash != hash || key1 != null && !key1.equals(e.key1) || key2 != null && !key2.equals(e.key2) || key3 != null && !key3.equals(e.key3) || key4 != null && !key4.equals(e.key4))) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    Object v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry p = first;
                        while (p != e) {
                            newFirst = new HashEntry(p.key1, p.key2, p.key3, p.key4, p.hash, newFirst, p.value);
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HashEntry<K, V> {
        final K key1;
        final K key2;
        final K key3;
        final K key4;
        final int hash;
        volatile V value;
        final HashEntry<K, V> next;

        HashEntry(K key1, K key2, K key3, K key4, int hash, HashEntry<K, V> next, V value) {
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
            this.key4 = key4;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }
}

