/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of javax.faces.component.behavior.AjaxBehavior required: " + behavior);
        }
        return AjaxBehaviorRenderer.buildAjaxCommand(behaviorContext, (AjaxBehavior)behavior);
    }

    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        if (null == context || null == component || null == behavior) {
            throw new NullPointerException();
        }
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of javax.faces.component.behavior.AjaxBehavior required: " + behavior);
        }
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return;
        }
        component.queueEvent((FacesEvent)AjaxBehaviorRenderer.createEvent(component, ajaxBehavior));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  AjaxBehaviorEvent queued.");
            logger.log(Level.FINE, "End decoding component {0}", component.getId());
        }
    }

    private static AjaxBehaviorEvent createEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)ajaxBehavior);
        PhaseId phaseId = AjaxBehaviorRenderer.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        event.setPhaseId(phaseId);
        return event;
    }

    private static boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = false;
        if (ajaxBehavior.isImmediateSet()) {
            immediate = ajaxBehavior.isImmediate();
        } else if (component instanceof EditableValueHolder) {
            immediate = ((EditableValueHolder)component).isImmediate();
        } else if (component instanceof ActionSource) {
            immediate = ((ActionSource)component).isImmediate();
        }
        return immediate;
    }

    private static String buildAjaxCommand(ClientBehaviorContext behaviorContext, AjaxBehavior ajaxBehavior) {
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        UIComponent component = behaviorContext.getComponent();
        String eventName = behaviorContext.getEventName();
        StringBuilder ajaxCommand = new StringBuilder(256);
        LinkedList<String> execute = ajaxBehavior.getExecute();
        Collection render = ajaxBehavior.getRender();
        String onevent = ajaxBehavior.getOnevent();
        String onerror = ajaxBehavior.getOnerror();
        String sourceId = behaviorContext.getSourceId();
        Collection params = behaviorContext.getParameters();
        ClientBehaviorContext.Parameter foundparam = null;
        for (ClientBehaviorContext.Parameter param : params) {
            if (!param.getName().equals("incExec") || !((Boolean)param.getValue()).booleanValue()) continue;
            foundparam = param;
        }
        if (foundparam != null && !execute.contains(sourceId)) {
            execute = new LinkedList<String>(execute);
            execute.add(component.getClientId());
        }
        if (foundparam != null) {
            try {
                params.remove(foundparam);
            }
            catch (UnsupportedOperationException i$) {
                // empty catch block
            }
        }
        ajaxCommand.append("mojarra.ab(");
        if (sourceId == null) {
            ajaxCommand.append("this");
        } else {
            ajaxCommand.append("'");
            ajaxCommand.append(sourceId);
            ajaxCommand.append("'");
        }
        ajaxCommand.append(",event,'");
        ajaxCommand.append(eventName);
        ajaxCommand.append("',");
        AjaxBehaviorRenderer.appendIds(component, ajaxCommand, execute);
        ajaxCommand.append(",");
        AjaxBehaviorRenderer.appendIds(component, ajaxCommand, render);
        if (onevent != null || onerror != null || !params.isEmpty()) {
            ajaxCommand.append(",{");
            if (onevent != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "onevent", onevent, false);
            }
            if (onerror != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "onerror", onerror, false);
            }
            if (!params.isEmpty()) {
                for (ClientBehaviorContext.Parameter param : params) {
                    RenderKitUtils.appendProperty(ajaxCommand, param.getName(), param.getValue());
                }
            }
            ajaxCommand.append("}");
        }
        ajaxCommand.append(")");
        return ajaxCommand.toString();
    }

    private static void appendIds(UIComponent component, StringBuilder builder, Collection<String> ids) {
        if (null == ids || ids.isEmpty()) {
            builder.append('0');
            return;
        }
        builder.append("'");
        boolean first = true;
        for (String id : ids) {
            if (!first) {
                builder.append(' ');
            } else {
                first = false;
            }
            if (id.equals("@all") || id.equals("@none") || id.equals("@form") || id.equals("@this")) {
                builder.append(id);
                continue;
            }
            builder.append(AjaxBehaviorRenderer.getResolvedId(component, id));
        }
        builder.append("'");
    }

    private static String getResolvedId(UIComponent component, String id) {
        UIComponent resolvedComponent = component.findComponent(id);
        if (resolvedComponent == null) {
            throw new FacesException("<f:ajax> contains an unknown id '" + id + "' - cannot locate it in the context of the component " + component.getId());
        }
        return resolvedComponent.getClientId();
    }
}

