/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedCollections {
    private static boolean checkCollectionMembers(Collection<?> collection, Class<?> clazz) {
        for (Object obj : collection) {
            if (obj == null || clazz.isInstance(obj)) continue;
            return false;
        }
        return true;
    }

    public static <E, TypedC extends Collection<E>> TypedC dynamicallyCastCollection(Collection<?> collection, Class<E> clazz, Class<TypedC> clazz2) {
        if (collection == null) {
            return null;
        }
        if (!clazz2.isInstance(collection)) {
            throw new ClassCastException(collection.getClass().getName());
        }
        assert (TypedCollections.checkCollectionMembers(collection, clazz)) : "The collection contains members with a type other than " + clazz.getName();
        return (TypedC)((Collection)clazz2.cast(collection));
    }

    public static <E> List<E> dynamicallyCastList(List<?> list, Class<E> clazz) {
        return TypedCollections.dynamicallyCastCollection(list, clazz, List.class);
    }

    public static <E> Set<E> dynamicallyCastSet(Set<?> set, Class<E> clazz) {
        return TypedCollections.dynamicallyCastCollection(set, clazz, Set.class);
    }

    public static <K, V> Map<K, V> dynamicallyCastMap(Map<?, ?> map, Class<K> clazz, Class<V> clazz2) {
        if (map == null) {
            return null;
        }
        assert (TypedCollections.checkCollectionMembers(map.keySet(), clazz)) : "The map contains keys with a type other than " + clazz.getName();
        assert (TypedCollections.checkCollectionMembers(map.values(), clazz2)) : "The map contains values with a type other than " + clazz2.getName();
        return map;
    }
}

