/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.context.StateContext;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentSupport {
    private static final String MARK_DELETED = "com.sun.faces.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "com.sun.faces.facelets.MARK_ID";
    private static final String IMPLICIT_PANEL = "com.sun.faces.facelets.IMPLICIT_PANEL";
    public static final String COMPONENT_TO_TAG_MAP_NAME = "com.sun.faces.facelets.COMPONENT_TO_LOCATION_MAP";

    public static void finalizeForDeletion(UIComponent c) {
        Map facets;
        c.getAttributes().remove(MARK_DELETED);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_DELETED)) continue;
                cl.remove(sz);
            }
        }
        if ((facets = c.getFacets()).size() > 0) {
            Set col = facets.entrySet();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                Map.Entry curEntry = itr.next();
                UIComponent fc = (UIComponent)curEntry.getValue();
                Map attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_DELETED)) {
                    itr.remove();
                    continue;
                }
                if (!attrs.containsKey(IMPLICIT_PANEL) || ((String)curEntry.getKey()).equals("javax_faces_metadata")) continue;
                List implicitPanelChildren = fc.getChildren();
                Iterator innerItr = implicitPanelChildren.iterator();
                while (innerItr.hasNext()) {
                    UIComponent innerChild = (UIComponent)innerItr.next();
                    if (!innerChild.getAttributes().containsKey(MARK_DELETED)) continue;
                    innerItr.remove();
                }
            }
        }
    }

    public static Tag setTagForComponent(FacesContext context, UIComponent c, Tag t) {
        Map contextMap = context.getAttributes();
        HashMap<Integer, Tag> componentToTagMap = (HashMap<Integer, Tag>)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null == componentToTagMap) {
            componentToTagMap = new HashMap<Integer, Tag>();
            contextMap.put(COMPONENT_TO_TAG_MAP_NAME, componentToTagMap);
        }
        return componentToTagMap.put(System.identityHashCode(c), t);
    }

    public static Tag getTagForComponent(FacesContext context, UIComponent c) {
        Tag result = null;
        Map contextMap = context.getAttributes();
        Map componentToTagMap = (Map)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null != componentToTagMap) {
            result = (Tag)componentToTagMap.get(System.identityHashCode(c));
        }
        return result;
    }

    public static UIComponent findChild(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                if (!id.equals(c.getId())) continue;
                return c;
            }
        }
        return null;
    }

    public static UIComponent findChildByTagId(UIComponent parent, String id) {
        ConcurrentHashMap<String, UIComponent> componentMap = ComponentSupport.getFaceletComponentMap();
        if (componentMap != null) {
            return componentMap.get(id);
        }
        return null;
    }

    public static ConcurrentHashMap<String, UIComponent> getFaceletComponentMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            if (viewRoot.getTransientStateHelper().getTransient((Object)"com.sun.faces.facelets.FACELET_COMPONENT_MAP") == null) {
                viewRoot.getTransientStateHelper().putTransient((Object)"com.sun.faces.facelets.FACELET_COMPONENT_MAP", new ConcurrentHashMap());
            }
            return (ConcurrentHashMap)viewRoot.getTransientStateHelper().getTransient((Object)"com.sun.faces.facelets.FACELET_COMPONENT_MAP");
        }
        return null;
    }

    public static Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static void markForDeletion(UIComponent c) {
        c.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_CREATED)) continue;
                cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            for (UIComponent fc : col) {
                Map attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_CREATED)) {
                    attrs.put(MARK_DELETED, Boolean.TRUE);
                    continue;
                }
                if (!attrs.containsKey(IMPLICIT_PANEL)) continue;
                List implicitPanelChildren = fc.getChildren();
                Map innerAttrs = null;
                for (UIComponent cur : implicitPanelChildren) {
                    innerAttrs = cur.getAttributes();
                    if (!innerAttrs.containsKey(MARK_CREATED)) continue;
                    innerAttrs.put(MARK_DELETED, Boolean.TRUE);
                }
            }
        }
    }

    public static void encodeRecursive(FacesContext context, UIComponent viewToRender) throws IOException, FacesException {
        if (viewToRender.isRendered()) {
            viewToRender.encodeBegin(context);
            if (viewToRender.getRendersChildren()) {
                viewToRender.encodeChildren(context);
            } else if (viewToRender.getChildCount() > 0) {
                for (UIComponent kid : viewToRender.getChildren()) {
                    ComponentSupport.encodeRecursive(context, kid);
                }
            }
            viewToRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        ComponentSupport.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
    }

    public static void addComponent(FaceletContext ctx, UIComponent parent, UIComponent child) {
        String facetName = ComponentSupport.getFacetName(parent);
        if (facetName == null) {
            if (child.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                int childIndex = (Integer)child.getAttributes().get("com.sun.faces.DynamicComponent");
                if (childIndex >= parent.getChildCount() || childIndex == -1) {
                    parent.getChildren().add(child);
                } else {
                    parent.getChildren().add(childIndex, child);
                }
            } else {
                parent.getChildren().add(child);
            }
        } else {
            UIComponent existing = (UIComponent)parent.getFacets().get(facetName);
            if (existing != null && existing != child) {
                if (existing.getAttributes().get(IMPLICIT_PANEL) == null) {
                    UIComponent panelGroup = ctx.getFacesContext().getApplication().createComponent("javax.faces.Panel");
                    parent.getFacets().put(facetName, panelGroup);
                    Map attrs = panelGroup.getAttributes();
                    attrs.put(IMPLICIT_PANEL, true);
                    panelGroup.getChildren().add(existing);
                    existing = panelGroup;
                }
                if (existing.getAttributes().get(IMPLICIT_PANEL) != null) {
                    existing.getChildren().add(child);
                } else {
                    parent.getFacets().put(facetName, child);
                }
            } else {
                parent.getFacets().put(facetName, child);
            }
        }
    }

    public static String getFacetName(UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    public static boolean suppressViewModificationEvents(FacesContext ctx) {
        String viewId;
        UIViewRoot root = ctx.getViewRoot();
        if (root != null && (viewId = root.getViewId()) != null) {
            StateContext stateCtx = StateContext.getStateContext(ctx);
            return stateCtx.isPartialStateSaving(ctx, viewId);
        }
        return false;
    }
}

