/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.StateContext;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public final class ComponentSupport {
    private static final String MARK_DELETED = "com.sun.faces.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "com.sun.faces.facelets.MARK_ID";
    private static final String IMPLICIT_PANEL = "com.sun.faces.facelets.IMPLICIT_PANEL";
    private static final String MAKE_SURE_ANCESTOR_IS_FORM = "com.sun.faces.facelets.MAKE_SURE_ANCESTOR_IS_FORM";
    public static final String COMPONENT_TO_TAG_MAP_NAME = "com.sun.faces.facelets.COMPONENT_TO_LOCATION_MAP";
    private static final String _UNIQUE_IDS_ATTR = "com.sun.facelets.tag.jsf._needUniqueIds";

    public static void finalizeForDeletion(UIComponent c) {
        Map facets;
        c.getAttributes().remove(MARK_DELETED);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_DELETED)) continue;
                cl.remove(sz);
            }
        }
        if ((facets = c.getFacets()).size() > 0) {
            Set col = facets.entrySet();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                Map.Entry curEntry = itr.next();
                UIComponent fc = (UIComponent)curEntry.getValue();
                Map attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_DELETED)) {
                    itr.remove();
                    continue;
                }
                if (!attrs.containsKey(IMPLICIT_PANEL) || ((String)curEntry.getKey()).equals("javax_faces_metadata")) continue;
                List implicitPanelChildren = fc.getChildren();
                Iterator innerItr = implicitPanelChildren.iterator();
                while (innerItr.hasNext()) {
                    UIComponent innerChild = (UIComponent)innerItr.next();
                    if (!innerChild.getAttributes().containsKey(MARK_DELETED)) continue;
                    innerItr.remove();
                }
            }
        }
    }

    public static Tag setTagForComponent(FacesContext context, UIComponent c, Tag t) {
        Map contextMap = context.getAttributes();
        HashMap<Integer, Tag> componentToTagMap = (HashMap<Integer, Tag>)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null == componentToTagMap) {
            componentToTagMap = new HashMap<Integer, Tag>();
            contextMap.put(COMPONENT_TO_TAG_MAP_NAME, componentToTagMap);
        }
        return componentToTagMap.put(System.identityHashCode(c), t);
    }

    public static Tag getTagForComponent(FacesContext context, UIComponent c) {
        Tag result = null;
        Map contextMap = context.getAttributes();
        Map componentToTagMap = (Map)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null != componentToTagMap) {
            result = (Tag)componentToTagMap.get(System.identityHashCode(c));
        }
        return result;
    }

    public static UIComponent findChild(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                if (!id.equals(c.getId())) continue;
                return c;
            }
        }
        return null;
    }

    public static UIComponent findUIInstructionChildByTagId(FacesContext context, UIComponent parent, String id) {
        UIComponent result = null;
        if (!context.isPostback() || context.getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            return null;
        }
        Map attrs = context.getAttributes();
        if (attrs.containsKey((Object)WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving) && ((Boolean)attrs.get((Object)WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving)).booleanValue()) {
            result = ComponentSupport.findChildByTagId(context, parent, id);
        }
        return result;
    }

    public static UIComponent findChildByTagId(FacesContext context, UIComponent parent, String id) {
        ArrayList components;
        if (!context.isPostback() || context.getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            return null;
        }
        UIComponent c = null;
        String cid = null;
        if (0 < parent.getFacetCount()) {
            components = new ArrayList();
            components.addAll(parent.getFacets().values());
            components.addAll(parent.getChildren());
        } else {
            components = parent.getChildren();
        }
        int len = components.size();
        for (int i = 0; i < len; ++i) {
            UIComponent foundChild;
            c = (UIComponent)components.get(i);
            cid = (String)c.getAttributes().get(MARK_CREATED);
            if (id.equals(cid)) {
                return c;
            }
            if (c instanceof UIPanel && c.getAttributes().containsKey(IMPLICIT_PANEL)) {
                for (UIComponent c2 : c.getChildren()) {
                    cid = (String)c2.getAttributes().get(MARK_CREATED);
                    if (!id.equals(cid)) continue;
                    return c2;
                }
            }
            if ((foundChild = ComponentSupport.findChildByTagId(context, c, id)) == null) continue;
            return foundChild;
        }
        return null;
    }

    public static Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static void markForDeletion(UIComponent c) {
        c.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_CREATED)) continue;
                cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            for (UIComponent fc : col) {
                Map attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_CREATED)) {
                    attrs.put(MARK_DELETED, Boolean.TRUE);
                    continue;
                }
                if (!attrs.containsKey(IMPLICIT_PANEL)) continue;
                List implicitPanelChildren = fc.getChildren();
                Map innerAttrs = null;
                for (UIComponent cur : implicitPanelChildren) {
                    innerAttrs = cur.getAttributes();
                    if (!innerAttrs.containsKey(MARK_CREATED)) continue;
                    innerAttrs.put(MARK_DELETED, Boolean.TRUE);
                }
            }
        }
    }

    public static void encodeRecursive(FacesContext context, UIComponent viewToRender) throws IOException, FacesException {
        if (viewToRender.isRendered()) {
            viewToRender.encodeBegin(context);
            if (viewToRender.getRendersChildren()) {
                viewToRender.encodeChildren(context);
            } else if (viewToRender.getChildCount() > 0) {
                for (UIComponent kid : viewToRender.getChildren()) {
                    ComponentSupport.encodeRecursive(context, kid);
                }
            }
            viewToRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        ComponentSupport.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
    }

    private static boolean inspectInterfacesToCheckIfFormOmitted(UIComponent child) {
        if (child instanceof UIViewParameter) {
            return false;
        }
        return child instanceof ActionSource || child instanceof ActionSource2 || child instanceof EditableValueHolder;
    }

    private static boolean inspectParentAncestryToCheckIfFormOmitted(UIComponent component) {
        if (component != null) {
            while (!(component instanceof UIViewRoot) && component != null) {
                if (ComponentSupport.isForm(component)) {
                    return true;
                }
                component = component.getParent();
            }
        }
        return !(component instanceof UIViewRoot);
    }

    private static boolean isForm(UIComponent component) {
        return component instanceof UIForm || component.getFamily().endsWith("Form");
    }

    private static void addFormOmittedMessage(FaceletContext ctx) {
        String key = "com.sun.faces.MISSING_FORM_ERROR";
        Object[] params = new Object[]{};
        boolean missingFormReported = false;
        FacesMessage m = MessageUtils.getExceptionMessage(key, params);
        List messageList = ctx.getFacesContext().getMessageList();
        for (FacesMessage fm : messageList) {
            if (!fm.getDetail().equals(m.getDetail())) continue;
            missingFormReported = true;
            break;
        }
        if (!missingFormReported) {
            m.setSeverity(FacesMessage.SEVERITY_WARN);
            ctx.getFacesContext().addMessage(null, m);
        }
    }

    public static boolean getMakeSureAncestorIsForm(FaceletContext ctx) {
        String s = (String)ctx.getFacesContext().getAttributes().get(MAKE_SURE_ANCESTOR_IS_FORM);
        return s != null && s.equals(Boolean.TRUE.toString());
    }

    public static void addComponent(FaceletContext ctx, UIComponent parent, UIComponent child) {
        String facetName;
        if (ctx.getFacesContext().isProjectStage(ProjectStage.Development) && !ComponentSupport.isForm(child)) {
            if ((child instanceof UIPanel || parent instanceof UIColumn || child instanceof UINamingContainer || child instanceof UIData) && ComponentSupport.getMakeSureAncestorIsForm(ctx) && !(parent instanceof UIPanel) && !(parent instanceof UIColumn) && !(parent instanceof UINamingContainer) && !(parent instanceof UIData)) {
                if (!ComponentSupport.inspectParentAncestryToCheckIfFormOmitted(parent)) {
                    ComponentSupport.addFormOmittedMessage(ctx);
                }
                ctx.getFacesContext().getAttributes().put(MAKE_SURE_ANCESTOR_IS_FORM, Boolean.FALSE.toString());
            }
            if (ComponentSupport.inspectInterfacesToCheckIfFormOmitted(child)) {
                if (parent instanceof UIPanel || parent instanceof UIColumn || parent instanceof UINamingContainer || parent instanceof UIData) {
                    ctx.getFacesContext().getAttributes().put(MAKE_SURE_ANCESTOR_IS_FORM, Boolean.TRUE.toString());
                } else if (!ComponentSupport.inspectParentAncestryToCheckIfFormOmitted(parent)) {
                    ComponentSupport.addFormOmittedMessage(ctx);
                }
            }
        }
        if ((facetName = ComponentSupport.getFacetName(parent)) == null) {
            parent.getChildren().add(child);
        } else {
            UIComponent existing = (UIComponent)parent.getFacets().get(facetName);
            if (existing != null && existing != child) {
                if (!(existing instanceof UIPanel)) {
                    UIComponent panelGroup = ctx.getFacesContext().getApplication().createComponent("javax.faces.Panel");
                    String id = null;
                    id = ComponentSupport.getViewRoot(ctx.getFacesContext(), parent).createUniqueId();
                    panelGroup.setId(id);
                    Map attrs = panelGroup.getAttributes();
                    attrs.put(IMPLICIT_PANEL, true);
                    panelGroup.getChildren().add(existing);
                    parent.getFacets().put(facetName, panelGroup);
                    existing = panelGroup;
                }
                if (existing.getAttributes().get(IMPLICIT_PANEL) != null) {
                    existing.getChildren().add(child);
                } else {
                    parent.getFacets().put(facetName, child);
                }
            } else {
                parent.getFacets().put(facetName, child);
            }
        }
    }

    public static String getFacetName(UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    public static boolean suppressViewModificationEvents(FacesContext ctx) {
        String viewId;
        UIViewRoot root = ctx.getViewRoot();
        if (root != null && (viewId = root.getViewId()) != null) {
            StateContext stateCtx = StateContext.getStateContext(ctx);
            return stateCtx.partialStateSaving(ctx, viewId);
        }
        return false;
    }

    public static final boolean setNeedUniqueIds(FaceletContext ctx, boolean needUniqueIds) {
        Boolean old = (Boolean)ctx.getAttribute(_UNIQUE_IDS_ATTR);
        ctx.setAttribute(_UNIQUE_IDS_ATTR, (Object)needUniqueIds);
        return Boolean.TRUE.equals(old);
    }

    public static boolean getNeedUniqueIds(FaceletContext ctx) {
        Boolean val = (Boolean)ctx.getAttribute(_UNIQUE_IDS_ATTR);
        return Boolean.TRUE.equals(val);
    }

    private static UIViewRoot getViewRoot(FacesContext ctx, UIComponent parent) {
        if (parent instanceof UIViewRoot) {
            return (UIViewRoot)parent;
        }
        UIViewRoot root = ctx.getViewRoot();
        if (root != null) {
            return root;
        }
        for (UIComponent c = parent.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof UIViewRoot)) continue;
            root = (UIViewRoot)c;
            break;
        }
        return root;
    }
}

