/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class ResourceInfo {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String COMPRESSED_CONTENT_DIRECTORY = "jsf-compressed";
    String name;
    String libraryName;
    String localePrefix;
    boolean cacheTimestamp;
    boolean isDevStage;
    VersionInfo version;
    ResourceHelper helper;
    LibraryInfo library;
    String path;
    String compressedPath;
    boolean compressible;
    boolean supportsEL;
    private volatile long lastModified = Long.MIN_VALUE;

    public ResourceInfo(LibraryInfo libraryInfo, String string, VersionInfo versionInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.version = versionInfo;
        this.helper = libraryInfo.getHelper();
        this.library = libraryInfo;
        this.libraryName = libraryInfo.getName();
        this.localePrefix = libraryInfo.getLocalePrefix();
        this.compressible = bl;
        this.supportsEL = bl2;
        this.isDevStage = bl3;
        this.cacheTimestamp = !bl3 && bl4;
        this.initPath(bl3);
    }

    ResourceInfo(String string, VersionInfo versionInfo, String string2, ResourceHelper resourceHelper, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.version = versionInfo;
        this.localePrefix = string2;
        this.helper = resourceHelper;
        this.compressible = bl;
        this.supportsEL = bl2;
        this.isDevStage = bl3;
        this.cacheTimestamp = !bl3 && bl4;
        this.initPath(bl3);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ResourceInfo resourceInfo = (ResourceInfo)object;
        if (this.name == null ? resourceInfo.name != null : !this.name.equals(resourceInfo.name)) {
            return false;
        }
        if (this.libraryName == null ? resourceInfo.libraryName != null : !this.libraryName.equals(resourceInfo.libraryName)) {
            return false;
        }
        if (this.localePrefix == null ? resourceInfo.localePrefix != null : !this.localePrefix.equals(resourceInfo.localePrefix)) {
            return false;
        }
        if (!(this.version == resourceInfo.version || this.version != null && this.version.equals(resourceInfo.version))) {
            return false;
        }
        if (!(this.library == resourceInfo.library || this.library != null && this.library.equals(resourceInfo.library))) {
            return false;
        }
        return !(this.path == null ? resourceInfo.path != null : !this.path.equals(resourceInfo.path));
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 97 * n + (this.libraryName != null ? this.libraryName.hashCode() : 0);
        n = 97 * n + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        n = 97 * n + (this.version != null ? this.version.hashCode() : 0);
        n = 97 * n + (this.library != null ? this.library.hashCode() : 0);
        n = 97 * n + (this.path != null ? this.path.hashCode() : 0);
        return n;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public LibraryInfo getLibraryInfo() {
        return this.library;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String getPath() {
        return this.path;
    }

    public String getCompressedPath() {
        return this.compressedPath;
    }

    public boolean isCompressable() {
        return this.compressible;
    }

    public boolean supportsEL() {
        return this.supportsEL;
    }

    public void disableEL() {
        this.supportsEL = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(FacesContext facesContext) {
        if (this.cacheTimestamp) {
            if (this.lastModified == Long.MIN_VALUE) {
                ResourceInfo resourceInfo = this;
                synchronized (resourceInfo) {
                    if (this.lastModified == Long.MIN_VALUE) {
                        this.lastModified = this.helper.getLastModified(this, facesContext);
                    }
                }
            }
            return this.lastModified;
        }
        return this.helper.getLastModified(this, facesContext);
    }

    public String toString() {
        return "ResourceInfo{name='" + this.name + '\'' + ", version='" + (this.version != null ? this.version : "NONE") + '\'' + ", libraryName='" + this.libraryName + '\'' + ", libraryVersion='" + (this.library != null ? this.library.getVersion() : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", path='" + this.path + '\'' + ", compressible='" + this.compressible + '\'' + ", compressedPath=" + this.compressedPath + '}';
    }

    private void initPath(boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(32);
        if (this.library != null) {
            stringBuilder.append(this.library.getPath());
        } else {
            stringBuilder.append(this.helper.getBaseResourcePath());
        }
        if (this.library == null && this.localePrefix != null) {
            stringBuilder.append('/').append(this.localePrefix);
        }
        if (bl && "javax.faces".equals(this.libraryName) && "jsf.js".equals(this.name)) {
            stringBuilder.append('/').append("jsf-uncompressed.js");
        } else {
            stringBuilder.append('/').append(this.name);
        }
        if (this.version != null) {
            stringBuilder.append('/').append(this.version.getVersion());
            string = this.version.getExtension();
            if (string != null) {
                stringBuilder.append('.').append(string);
            }
        }
        this.path = stringBuilder.toString();
        if (this.compressible && !this.supportsEL) {
            string = FacesContext.getCurrentInstance();
            File file = (File)string.getExternalContext().getApplicationMap().get("javax.servlet.context.tempdir");
            if (file == null || !file.isDirectory()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "File ({0}) referenced by javax.servlet.context.tempdir attribute is null, or was is not a directory.  Compression for {1} will be unavailable.", new Object[]{file == null ? "null" : file.toString(), this.path});
                }
                this.compressible = false;
            } else {
                String string2 = this.path.charAt(0) == '/' ? this.path : '/' + this.path;
                File file2 = new File(file, COMPRESSED_CONTENT_DIRECTORY + string2);
                try {
                    if (!file2.exists()) {
                        if (file2.mkdirs()) {
                            this.compressedPath = file2.getCanonicalPath();
                        } else {
                            this.compressible = false;
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_create_compression_directory", file2.getCanonicalPath());
                            }
                        }
                    } else {
                        this.compressedPath = file2.getCanonicalPath();
                    }
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception.toString(), exception);
                    }
                    this.compressible = false;
                }
            }
        }
    }
}

