/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.util.Classpath;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfFacesConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Pattern JAR_PATTERN = Pattern.compile(".*/(\\S*\\.jar).*");
    private static final String META_INF_RESOURCES = "META-INF/faces-config.xml";
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/META-INF";

    @Override
    public Collection<URI> getResources(ServletContext servletContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.DuplicateJARPattern);
        Pattern pattern = null;
        if (string != null) {
            pattern = Pattern.compile(string);
        }
        TreeMap<String, HashSet<URI>> treeMap = new TreeMap<String, HashSet<URI>>();
        ArrayList<URI> arrayList = new ArrayList<URI>();
        try {
            for (URI object : this.loadURLs(servletContext)) {
                String string2 = object.toString();
                String string3 = null;
                Matcher matcher = JAR_PATTERN.matcher(string2);
                if (matcher.matches()) {
                    string3 = matcher.group(1);
                }
                if (string3 != null) {
                    HashSet<URI> hashSet;
                    if (pattern != null && (matcher = pattern.matcher(string3)).matches()) {
                        string3 = matcher.group(1);
                    }
                    if ((hashSet = (HashSet<URI>)treeMap.get(string3)) == null) {
                        hashSet = new HashSet<URI>();
                        treeMap.put(string3, hashSet);
                    }
                    hashSet.add(object);
                    continue;
                }
                arrayList.add(0, object);
            }
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
        ArrayList arrayList2 = new ArrayList(treeMap.size() + arrayList.size());
        for (Map.Entry entry : treeMap.entrySet()) {
            arrayList2.addAll((Collection)entry.getValue());
        }
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    private Collection<URI> loadURLs(ServletContext servletContext) throws IOException {
        HashSet<URI> hashSet = new HashSet<URI>();
        try {
            URL[] uRLArray = Util.getCurrentLoader(this).getResources(META_INF_RESOURCES);
            while (uRLArray.hasMoreElements()) {
                hashSet.add(new URI(((URL)uRLArray.nextElement()).toExternalForm()));
            }
            uRLArray = Classpath.search("META-INF/", ".faces-config.xml");
            for (URL object : uRLArray) {
                hashSet.add(new URI(object.toExternalForm()));
            }
            Set set = servletContext.getResourcePaths(WEB_INF_CLASSES);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    String string = e.toString();
                    if (!string.endsWith(".taglib.xml")) continue;
                    hashSet.add(new URI(servletContext.getResource(string).toExternalForm()));
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        return hashSet;
    }
}

