/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationStateInfo;
import com.sun.faces.util.ComponentStruct;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateContext {
    private static final String KEY = StateContext.class.getName() + "_KEY";
    private static final String HAS_ONE_OR_MORE_DYNAMIC_CHILD = StateContext.class.getName() + "_HAS_ONE_OR_MORE_DYNAMIC_CHILD";
    private boolean partial;
    private boolean partialLocked;
    private boolean trackMods = true;
    private AddRemoveListener modListener;
    private ApplicationStateInfo stateInfo;
    private WeakReference<UIViewRoot> viewRootRef = new WeakReference<Object>(null);

    private StateContext(ApplicationStateInfo applicationStateInfo) {
        this.stateInfo = applicationStateInfo;
    }

    public static StateContext getStateContext(FacesContext facesContext) {
        StateContext stateContext = (StateContext)facesContext.getAttributes().get(KEY);
        if (stateContext == null) {
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
            ApplicationStateInfo applicationStateInfo = applicationAssociate.getApplicationStateInfo();
            stateContext = new StateContext(applicationStateInfo);
            facesContext.getAttributes().put(KEY, stateContext);
        }
        return stateContext;
    }

    public boolean partialStateSaving(FacesContext facesContext, String string) {
        UIViewRoot uIViewRoot;
        UIViewRoot uIViewRoot2 = facesContext.getViewRoot();
        if (uIViewRoot2 != (uIViewRoot = (UIViewRoot)this.viewRootRef.get())) {
            this.viewRootRef = new WeakReference<UIViewRoot>(uIViewRoot2);
            if (uIViewRoot != null) {
                this.modListener = null;
                this.partialLocked = false;
            }
        }
        if (!this.partialLocked) {
            if (string == null) {
                string = uIViewRoot2 != null ? uIViewRoot2.getViewId() : (String)facesContext.getAttributes().get("com.sun.faces.viewId");
            }
            this.partial = this.stateInfo.usePartialStateSaving(string);
            this.partialLocked = true;
        }
        return this.partial;
    }

    public boolean trackViewModifications() {
        return this.trackMods;
    }

    public void startTrackViewModifications(FacesContext facesContext, UIViewRoot uIViewRoot) {
        if (this.modListener == null) {
            this.modListener = new AddRemoveListener(facesContext);
            uIViewRoot.subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)this.modListener);
            uIViewRoot.subscribeToViewEvent(PreRemoveFromViewEvent.class, (SystemEventListener)this.modListener);
        }
        this.setTrackViewModifications(true);
    }

    public void setTrackViewModifications(boolean bl) {
        this.trackMods = bl;
    }

    public boolean componentAddedDynamically(UIComponent uIComponent) {
        return uIComponent.getAttributes().containsKey("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT");
    }

    public int getIndexOfDynamicallyAddedChildInParent(UIComponent uIComponent) {
        int n = -1;
        Map map = uIComponent.getAttributes();
        if (map.containsKey("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT")) {
            n = (Integer)map.get("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT");
        }
        return n;
    }

    public boolean hasOneOrMoreDynamicChild(UIComponent uIComponent) {
        return uIComponent.getAttributes().containsKey(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
    }

    private int incrementDynamicChildCount(UIComponent uIComponent) {
        int n = 0;
        Map map = uIComponent.getAttributes();
        Integer n2 = (Integer)map.get(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
        if (null != n2) {
            Integer n3 = n2;
            Integer n4 = n2 = Integer.valueOf(n2 + 1);
            n = n3;
        } else {
            n = 1;
        }
        map.put(HAS_ONE_OR_MORE_DYNAMIC_CHILD, n);
        return n;
    }

    private int decrementDynamicChildCount(UIComponent uIComponent) {
        int n = 0;
        Map map = uIComponent.getAttributes();
        Integer n2 = (Integer)map.get(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
        if (null != n2) {
            int n3;
            if (0 < n2) {
                Integer n4 = n2;
                Integer n5 = n2 = Integer.valueOf(n2 - 1);
                n3 = n4;
            } else {
                n3 = n = 0;
            }
        }
        if (0 == n && null != n2) {
            map.remove(HAS_ONE_OR_MORE_DYNAMIC_CHILD);
        }
        return n;
    }

    public Map<String, ComponentStruct> getDynamicAdds() {
        return this.modListener != null ? this.modListener.getDynamicAdds() : null;
    }

    public List<String> getDynamicRemoves() {
        return this.modListener != null ? this.modListener.dynamicRemoves : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddRemoveListener
    implements SystemEventListener {
        private StateContext stateCtx;
        private LinkedHashMap<String, ComponentStruct> dynamicAdds;
        private List<String> dynamicRemoves;

        public AddRemoveListener(FacesContext facesContext) {
            this.stateCtx = StateContext.getStateContext(facesContext);
        }

        public Map<String, ComponentStruct> getDynamicAdds() {
            if (null == this.dynamicAdds) {
                this.dynamicAdds = new LinkedHashMap();
            }
            return this.dynamicAdds;
        }

        public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (systemEvent instanceof PreRemoveFromViewEvent) {
                if (this.stateCtx.trackViewModifications()) {
                    this.handleRemoveEvent(facesContext, (PreRemoveFromViewEvent)systemEvent);
                }
            } else if (this.stateCtx.trackViewModifications()) {
                this.handleAddEvent(facesContext, (PostAddToViewEvent)systemEvent);
            }
        }

        public boolean isListenerForSource(Object object) {
            return object instanceof UIComponent;
        }

        private void handleRemoveEvent(FacesContext facesContext, PreRemoveFromViewEvent preRemoveFromViewEvent) {
            UIComponent uIComponent = preRemoveFromViewEvent.getComponent();
            if (uIComponent.isTransient()) {
                return;
            }
            for (UIComponent uIComponent2 = uIComponent.getParent(); uIComponent2 != null; uIComponent2 = uIComponent2.getParent()) {
                if (!uIComponent2.isTransient()) continue;
                return;
            }
            if (this.dynamicRemoves == null) {
                this.dynamicRemoves = new ArrayList<String>();
            }
            String string = preRemoveFromViewEvent.getComponent().getClientId(facesContext);
            if (this.dynamicAdds != null && this.dynamicAdds.containsKey(string)) {
                this.dynamicAdds.remove(string);
            }
            StateContext.this.decrementDynamicChildCount(uIComponent.getParent());
            this.dynamicRemoves.add(string);
        }

        private void handleAddEvent(FacesContext facesContext, PostAddToViewEvent postAddToViewEvent) {
            UIComponent uIComponent;
            if (facesContext.getViewRoot().isTransient()) {
                return;
            }
            UIComponent uIComponent2 = postAddToViewEvent.getComponent();
            if (uIComponent2.isTransient() || uIComponent2 instanceof UIViewRoot) {
                return;
            }
            for (uIComponent = uIComponent2.getParent(); uIComponent != null; uIComponent = uIComponent.getParent()) {
                if (!uIComponent.isTransient()) continue;
                return;
            }
            uIComponent = uIComponent2.getParent();
            StateContext.this.incrementDynamicChildCount(uIComponent);
            ComponentStruct componentStruct = new ComponentStruct();
            componentStruct.absorbComponent(facesContext, uIComponent2);
            if (this.dynamicRemoves != null) {
                this.dynamicRemoves.remove(componentStruct.clientId);
            }
            uIComponent2.getAttributes().put("com.sun.faces.StateHolderSaver_DYNAMIC_COMPONENT", new Integer(componentStruct.indexOfChildInParent));
            this.getDynamicAdds().put(componentStruct.clientId, componentStruct);
        }
    }
}

