/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.tag.AbstractTagLibrary;
import com.sun.faces.facelets.tag.TagLibraryImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class CompositeComponentTagLibrary
extends TagLibraryImpl {
    private static final Logger LOGGER = FacesLogger.FACELETS_COMPONENT.getLogger();
    private String ns = null;
    private String compositeLibraryName;
    private boolean enableMissingResourceLibraryDetection;
    private static final String NS_COMPOSITE_COMPONENT_PREFIX = "http://java.sun.com/jsf/composite/";

    public CompositeComponentTagLibrary(String string) {
        super(string);
        if (null == string) {
            throw new NullPointerException();
        }
        this.ns = string;
        this.init();
    }

    public CompositeComponentTagLibrary(String string, String string2) {
        super(string);
        if (null == string) {
            throw new NullPointerException();
        }
        this.ns = string;
        if (null == string2) {
            throw new NullPointerException();
        }
        this.compositeLibraryName = string2;
        this.init();
    }

    private void init() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.enableMissingResourceLibraryDetection = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection);
    }

    public boolean containsTagHandler(String string, String string2) {
        boolean bl = false;
        Resource resource = null;
        resource = this.getCompositeComponentResource(string, string2);
        if (null != resource) {
            InputStream inputStream;
            block3: {
                inputStream = null;
                try {
                    inputStream = resource.getInputStream();
                }
                catch (IOException iOException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
                }
            }
            bl = inputStream != null;
        }
        return bl || super.containsTagHandler(string, string2);
    }

    private Resource getCompositeComponentResource(String string, String string2) {
        Resource resource = null;
        if (string.equals(this.ns)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            String string3 = this.getCompositeComponentLibraryName(this.ns);
            if (null != string3) {
                String string4 = string2 + ".xhtml";
                ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
                resource = resourceHandler.createResource(string4, string3);
            }
        }
        return resource;
    }

    public TagHandler createTagHandler(String string, String string2, TagConfig tagConfig) throws FacesException {
        Object object = super.createTagHandler(string, string2, tagConfig);
        if (object == null) {
            AbstractTagLibrary.ComponentConfigWrapper componentConfigWrapper = new AbstractTagLibrary.ComponentConfigWrapper(tagConfig, "javax.faces.NamingContainer", null);
            object = new CompositeComponentTagHandler(this.getCompositeComponentResource(string, string2), componentConfigWrapper);
        }
        return object;
    }

    public boolean tagLibraryForNSExists(String string) {
        boolean bl = false;
        String string2 = null;
        string2 = this.getCompositeComponentLibraryName(string);
        if (null != string2) {
            if (this.enableMissingResourceLibraryDetection) {
                bl = FacesContext.getCurrentInstance().getApplication().getResourceHandler().libraryExists(string2);
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Skipping call to libraryExists().  Please set context-param {0} to true to verify if library {1} actually exists", new Object[]{WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection.getQualifiedName(), string});
                }
                bl = true;
            }
        }
        return bl;
    }

    public static boolean scriptComponentForResourceExists(FacesContext facesContext, Resource resource) {
        boolean bl;
        block2: {
            bl = false;
            Resource resource2 = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId()).getScriptComponentResource(facesContext, resource);
            try {
                bl = null != resource2 && null != resource2.getInputStream();
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
        return bl;
    }

    private String getCompositeComponentLibraryName(String string) {
        String string2 = null;
        if (null != this.compositeLibraryName) {
            string2 = this.compositeLibraryName;
        } else {
            int n = string.indexOf(NS_COMPOSITE_COMPONENT_PREFIX);
            if (-1 != n && (n += NS_COMPOSITE_COMPONENT_PREFIX.length()) < string.length()) {
                string2 = string.substring(n);
            }
        }
        return string2;
    }
}

