/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonRenderer
extends HtmlBasicRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.COMMANDBUTTON);

    @Override
    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldDecode(uIComponent)) {
            return;
        }
        String string = this.decodeBehaviors(facesContext, uIComponent);
        if (ButtonRenderer.wasClicked(facesContext, uIComponent, string) && !ButtonRenderer.isReset(uIComponent)) {
            uIComponent.queueEvent((FacesEvent)new ActionEvent(uIComponent));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This command resulted in form submission  ActionEvent queued.");
                logger.log(Level.FINE, "End decoding component {0}", uIComponent.getId());
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        Collection<ClientBehaviorContext.Parameter> collection;
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        String string = ButtonRenderer.getButtonType(uIComponent);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        String string2 = "";
        Object object = ((UICommand)uIComponent).getValue();
        if (object != null) {
            string2 = object.toString();
        }
        if (!(collection = this.getBehaviorParameters(uIComponent)).isEmpty() && (string.equals("submit") || string.equals("button"))) {
            RenderKitUtils.renderJsfJs(facesContext);
        }
        String string3 = (String)uIComponent.getAttributes().get("image");
        responseWriter.startElement("input", uIComponent);
        this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        String string4 = uIComponent.getClientId(facesContext);
        if (string3 != null) {
            responseWriter.writeAttribute("type", (Object)"image", "type");
            responseWriter.writeURIAttribute("src", (Object)RenderKitUtils.getImageSource(facesContext, uIComponent, "image"), "image");
            responseWriter.writeAttribute("name", (Object)string4, "clientId");
        } else {
            responseWriter.writeAttribute("type", (Object)string, "type");
            responseWriter.writeAttribute("name", (Object)string4, "clientId");
            responseWriter.writeAttribute("value", (Object)string2, "value");
        }
        RenderKitUtils.renderPassThruAttributes(facesContext, responseWriter, uIComponent, ATTRIBUTES, ButtonRenderer.getNonOnClickBehaviors(uIComponent));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(responseWriter, uIComponent);
        String string5 = (String)uIComponent.getAttributes().get("styleClass");
        if (string5 != null && string5.length() > 0) {
            responseWriter.writeAttribute("class", (Object)string5, "styleClass");
        }
        RenderKitUtils.renderOnclick(facesContext, uIComponent, collection, null, false);
        responseWriter.endElement("input");
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
    }

    private static boolean wasClicked(FacesContext facesContext, UIComponent uIComponent, String string) {
        Map map;
        if (string == null) {
            string = uIComponent.getClientId(facesContext);
        }
        if ((map = facesContext.getExternalContext().getRequestParameterMap()).get(string) == null) {
            if (RenderKitUtils.isPartialOrBehaviorAction(facesContext, string)) {
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            String string2 = stringBuilder.append(".x").toString();
            stringBuilder.setLength(string.length());
            String string3 = stringBuilder.append(".y").toString();
            return map.get(string2) != null && map.get(string3) != null;
        }
        return true;
    }

    private static boolean isReset(UIComponent uIComponent) {
        return "reset".equals(uIComponent.getAttributes().get("type"));
    }

    private static String getButtonType(UIComponent uIComponent) {
        String string = (String)uIComponent.getAttributes().get("type");
        if (string == null || !"reset".equals(string) && !"submit".equals(string) && !"button".equals(string)) {
            string = "submit";
            uIComponent.getAttributes().put("type", string);
        }
        return string;
    }

    private static Map<String, List<ClientBehavior>> getNonOnClickBehaviors(UIComponent uIComponent) {
        return ButtonRenderer.getPassThruBehaviors(uIComponent, "click", "action");
    }
}

