/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiKeyConcurrentHashMap<K, V> {
    static int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_SEGMENTS = 16;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;

    static int hash(Object object, Object object2, Object object3, Object object4) {
        int n = 0;
        n ^= object.hashCode();
        if (object2 != null) {
            n ^= object2.hashCode();
        }
        if (object3 != null) {
            n ^= object3.hashCode();
        }
        if (object4 != null) {
            n ^= object4.hashCode();
        }
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    final Segment<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    public MultiKeyConcurrentHashMap(int n, float f, int n2) {
        int n3;
        int n4;
        int n5;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n6 = 0;
        for (n5 = 1; n5 < n2; n5 <<= 1) {
            ++n6;
        }
        this.segmentShift = 32 - n6;
        this.segmentMask = n5 - 1;
        this.segments = new Segment[n5];
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n4 = n / n5) * n5 < n) {
            ++n4;
        }
        for (n3 = 1; n3 < n4; n3 <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(n3, f);
        }
    }

    public MultiKeyConcurrentHashMap(int n) {
        this(n, 0.75f, 16);
    }

    public MultiKeyConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f, 16);
    }

    public boolean isEmpty() {
        int n;
        Segment[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n2 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) {
                return false;
            }
            nArray[n] = segmentArray[n].modCount;
            n2 += nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                return false;
            }
        }
        return true;
    }

    public int size() {
        int n;
        Segment[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n = 0; n < 2; ++n) {
            int n2;
            l2 = 0L;
            l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l += (long)segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    l2 += (long)segmentArray[n2].count;
                    if (nArray[n2] == segmentArray[n2].modCount) continue;
                    l2 = -1L;
                    break;
                }
            }
            if (l2 == l) break;
        }
        if (l2 != l) {
            l = 0L;
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].lock();
            }
            for (n = 0; n < segmentArray.length; ++n) {
                l += (long)segmentArray[n].count;
            }
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public V get(Object object) {
        int n = MultiKeyConcurrentHashMap.hash(object, null, null, null);
        return this.segmentFor(n).get(object, null, null, null, n);
    }

    public V get(Object object, Object object2) {
        int n = MultiKeyConcurrentHashMap.hash(object, object2, null, null);
        return this.segmentFor(n).get(object, object2, null, null, n);
    }

    public V get(Object object, Object object2, Object object3) {
        int n = MultiKeyConcurrentHashMap.hash(object, object2, object3, null);
        return this.segmentFor(n).get(object, object2, object3, null, n);
    }

    public V get(Object object, Object object2, Object object3, Object object4) {
        int n = MultiKeyConcurrentHashMap.hash(object, object2, object3, object4);
        return this.segmentFor(n).get(object, object2, object3, object4, n);
    }

    public boolean containsKey(Object object) {
        int n = MultiKeyConcurrentHashMap.hash(object, null, null, null);
        return this.segmentFor(n).containsKey(object, null, null, null, n);
    }

    public boolean containsKey(Object object, Object object2) {
        int n = MultiKeyConcurrentHashMap.hash(object, object2, null, null);
        return this.segmentFor(n).containsKey(object, object2, null, null, n);
    }

    public boolean containsKey(Object object, Object object2, Object object3) {
        int n = MultiKeyConcurrentHashMap.hash(object, object2, object3, null);
        return this.segmentFor(n).containsKey(object, object2, object3, null, n);
    }

    public boolean containsKey(Object object, Object object2, Object object3, Object object4) {
        int n = MultiKeyConcurrentHashMap.hash(object, object2, object3, object4);
        return this.segmentFor(n).containsKey(object, object2, object3, object4, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        int n;
        boolean bl;
        if (object == null) {
            throw new NullPointerException();
        }
        Segment[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (bl = false; bl < 2 != 0; bl += 1) {
            int n2;
            n = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                nArray[n2] = segmentArray[n2].modCount;
                n += nArray[n2];
                if (!segmentArray[n2].containsValue(object)) continue;
                return true;
            }
            n2 = 1;
            if (n != 0) {
                for (int i = 0; i < segmentArray.length; ++i) {
                    if (nArray[i] == segmentArray[i].modCount) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n2 == 0) continue;
            return false;
        }
        for (bl = false; bl < segmentArray.length; bl += 1) {
            segmentArray[bl].lock();
        }
        bl = false;
        try {
            for (n = 0; n < segmentArray.length; ++n) {
                if (!segmentArray[n].containsValue(object)) continue;
                bl = true;
                break;
            }
        }
        finally {
            for (n = 0; n < segmentArray.length; ++n) {
                segmentArray[n].unlock();
            }
        }
        return bl;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, null, null, null);
        return this.segmentFor(n).put(k, null, null, null, n, v, false);
    }

    public V put(K k, K k2, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, k2, null, null);
        return this.segmentFor(n).put(k, k2, null, null, n, v, false);
    }

    public V put(K k, K k2, K k3, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, k2, k3, null);
        return this.segmentFor(n).put(k, k2, k3, null, n, v, false);
    }

    public V put(K k, K k2, K k3, K k4, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, k2, k3, k4);
        return this.segmentFor(n).put(k, k2, k3, k4, n, v, false);
    }

    public V putIfAbsent(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, null, null, null);
        return this.segmentFor(n).put(k, null, null, null, n, v, true);
    }

    public V putIfAbsent(K k, K k2, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, k2, null, null);
        return this.segmentFor(n).put(k, k2, null, null, n, v, true);
    }

    public V putIfAbsent(K k, K k2, K k3, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, k2, k3, null);
        return this.segmentFor(n).put(k, k2, k3, null, n, v, true);
    }

    public V putIfAbsent(K k, K k2, K k3, K k4, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, k2, k3, k4);
        return this.segmentFor(n).put(k, k2, k3, k4, n, v, true);
    }

    public V remove(K k) {
        int n = MultiKeyConcurrentHashMap.hash(k, null, null, null);
        return this.segmentFor(n).remove(k, null, null, null, n, null);
    }

    public V remove(K k, K k2) {
        int n = MultiKeyConcurrentHashMap.hash(k, k2, null, null);
        return this.segmentFor(n).remove(k, k2, null, null, n, null);
    }

    public V remove(K k, K k2, K k3) {
        int n = MultiKeyConcurrentHashMap.hash(k, k2, k3, null);
        return this.segmentFor(n).remove(k, k2, null, null, n, null);
    }

    public V remove(K k, K k2, K k3, K k4) {
        int n = MultiKeyConcurrentHashMap.hash(k, k2, k3, k4);
        return this.segmentFor(n).remove(k, k2, k3, k4, n, null);
    }

    public boolean replace(K k, V v, V v2) {
        if (v == null || v2 == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, null, null, null);
        return this.segmentFor(n).replace(k, null, null, null, n, v, v2);
    }

    public V replace(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        int n = MultiKeyConcurrentHashMap.hash(k, null, null, null);
        return this.segmentFor(n).replace(k, null, null, null, n, v);
    }

    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Segment<K, V>
    extends ReentrantLock {
        volatile int count;
        int modCount;
        int threshold;
        volatile HashEntry[] table;
        final float loadFactor;

        Segment(int n, float f) {
            this.loadFactor = f;
            this.setTable(new HashEntry[n]);
        }

        void setTable(HashEntry[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
        }

        HashEntry<K, V> getFirst(int n) {
            HashEntry[] hashEntryArray = this.table;
            return hashEntryArray[n & hashEntryArray.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                Object v = hashEntry.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object object, Object object2, Object object3, Object object4, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key1) && (object2 == null && hashEntry.key2 == null || object2 != null && object2.equals(hashEntry.key2)) && (object3 == null && hashEntry.key3 == null || object3 != null && object3.equals(hashEntry.key3)) && (object4 == null && hashEntry.key4 == null || object4 != null && object4.equals(hashEntry.key2))) {
                        Object v = hashEntry.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        boolean containsKey(Object object, Object object2, Object object3, Object object4, int n) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null) {
                    if (hashEntry.hash == n && object.equals(hashEntry.key1) && (object2 == null && hashEntry.key2 == null || object2 != null && object2.equals(hashEntry.key2)) && (object3 == null && hashEntry.key3 == null || object3 != null && object3.equals(hashEntry.key3)) && (object4 == null && hashEntry.key4 == null || object4 != null && object4.equals(hashEntry.key2))) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean containsValue(Object object) {
            if (this.count != 0) {
                for (HashEntry hashEntry : this.table) {
                    void hashEntry2;
                    while (hashEntry2 != null) {
                        Object v = hashEntry2.value;
                        if (v == null) {
                            v = this.readValueUnderLock((HashEntry<K, V>)hashEntry2);
                        }
                        if (object.equals(v)) {
                            return true;
                        }
                        HashEntry hashEntry3 = hashEntry2.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k, K k2, K k3, K k4, int n, V v, V v2) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null && (hashEntry.hash != n || k != null && !k.equals(hashEntry.key1) || k2 != null && !k2.equals(hashEntry.key2) || k3 != null && !k3.equals(hashEntry.key3) || k4 != null && !k4.equals(hashEntry.key4))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl = false;
                if (hashEntry != null && v.equals(hashEntry.value)) {
                    bl = true;
                    hashEntry.value = v2;
                }
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k, K k2, K k3, K k4, int n, V v) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n);
                while (hashEntry != null && (hashEntry.hash != n || k != null && !k.equals(hashEntry.key1) || k2 != null && !k2.equals(hashEntry.key2) || k3 != null && !k3.equals(hashEntry.key3) || k4 != null && !k4.equals(hashEntry.key4))) {
                    hashEntry = hashEntry.next;
                }
                V v2 = null;
                if (hashEntry != null) {
                    v2 = hashEntry.value;
                    hashEntry.value = v;
                }
                V v3 = v2;
                return v3;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k, K k2, K k3, K k4, int n, V v, boolean bl) {
            this.lock();
            try {
                V v2;
                HashEntry hashEntry;
                int n2 = this.count;
                if (n2++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry hashEntry2 = hashEntry = hashEntryArray[n3];
                while (hashEntry2 != null && (hashEntry2.hash != n || k != null && !k.equals(hashEntry2.key1) || k2 != null && !k2.equals(hashEntry2.key2) || k3 != null && !k3.equals(hashEntry2.key3) || k4 != null && !k4.equals(hashEntry2.key4))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    v2 = hashEntry2.value;
                    if (!bl) {
                        hashEntry2.value = v;
                    }
                } else {
                    v2 = null;
                    ++this.modCount;
                    hashEntryArray[n3] = new HashEntry(k, k2, k3, k4, n, hashEntry, v);
                    this.count = n2;
                }
                V v3 = v2;
                return v3;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry[] hashEntryArray = this.table;
            int n = hashEntryArray.length;
            if (n >= 0x40000000) {
                return;
            }
            HashEntry[] hashEntryArray2 = new HashEntry[n << 1];
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n2 = hashEntryArray2.length - 1;
            for (int i = 0; i < n; ++i) {
                int n3;
                HashEntry hashEntry = hashEntryArray[i];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n4 = hashEntry.hash & n2;
                if (hashEntry2 == null) {
                    hashEntryArray2[n4] = hashEntry;
                    continue;
                }
                HashEntry hashEntry3 = hashEntry;
                int n5 = n4;
                HashEntry hashEntry4 = hashEntry2;
                while (hashEntry4 != null) {
                    n3 = hashEntry4.hash & n2;
                    if (n3 != n5) {
                        n5 = n3;
                        hashEntry3 = hashEntry4;
                    }
                    hashEntry4 = hashEntry4.next;
                }
                hashEntryArray2[n5] = hashEntry3;
                hashEntry4 = hashEntry;
                while (hashEntry4 != hashEntry3) {
                    n3 = hashEntry4.hash & n2;
                    HashEntry hashEntry5 = hashEntryArray2[n3];
                    hashEntryArray2[n3] = new HashEntry(hashEntry4.key1, hashEntry4.key2, hashEntry4.key3, hashEntry4.key4, hashEntry4.hash, hashEntry5, hashEntry4.value);
                    hashEntry4 = hashEntry4.next;
                }
            }
            this.table = hashEntryArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, Object object2, Object object3, Object object4, int n, Object object5) {
            this.lock();
            try {
                V v;
                HashEntry hashEntry;
                int n2 = this.count - 1;
                HashEntry[] hashEntryArray = this.table;
                int n3 = n & hashEntryArray.length - 1;
                HashEntry hashEntry2 = hashEntry = hashEntryArray[n3];
                while (hashEntry2 != null && (hashEntry2.hash != n || object != null && !object.equals(hashEntry2.key1) || object2 != null && !object2.equals(hashEntry2.key2) || object3 != null && !object3.equals(hashEntry2.key3) || object4 != null && !object4.equals(hashEntry2.key4))) {
                    hashEntry2 = hashEntry2.next;
                }
                V v2 = null;
                if (hashEntry2 != null) {
                    v = hashEntry2.value;
                    if (object5 == null || object5.equals(v)) {
                        v2 = v;
                        ++this.modCount;
                        HashEntry hashEntry3 = hashEntry2.next;
                        HashEntry hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry2) {
                            hashEntry3 = new HashEntry(hashEntry4.key1, hashEntry4.key2, hashEntry4.key3, hashEntry4.key4, hashEntry4.hash, hashEntry3, hashEntry4.value);
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray[n3] = hashEntry3;
                        this.count = n2;
                    }
                }
                v = v2;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry[] hashEntryArray = this.table;
                    for (int i = 0; i < hashEntryArray.length; ++i) {
                        hashEntryArray[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HashEntry<K, V> {
        final K key1;
        final K key2;
        final K key3;
        final K key4;
        final int hash;
        volatile V value;
        final HashEntry<K, V> next;

        HashEntry(K k, K k2, K k3, K k4, int n, HashEntry<K, V> hashEntry, V v) {
            this.key1 = k;
            this.key2 = k2;
            this.key3 = k3;
            this.key4 = k4;
            this.hash = n;
            this.next = hashEntry;
            this.value = v;
        }
    }
}

