/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.vendor;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContainerInjectionProvider
implements InjectionProvider {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    @Override
    public void inject(Object object) throws InjectionProviderException {
    }

    @Override
    public void invokePreDestroy(Object object) throws InjectionProviderException {
        if (object != null) {
            WebContainerInjectionProvider.invokeAnnotatedMethod(WebContainerInjectionProvider.getAnnotatedMethod(object, PreDestroy.class), object);
        }
    }

    @Override
    public void invokePostConstruct(Object object) throws InjectionProviderException {
        if (object != null) {
            WebContainerInjectionProvider.invokeAnnotatedMethod(WebContainerInjectionProvider.getAnnotatedMethod(object, PostConstruct.class), object);
        }
    }

    private static void invokeAnnotatedMethod(Method method, Object object) throws InjectionProviderException {
        if (method != null) {
            boolean bl = method.isAccessible();
            method.setAccessible(true);
            try {
                method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new InjectionProviderException(exception.getMessage(), exception);
            }
            finally {
                method.setAccessible(bl);
            }
        }
    }

    private static Method getAnnotatedMethod(Object object, Class<? extends Annotation> clazz) {
        Class<?> clazz2 = object.getClass();
        while (!Object.class.equals(clazz2)) {
            Method[] methodArray;
            for (Method method : methodArray = clazz2.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(clazz)) continue;
                if (Modifier.isStatic(method.getModifiers())) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.core.web.injection.method_not_static", new Object[]{method.toString(), clazz.getName()});
                    continue;
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.core.web.injection.method_return_not_void", new Object[]{method.toString(), clazz.getName()});
                    continue;
                }
                if (method.getParameterTypes().length != 0) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.core.web.injection.method_no_params", new Object[]{method.toString(), clazz.getName()});
                    continue;
                }
                Class<?>[] classArray = method.getExceptionTypes();
                if (method.getExceptionTypes().length != 0) {
                    boolean bl = false;
                    for (Class<?> clazz3 : classArray) {
                        if (RuntimeException.class.isAssignableFrom(clazz3)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, "jsf.core.web.injection.method_no_checked_exceptions", new Object[]{method.toString(), clazz.getName()});
                        continue;
                    }
                }
                return method;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }
}

