/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ByteArrayWebOutputStream;
import com.sun.faces.application.WebPrintWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ViewHandlerResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayWebOutputStream basos;
    private WebPrintWriter pw;
    private CharArrayWriter caw;
    private int status = 200;

    public ViewHandlerResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void sendError(int n, String string) throws IOException {
        super.sendError(n, string);
        this.status = n;
    }

    public void sendError(int n) throws IOException {
        super.sendError(n);
        this.status = n;
    }

    public void setStatus(int n) {
        super.setStatus(n);
        this.status = n;
    }

    public void setStatus(int n, String string) {
        super.setStatus(n, string);
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isBytes() {
        return null != this.basos;
    }

    public boolean isChars() {
        return null != this.caw;
    }

    public byte[] getBytes() {
        byte[] byArray = null;
        if (null != this.basos) {
            byArray = this.basos.toByteArray();
        }
        return byArray;
    }

    public char[] getChars() {
        char[] cArray = null;
        if (null != this.caw) {
            cArray = this.caw.toCharArray();
        }
        return cArray;
    }

    public String toString() {
        String string = "null";
        if (null != this.caw) {
            string = this.caw.toString();
        } else if (null != this.basos) {
            string = ((Object)((Object)this.basos)).toString();
        }
        return string;
    }

    public void flushContentToWrappedResponse() throws IOException {
        ServletResponse servletResponse = this.getResponse();
        if (null != this.caw) {
            this.pw.flush();
            this.caw.writeTo(servletResponse.getWriter());
            this.caw.reset();
        } else if (null != this.basos) {
            try {
                this.basos.writeTo(servletResponse.getWriter(), servletResponse.getCharacterEncoding());
            }
            catch (IllegalStateException illegalStateException) {
                this.basos.writeTo((OutputStream)servletResponse.getOutputStream());
            }
            this.basos.resetByteArray();
        }
    }

    public void flushToWriter(Writer writer, String string) throws IOException {
        if (null != this.caw) {
            this.pw.flush();
            this.caw.writeTo(writer);
            this.caw.reset();
        } else if (null != this.basos) {
            this.basos.writeTo(writer, string);
            this.basos.resetByteArray();
        }
        writer.flush();
    }

    public void resetBuffers() throws IOException {
        if (null != this.caw) {
            this.caw.reset();
        } else if (null != this.basos) {
            this.basos.resetByteArray();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.pw != null && !this.pw.isComitted() && !this.isCommitted()) {
            throw new IllegalStateException();
        }
        if (this.pw != null && (this.pw.isComitted() || this.isCommitted())) {
            return ByteArrayWebOutputStream.NOOP_STREAM;
        }
        if (null == this.basos) {
            this.basos = new ByteArrayWebOutputStream();
        }
        return this.basos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.basos != null && !this.basos.isCommitted() && !this.isCommitted()) {
            throw new IllegalStateException();
        }
        if (this.basos != null && (this.basos.isCommitted() || this.isCommitted())) {
            return new WebPrintWriter(WebPrintWriter.NOOP_WRITER);
        }
        if (null == this.pw) {
            this.caw = new CharArrayWriter(1024);
            this.pw = new WebPrintWriter(this.caw);
        }
        return this.pw;
    }
}

