/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.Collection;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "javax.servlet.error.message";
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private WebConfiguration webConfig;
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext facesContext, Lifecycle lifecycle, ListIterator<PhaseListener> listIterator) {
        Util.getViewHandler(facesContext).initView(facesContext);
        super.doPhase(facesContext, lifecycle, listIterator);
        this.notifyAfter(facesContext, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a pre created view in FacesContext");
            }
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            this.deliverPostRestoreStateEvent(facesContext);
            if (!facesContext.isPostback()) {
                facesContext.renderResponse();
            }
            return;
        }
        FacesException facesException = null;
        try {
            boolean bl;
            Map map = facesContext.getExternalContext().getRequestMap();
            String string = (String)map.get("javax.servlet.include.path_info");
            if (string == null) {
                string = facesContext.getExternalContext().getRequestPathInfo();
            }
            if (string == null) {
                string = (String)map.get("javax.servlet.include.servlet_path");
            }
            if (string == null) {
                string = facesContext.getExternalContext().getRequestServletPath();
            }
            if (string == null) {
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
            }
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            boolean bl2 = bl = facesContext.isPostback() && !RestoreViewPhase.isErrorPage(facesContext);
            if (bl) {
                facesContext.setProcessingEvents(false);
                uIViewRoot = viewHandler.restoreView(facesContext, string);
                if (uIViewRoot == null) {
                    if (this.is11CompatEnabled(facesContext)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Postback: recreating a view for " + string);
                        }
                        uIViewRoot = viewHandler.createView(facesContext, string);
                        facesContext.renderResponse();
                    } else {
                        Object[] objectArray = new Object[]{string};
                        throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", objectArray), string);
                    }
                }
                facesContext.setViewRoot(uIViewRoot);
                facesContext.setProcessingEvents(true);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Postback: restored view for " + string);
                }
            } else {
                String string2;
                ViewDeclarationLanguage viewDeclarationLanguage;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("New request: creating a view for " + string);
                }
                if ((viewDeclarationLanguage = viewHandler.getViewDeclarationLanguage(facesContext, string2 = viewHandler.deriveLogicalViewId(facesContext, string))) != null) {
                    Collection collection;
                    ViewMetadata viewMetadata = viewDeclarationLanguage.getViewMetadata(facesContext, string);
                    if (viewMetadata != null && (collection = ViewMetadata.getViewParameters((UIViewRoot)(uIViewRoot = viewMetadata.createMetadataView(facesContext)))).isEmpty()) {
                        facesContext.renderResponse();
                    }
                } else {
                    facesContext.renderResponse();
                }
                if (null == uIViewRoot) {
                    uIViewRoot = Util.getViewHandler(facesContext).createView(facesContext, string);
                }
                facesContext.setViewRoot(uIViewRoot);
                assert (null != uIViewRoot);
            }
        }
        catch (FacesException facesException2) {
            facesException = facesException2;
        }
        finally {
            if (null != facesException) {
                throw facesException;
            }
            this.deliverPostRestoreStateEvent(facesContext);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RestoreViewPhase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverPostRestoreStateEvent(FacesContext facesContext) throws FacesException {
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        final PostRestoreStateEvent postRestoreStateEvent = new PostRestoreStateEvent((UIComponent)uIViewRoot);
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
            uIViewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    postRestoreStateEvent.setComponent(uIComponent);
                    uIComponent.processEvent((ComponentSystemEvent)postRestoreStateEvent);
                    return VisitResult.ACCEPT;
                }
            });
        }
        catch (AbortProcessingException abortProcessingException) {
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)new ExceptionQueuedEventContext(facesContext, (Throwable)abortProcessingException, null, PhaseId.RESTORE_VIEW));
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }

    private void notifyAfter(FacesContext facesContext, Lifecycle lifecycle) {
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (null == uIViewRoot) {
            return;
        }
        MethodExpression methodExpression = uIViewRoot.getAfterPhaseListener();
        if (null != methodExpression) {
            try {
                PhaseEvent phaseEvent = new PhaseEvent(facesContext, PhaseId.RESTORE_VIEW, lifecycle);
                methodExpression.invoke(facesContext.getELContext(), new Object[]{phaseEvent});
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{methodExpression.getExpressionString(), "afterPhase"});
                }
                return;
            }
        }
    }

    private static boolean isErrorPage(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }

    private WebConfiguration getWebConfig(FacesContext facesContext) {
        if (this.webConfig == null) {
            this.webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
        }
        return this.webConfig;
    }

    private boolean is11CompatEnabled(FacesContext facesContext) {
        return this.getWebConfig(facesContext).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableRestoreView11Compatibility);
    }
}

