/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.util.FacesLogger;
import java.security.Key;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.faces.FacesException;

public final class ByteArrayGuard {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final int MAC_LENGTH = 32;
    private static final int KEY_LENGTH = 128;
    private static final int IV_LENGTH = 16;
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_CODE = "AES/CBC/PKCS5Padding";
    private static final String MAC_CODE = "HmacSHA256";
    private Mac encryptMac;
    private Mac decryptMac;
    private SecretKey sk;

    public ByteArrayGuard() {
        try {
            this.setupKeyAndMac();
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", exception);
            }
            System.err.println("ERROR: Initializing Ciphers");
        }
    }

    public byte[] encrypt(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray3 = new byte[16];
            secureRandom.nextBytes(byArray3);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            Cipher cipher = Cipher.getInstance(CIPHER_CODE);
            cipher.init(1, (Key)this.sk, ivParameterSpec);
            this.encryptMac.update(byArray3);
            byte[] byArray4 = cipher.doFinal(byArray);
            byte[] byArray5 = this.encryptMac.doFinal(byArray4);
            byte[] byArray6 = ByteArrayGuard.concatBytes(byArray5, byArray3);
            byArray2 = ByteArrayGuard.concatBytes(byArray6, byArray4);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", exception);
            }
            return null;
        }
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray) {
        try {
            byte[] byArray2 = new byte[32];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[16];
            System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
            byte[] byArray4 = new byte[byArray.length - byArray2.length - byArray3.length];
            System.arraycopy(byArray, byArray2.length + byArray3.length, byArray4, 0, byArray4.length);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            Cipher cipher = Cipher.getInstance(CIPHER_CODE);
            cipher.init(2, (Key)this.sk, ivParameterSpec);
            this.decryptMac.update(byArray3);
            this.decryptMac.update(byArray4);
            byte[] byArray5 = this.decryptMac.doFinal();
            if (this.areArrayEqualsConstantTime(byArray2, byArray5)) {
                byte[] byArray6 = cipher.doFinal(byArray4);
                return byArray6;
            }
            System.err.println("ERROR: MAC did not verify!");
            return null;
        }
        catch (Exception exception) {
            System.err.println("ERROR: Decrypting:" + exception.getCause());
            return null;
        }
    }

    private boolean areArrayEqualsConstantTime(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            bl = false;
        }
        return bl;
    }

    private void setupKeyAndMac() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
            keyGenerator.init(128);
            this.sk = keyGenerator.generateKey();
            this.encryptMac = Mac.getInstance(MAC_CODE);
            this.decryptMac = Mac.getInstance(MAC_CODE);
            this.encryptMac.init(this.sk);
            this.decryptMac.init(this.sk);
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private static byte[] concatBytes(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        try {
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
        return byArray3;
    }
}

