/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlBasicRenderer
extends Renderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();
    protected static final Param[] EMPTY_PARAMS = new Param[0];

    public String convertClientId(FacesContext facesContext, String string) {
        return string;
    }

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldDecode(uIComponent)) {
            return;
        }
        String string = this.decodeBehaviors(facesContext, uIComponent);
        if (!(uIComponent instanceof UIInput)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is not an instance or a sub class of UIInput", uIComponent.getId());
            }
            return;
        }
        if (string == null) {
            string = uIComponent.getClientId(facesContext);
        }
        assert (string != null);
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string2 = (String)map.get(string);
        if (string2 != null) {
            this.setSubmittedValue(uIComponent, string2);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "new value after decoding {0}", string2);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        String string = this.getCurrentValue(facesContext, uIComponent);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Value to be rendered {0}", string);
        }
        this.getEndTextToRender(facesContext, uIComponent, string);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected final String decodeBehaviors(FacesContext facesContext, UIComponent uIComponent) {
        if (!(uIComponent instanceof ClientBehaviorHolder)) {
            return null;
        }
        ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)uIComponent;
        Map map = clientBehaviorHolder.getClientBehaviors();
        if (map.isEmpty()) {
            return null;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Map map2 = externalContext.getRequestParameterMap();
        String string = (String)map2.get("javax.faces.behavior.event");
        if (null != string) {
            List list = (List)map.get(string);
            if (map.size() > 0) {
                String string2;
                String string3 = (String)map2.get("javax.faces.source");
                if (this.isBehaviorSource(facesContext, string3, string2 = uIComponent.getClientId())) {
                    for (ClientBehavior clientBehavior : list) {
                        clientBehavior.decode(facesContext, uIComponent);
                    }
                }
                return string2;
            }
        }
        return null;
    }

    protected boolean isBehaviorSource(FacesContext facesContext, String string, String string2) {
        return string != null && string.equals(string2);
    }

    protected String augmentIdReference(String string, UIComponent uIComponent) {
        int n;
        String string2;
        int n2 = string.lastIndexOf("j_id");
        if (n2 <= 0 && (string2 = uIComponent.getId()) != null && (n = string2.lastIndexOf("j_id")) > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Augmenting for attribute with " + string2.substring(n) + " suffix from Id attribute");
            }
            string = string + string2.substring(n);
        }
        return string;
    }

    protected void encodeRecursive(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (!uIComponent.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            Iterator<UIComponent> iterator = this.getChildren(uIComponent);
            while (iterator.hasNext()) {
                UIComponent uIComponent2 = iterator.next();
                this.encodeRecursive(facesContext, uIComponent2);
            }
        }
        uIComponent.encodeEnd(facesContext);
    }

    protected Iterator<UIComponent> getChildren(UIComponent uIComponent) {
        int n = uIComponent.getChildCount();
        if (n > 0) {
            return uIComponent.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected String getCurrentValue(FacesContext facesContext, UIComponent uIComponent) {
        Object object;
        if (uIComponent instanceof UIInput && (object = ((UIInput)uIComponent).getSubmittedValue()) != null) {
            return object.toString();
        }
        object = null;
        Object object2 = this.getValue(uIComponent);
        if (object2 != null) {
            object = this.getFormattedValue(facesContext, uIComponent, object2);
        }
        return object;
    }

    protected void getEndTextToRender(FacesContext facesContext, UIComponent uIComponent, String string) throws IOException {
    }

    protected UIComponent getFacet(UIComponent uIComponent, String string) {
        UIComponent uIComponent2 = null;
        if (uIComponent.getFacetCount() > 0 && (uIComponent2 = uIComponent.getFacet(string)) != null && !uIComponent2.isRendered()) {
            uIComponent2 = null;
        }
        return uIComponent2;
    }

    protected UIComponent getForComponent(FacesContext facesContext, String string, UIComponent uIComponent) {
        if (null == string || string.length() == 0) {
            return null;
        }
        UIComponent uIComponent2 = null;
        try {
            for (UIComponent uIComponent3 = uIComponent; uIComponent3 != null && (uIComponent2 = uIComponent3.findComponent(string)) == null; uIComponent3 = uIComponent3.getParent()) {
            }
            if (uIComponent2 == null) {
                uIComponent2 = HtmlBasicRenderer.findUIComponentBelow((UIComponent)facesContext.getViewRoot(), string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uIComponent2 == null && logger.isLoggable(Level.WARNING)) {
            logger.warning(MessageUtils.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", string));
        }
        return uIComponent2;
    }

    protected String getFormattedValue(FacesContext facesContext, UIComponent uIComponent, Object object, Converter converter) throws ConverterException {
        if (!(uIComponent instanceof ValueHolder)) {
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        if (converter == null) {
            converter = ((ValueHolder)uIComponent).getConverter();
        }
        if (converter == null) {
            if (object == null) {
                return "";
            }
            if (object instanceof String) {
                return (String)object;
            }
            Class<?> clazz = object.getClass();
            converter = Util.getConverterForClass(clazz, facesContext);
            if (converter == null) {
                return object.toString();
            }
        }
        return converter.getAsString(facesContext, uIComponent, object);
    }

    protected String getFormattedValue(FacesContext facesContext, UIComponent uIComponent, Object object) throws ConverterException {
        return this.getFormattedValue(facesContext, uIComponent, object, null);
    }

    protected Iterator getMessageIter(FacesContext facesContext, String string, UIComponent uIComponent) {
        UIComponent uIComponent2;
        Iterator iterator = null != string ? (string.length() == 0 ? facesContext.getMessages(null) : ((uIComponent2 = this.getForComponent(facesContext, string, uIComponent)) == null ? Collections.EMPTY_LIST.iterator() : facesContext.getMessages(uIComponent2.getClientId(facesContext)))) : facesContext.getMessages();
        return iterator;
    }

    protected Param[] getParamList(UIComponent uIComponent) {
        if (uIComponent.getChildCount() > 0) {
            ArrayList<Param> arrayList = new ArrayList<Param>();
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                UIParameter uIParameter;
                if (!(uIComponent2 instanceof UIParameter) || (uIParameter = (UIParameter)uIComponent2).isDisable()) continue;
                Object object = uIParameter.getValue();
                Param param = new Param(uIParameter.getName(), object == null ? null : object.toString());
                arrayList.add(param);
            }
            return arrayList.toArray(new Param[arrayList.size()]);
        }
        return EMPTY_PARAMS;
    }

    protected Collection<ClientBehaviorContext.Parameter> getBehaviorParameters(UIComponent uIComponent) {
        ArrayList<ClientBehaviorContext.Parameter> arrayList = null;
        int n = uIComponent.getChildCount();
        if (n > 0) {
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                if (!(uIComponent2 instanceof UIParameter)) continue;
                UIParameter uIParameter = (UIParameter)uIComponent2;
                String string = uIParameter.getName();
                Object object = uIParameter.getValue();
                if (string == null || string.length() <= 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<ClientBehaviorContext.Parameter>(n);
                }
                arrayList.add(new ClientBehaviorContext.Parameter(string, object));
            }
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    protected Object getValue(UIComponent uIComponent) {
        throw new UnsupportedOperationException();
    }

    protected void setSubmittedValue(UIComponent uIComponent, Object object) {
    }

    protected boolean shouldWriteIdAttribute(UIComponent uIComponent) {
        String string = uIComponent.getId();
        return null != string && (!string.startsWith("j_id") || uIComponent instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)uIComponent).getClientBehaviors().isEmpty());
    }

    protected String writeIdAttributeIfNecessary(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent) {
        String string;
        block3: {
            string = null;
            if (this.shouldWriteIdAttribute(uIComponent)) {
                try {
                    string = uIComponent.getClientId(facesContext);
                    responseWriter.writeAttribute("id", (Object)string, "id");
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_WRITE_ID_ATTRIBUTE", iOException.getMessage());
                    logger.warning(string2);
                }
            }
        }
        return string;
    }

    protected void rendererParamsNotNull(FacesContext facesContext, UIComponent uIComponent) {
        Util.notNull("context", facesContext);
        Util.notNull("component", uIComponent);
    }

    protected boolean shouldEncode(UIComponent uIComponent) {
        if (!uIComponent.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "End encoding component {0} since rendered attribute is set to false", uIComponent.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldDecode(UIComponent uIComponent) {
        if (Util.componentIsDisabledOrReadonly(uIComponent)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is disabled or read-only", uIComponent.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldEncodeChildren(UIComponent uIComponent) {
        if (!uIComponent.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Children of component {0} will not be encoded since this component's rendered attribute is false", uIComponent.getId());
            }
            return false;
        }
        return true;
    }

    protected static Map<String, List<ClientBehavior>> getPassThruBehaviors(UIComponent uIComponent, String string, String string2) {
        if (!(uIComponent instanceof ClientBehaviorHolder)) {
            return null;
        }
        Map map = ((ClientBehaviorHolder)uIComponent).getClientBehaviors();
        int n = map.size();
        if (n == 1 || n == 2) {
            boolean bl = map.containsKey(string);
            boolean bl2 = map.containsKey(string2);
            if (n == 1 && (bl || bl2) || n == 2 && bl && bl2) {
                return null;
            }
        }
        return map;
    }

    private static UIComponent findUIComponentBelow(UIComponent uIComponent, String string) {
        UIComponent uIComponent2 = null;
        if (uIComponent.getChildCount() > 0) {
            List list = uIComponent.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                UIComponent uIComponent3 = (UIComponent)list.get(i);
                if (uIComponent3 instanceof NamingContainer) {
                    try {
                        uIComponent2 = uIComponent3.findComponent(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                }
                if (uIComponent2 == null && uIComponent3.getChildCount() > 0) {
                    uIComponent2 = HtmlBasicRenderer.findUIComponentBelow(uIComponent3, string);
                }
                if (uIComponent2 != null) break;
            }
        }
        return uIComponent2;
    }

    public static class OptionComponentInfo {
        String disabledClass;
        String enabledClass;
        String selectedClass;
        String unselectedClass;
        boolean disabled;
        boolean hideNoSelection;

        public OptionComponentInfo(String string, String string2, boolean bl, boolean bl2) {
            this(string, string2, null, null, bl, bl2);
        }

        public OptionComponentInfo(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
            this.disabledClass = string;
            this.enabledClass = string2;
            this.unselectedClass = string3;
            this.selectedClass = string4;
            this.disabled = bl;
            this.hideNoSelection = bl2;
        }

        public String getDisabledClass() {
            return this.disabledClass;
        }

        public String getEnabledClass() {
            return this.enabledClass;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isHideNoSelection() {
            return this.hideNoSelection;
        }

        public String getSelectedClass() {
            return this.selectedClass;
        }

        public String getUnselectedClass() {
            return this.unselectedClass;
        }
    }

    public static class Param {
        public String name;
        public String value;

        public Param(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

