/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceImpl;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceHandlerImpl
extends ResourceHandler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    ResourceManager manager;
    List<Pattern> excludePatterns;
    private long creationTime = System.currentTimeMillis();
    private long maxAge;
    private WebConfiguration webconfig = WebConfiguration.getInstance();

    public ResourceHandlerImpl() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        this.manager = ApplicationAssociate.getInstance(externalContext).getResourceManager();
        this.initExclusions();
        this.initMaxAge();
    }

    public Resource createResource(String string) {
        Util.notNull("resourceName", string);
        return this.createResource(string, null, null);
    }

    public Resource createResource(String string, String string2) {
        Util.notNull("resourceName", string);
        return this.createResource(string, string2, null);
    }

    public Resource createResource(String string, String string2, String string3) {
        Util.notNull("resourceName", string);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean bl = facesContext.isProjectStage(ProjectStage.Development);
        String string4 = string3 != null ? string3 : this.getContentType(facesContext, string);
        ResourceInfo resourceInfo = this.manager.findResource(string2, string, string4, facesContext);
        if (resourceInfo == null) {
            if (!bl && "application/x-groovy".equals(string4)) {
                return null;
            }
            this.logMissingResource(facesContext, string, string2, null);
            return null;
        }
        return new ResourceImpl(resourceInfo, string4, this.creationTime, this.maxAge);
    }

    public boolean libraryExists(String string) {
        if (string.contains("../")) {
            return false;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        LibraryInfo libraryInfo = this.manager.findLibrary(string, null, facesContext);
        if (null == libraryInfo) {
            libraryInfo = this.manager.findLibraryOnClasspathWithZipDirectoryEntryScan(string, null, facesContext, true);
        }
        return libraryInfo != null;
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        Boolean bl = (Boolean)RequestStateManager.get(facesContext, "com.sun.faces.RESOURCE_REQUEST");
        if (bl == null) {
            String string = this.normalizeResourceRequest(facesContext);
            bl = string != null ? string.startsWith("/javax.faces.resource") : Boolean.FALSE.booleanValue();
            RequestStateManager.set(facesContext, "com.sun.faces.RESOURCE_REQUEST", bl);
        }
        return bl;
    }

    public String getRendererTypeForResourceName(String string) {
        String string2 = null;
        String string3 = this.getContentType(FacesContext.getCurrentInstance(), string);
        if (null != string3) {
            if (-1 != (string3 = string3.toLowerCase()).indexOf("javascript")) {
                string2 = "javax.faces.resource.Script";
            } else if (-1 != string3.indexOf("css")) {
                string2 = "javax.faces.resource.Stylesheet";
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        String string = this.normalizeResourceRequest(facesContext);
        if (string == null) {
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (this.isExcluded(string)) {
            externalContext.setResponseStatus(404);
            return;
        }
        assert (null != string);
        assert (string.startsWith("/javax.faces.resource"));
        Resource resource = null;
        String string2 = null;
        String string3 = null;
        if ("/javax.faces.resource".length() < string.length()) {
            boolean bl;
            string2 = string.substring("/javax.faces.resource".length() + 1);
            assert (string2 != null);
            string3 = (String)facesContext.getExternalContext().getRequestParameterMap().get("ln");
            if (string3 != null) {
                bl = this.libraryNameIsSafe(string3);
                if (!bl) {
                    this.send404(facesContext, string2, string3, true);
                    return;
                }
            } else {
                bl = true;
            }
            if (bl) {
                resource = facesContext.getApplication().getResourceHandler().createResource(string2, string3);
            }
        }
        if (resource != null) {
            if (resource.userAgentNeedsUpdate(facesContext)) {
                Channel channel = null;
                Channel channel2 = null;
                ByteBuffer byteBuffer = this.allocateByteBuffer();
                try {
                    InputStream inputStream = resource.getInputStream();
                    if (inputStream == null) {
                        this.send404(facesContext, string2, string3, true);
                        return;
                    }
                    channel = Channels.newChannel(inputStream);
                    channel2 = Channels.newChannel(externalContext.getResponseOutputStream());
                    externalContext.setResponseBufferSize(byteBuffer.capacity());
                    String string4 = resource.getContentType();
                    if (string4 != null) {
                        externalContext.setResponseContentType(resource.getContentType());
                    }
                    this.handleHeaders(facesContext, resource);
                    int n = 0;
                    int n2 = channel.read(byteBuffer);
                    int n3 = 0;
                    while (n2 != -1) {
                        byteBuffer.rewind();
                        byteBuffer.limit(n2);
                        while ((n3 += channel2.write(byteBuffer)) < n) {
                        }
                        byteBuffer.clear();
                        n += n2;
                        n2 = channel.read(byteBuffer);
                    }
                    externalContext.setResponseContentLength(n);
                }
                catch (IOException iOException) {
                    this.send404(facesContext, string2, string3, iOException, true);
                }
                finally {
                    if (channel2 != null) {
                        channel2.close();
                    }
                    if (channel != null) {
                        channel.close();
                    }
                }
            } else {
                this.send304(facesContext);
            }
        } else {
            this.send404(facesContext, string2, string3, false);
        }
    }

    private boolean libraryNameIsSafe(String string) {
        assert (null != string);
        boolean bl = !string.startsWith(".") && !string.startsWith("/") && !string.contains("/") && !string.startsWith("\\") && !string.contains("\\") && !string.startsWith("%2e") && !string.startsWith("%2f") && !string.contains("%2f") && !string.startsWith("%5c") && !string.contains("%5c") && !string.startsWith("\\u002e") && !string.startsWith("\\u002f") && !string.contains("\\u002f") && !string.startsWith("\\u005c") && !string.contains("\\u005c");
        return bl;
    }

    private void send404(FacesContext facesContext, String string, String string2, boolean bl) {
        this.send404(facesContext, string, string2, null, bl);
    }

    private void send404(FacesContext facesContext, String string, String string2, Throwable throwable, boolean bl) {
        facesContext.getExternalContext().setResponseStatus(404);
        if (bl) {
            this.logMissingResource(facesContext, string, string2, throwable);
        }
    }

    private void send304(FacesContext facesContext) {
        facesContext.getExternalContext().setResponseStatus(304);
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void setCreationTime(long l) {
        this.creationTime = l;
    }

    WebConfiguration getWebConfig() {
        return this.webconfig;
    }

    private void logMissingResource(FacesContext facesContext, String string, String string2, Throwable throwable) {
        Level level;
        if (!facesContext.isProjectStage(ProjectStage.Production)) {
            level = Level.WARNING;
        } else {
            Level level2 = level = throwable != null ? Level.WARNING : Level.FINE;
        }
        if (string2 != null) {
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, "jsf.application.resource.unable_to_serve_from_library", new Object[]{string, string2});
                if (throwable != null) {
                    LOGGER.log(level, "", throwable);
                }
            }
        } else if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "jsf.application.resource.unable_to_serve", new Object[]{string});
            if (throwable != null) {
                LOGGER.log(level, "", throwable);
            }
        }
    }

    private String getContentType(FacesContext facesContext, String string) {
        return facesContext.getExternalContext().getMimeType(string);
    }

    private String normalizeResourceRequest(FacesContext facesContext) {
        String string;
        String string2 = Util.getFacesMapping(facesContext);
        if (!Util.isPrefixMapped(string2)) {
            string = facesContext.getExternalContext().getRequestServletPath();
            int n = string.lastIndexOf(".");
            if (0 < n) {
                string = string.substring(0, n);
            }
        } else {
            string = facesContext.getExternalContext().getRequestPathInfo();
        }
        return string;
    }

    private boolean isExcluded(String string) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    private void initExclusions() {
        String string = this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceExcludes);
        String[] stringArray = Util.split(string, " ");
        this.excludePatterns = new ArrayList<Pattern>(stringArray.length);
        for (String string2 : stringArray) {
            this.excludePatterns.add(Pattern.compile(".*\\" + string2));
        }
    }

    private void initMaxAge() {
        this.maxAge = Long.parseLong(this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.DefaultResourceMaxAge));
    }

    private void handleHeaders(FacesContext facesContext, Resource resource) {
        ExternalContext externalContext = facesContext.getExternalContext();
        for (Map.Entry entry : resource.getResponseHeaders().entrySet()) {
            externalContext.setResponseHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private ByteBuffer allocateByteBuffer() {
        int n;
        try {
            n = Integer.parseInt(this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceBufferSize));
        }
        catch (NumberFormatException numberFormatException) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.invalid_resource_buffer_size", new Object[]{this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceBufferSize), WebConfiguration.WebContextInitParameter.ResourceBufferSize.getQualifiedName(), WebConfiguration.WebContextInitParameter.ResourceBufferSize.getDefaultValue()});
            }
            n = Integer.parseInt(WebConfiguration.WebContextInitParameter.ResourceBufferSize.getDefaultValue());
        }
        return ByteBuffer.allocate(n);
    }
}

