/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern LIBRARY_VERSION_PATTERN = Pattern.compile("^(\\d+)(_\\d+)+");
    private static final Pattern RESOURCE_VERSION_PATTERN = Pattern.compile("^((?:\\d+)(?:_\\d+)+)[\\.]?(\\w+)?");
    private static final String COMPRESSED_CONTENT_FILENAME = "compressed-content";
    private static final String[] EL_CONTENT_TYPES = new String[]{"text/css"};

    public abstract String getBaseResourcePath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ResourceInfo resourceInfo, FacesContext facesContext) throws IOException {
        InputStream inputStream = null;
        if (resourceInfo.isCompressable() && this.clientAcceptsCompression(facesContext)) {
            if (!resourceInfo.supportsEL()) {
                try {
                    String string = resourceInfo.getCompressedPath();
                    inputStream = new BufferedInputStream(new FileInputStream(string + File.separatorChar + COMPRESSED_CONTENT_FILENAME));
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                    inputStream = null;
                }
            } else {
                InputStream inputStream2 = null;
                try {
                    inputStream2 = new BufferedInputStream(new ELEvaluatingInputStream(facesContext, resourceInfo, this.getNonCompressedInputStream(resourceInfo, facesContext)));
                    byte[] byArray = new byte[512];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    int n = inputStream2.read(byArray);
                    while (n != -1) {
                        ((OutputStream)gZIPOutputStream).write(byArray, 0, n);
                        n = inputStream2.read(byArray);
                    }
                    ((OutputStream)gZIPOutputStream).flush();
                    ((OutputStream)gZIPOutputStream).close();
                    inputStream = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                }
                finally {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (inputStream == null) {
            if (resourceInfo.supportsEL()) {
                return new BufferedInputStream(new ELEvaluatingInputStream(facesContext, resourceInfo, this.getNonCompressedInputStream(resourceInfo, facesContext)));
            }
            inputStream = this.getNonCompressedInputStream(resourceInfo, facesContext);
        }
        return inputStream;
    }

    public abstract URL getURL(ResourceInfo var1, FacesContext var2);

    public abstract LibraryInfo findLibrary(String var1, String var2, FacesContext var3);

    public abstract ResourceInfo findResource(LibraryInfo var1, String var2, String var3, boolean var4, FacesContext var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(ResourceInfo resourceInfo, FacesContext facesContext) {
        long l;
        URL uRL = this.getURL(resourceInfo, facesContext);
        if (uRL == null) {
            return 0L;
        }
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            l = uRLConnection.getLastModified();
        }
        catch (IOException iOException) {
            l = 0L;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return l >= 0L ? l : 0L;
    }

    protected abstract InputStream getNonCompressedInputStream(ResourceInfo var1, FacesContext var2) throws IOException;

    protected VersionInfo getVersion(Collection<String> collection, boolean bl) {
        ArrayList<VersionInfo> arrayList = new ArrayList<VersionInfo>(collection.size());
        for (String string : collection) {
            VersionInfo versionInfo = this.getVersion(string, bl);
            if (versionInfo == null) continue;
            arrayList.add(versionInfo);
        }
        Object object = null;
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList);
            object = (VersionInfo)arrayList.get(arrayList.size() - 1);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compressContent(ResourceInfo resourceInfo) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            URL uRL = resourceInfo.getHelper().getURL(resourceInfo, FacesContext.getCurrentInstance());
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[512];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = new GZIPOutputStream(byteArrayOutputStream);
            int n = 0;
            int n2 = inputStream.read(byArray);
            while (n2 != -1) {
                outputStream.write(byArray, 0, n2);
                n += n2;
                n2 = inputStream.read(byArray);
            }
            outputStream.flush();
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (byteArrayOutputStream.size() < n) {
                String string = resourceInfo.getCompressedPath() + File.separatorChar + COMPRESSED_CONTENT_FILENAME;
                outputStream = new FileOutputStream(string);
                outputStream.write(byteArrayOutputStream.toByteArray());
                outputStream.flush();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean clientAcceptsCompression(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = externalContext.getResponse();
        if (object instanceof HttpServletResponse) {
            String[] stringArray = (String[])externalContext.getRequestHeaderValuesMap().get("accept-encoding");
            boolean bl = false;
            for (String string : stringArray) {
                if (string.contains("gzip;q=0")) {
                    return false;
                }
                if (string.contains("gzip")) {
                    bl = true;
                    break;
                }
                if (!string.contains("*") || string.contains("*;q=0,") || string.endsWith("*;q=0")) continue;
                bl = true;
            }
            if (bl) {
                ((HttpServletResponse)object).setHeader("Content-Encoding", "gzip");
                return true;
            }
        }
        return false;
    }

    protected ResourceInfo handleCompression(ResourceInfo resourceInfo) {
        try {
            if (!resourceInfo.supportsEL() && !this.compressContent(resourceInfo)) {
                resourceInfo = this.rebuildAsNonCompressed(resourceInfo);
            }
        }
        catch (IOException iOException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            resourceInfo = this.rebuildAsNonCompressed(resourceInfo);
        }
        return resourceInfo;
    }

    protected boolean resourceSupportsEL(String string, FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String string2 = externalContext.getMimeType(string);
        return string2 != null && Arrays.binarySearch(EL_CONTENT_TYPES, string2) >= 0;
    }

    private ResourceInfo rebuildAsNonCompressed(ResourceInfo resourceInfo) {
        LibraryInfo libraryInfo = resourceInfo.getLibraryInfo();
        ResourceInfo resourceInfo2 = libraryInfo != null ? new ResourceInfo(resourceInfo.library, resourceInfo.name, resourceInfo.version, false, resourceInfo.supportsEL, resourceInfo.isDevStage, resourceInfo.cacheTimestamp) : new ResourceInfo(resourceInfo.name, resourceInfo.version, resourceInfo.localePrefix, this, false, resourceInfo.supportsEL, resourceInfo.isDevStage, resourceInfo.cacheTimestamp);
        return resourceInfo2;
    }

    private VersionInfo getVersion(String string, boolean bl) {
        String[] stringArray = Util.split(string, "/");
        String string2 = stringArray[stringArray.length - 1];
        String string3 = null;
        if (bl) {
            Matcher matcher = RESOURCE_VERSION_PATTERN.matcher(string2);
            return matcher.matches() ? new VersionInfo(matcher.group(1), matcher.group(2)) : null;
        }
        return LIBRARY_VERSION_PATTERN.matcher(string2).matches() ? new VersionInfo(string2, string3) : null;
    }

    static {
        Arrays.sort(EL_CONTENT_TYPES);
    }

    private static final class ELEvaluatingInputStream
    extends InputStream {
        private List<Integer> buf = new ArrayList<Integer>(1024);
        private boolean failedExpressionTest = false;
        private boolean writingExpression = false;
        private InputStream inner;
        private ResourceInfo info;
        private FacesContext ctx;
        private boolean expressionEvaluated;
        private int nextRead = -1;

        public ELEvaluatingInputStream(FacesContext facesContext, ResourceInfo resourceInfo, InputStream inputStream) {
            this.inner = inputStream;
            this.info = resourceInfo;
            this.ctx = facesContext;
        }

        public int read() throws IOException {
            int n;
            if (this.failedExpressionTest) {
                n = this.nextRead;
                this.nextRead = -1;
                this.failedExpressionTest = false;
            } else if (this.writingExpression) {
                if (0 < this.buf.size()) {
                    n = this.buf.remove(0);
                } else {
                    this.writingExpression = false;
                    n = this.inner.read();
                }
            } else {
                n = this.inner.read();
                char c = (char)n;
                if (c == '#') {
                    n = this.inner.read();
                    c = (char)n;
                    if (c == '{') {
                        this.readExpressionIntoBufferAndEvaluateIntoBuffer();
                        this.writingExpression = true;
                        n = this.read();
                    } else {
                        n = 35;
                        this.nextRead = c;
                        this.failedExpressionTest = true;
                    }
                }
            }
            return n;
        }

        private void readExpressionIntoBufferAndEvaluateIntoBuffer() throws IOException {
            int n;
            char c;
            do {
                if ((c = (char)(n = this.inner.read())) == '}') {
                    this.evaluateExpressionIntoBuffer();
                    continue;
                }
                this.buf.add(n);
            } while (c != '}' && n != -1);
        }

        private void evaluateExpressionIntoBuffer() {
            String[] stringArray;
            char[] cArray = new char[this.buf.size()];
            int n = this.buf.size();
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)this.buf.get(i).intValue();
            }
            String string = new String(cArray);
            n = string.indexOf(":");
            if (-1 != n) {
                if (!this.isPropertyValid(string)) {
                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_COLON_ERROR", string);
                    throw new ELException(string2);
                }
                stringArray = Util.split(string, ":");
                if (null == stringArray[0] || null == stringArray[1]) {
                    String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_NO_LIBRARY_NAME_ERROR", string);
                    throw new ELException(string3);
                }
                try {
                    int n2 = stringArray[0].indexOf("[") + 2;
                    char c = stringArray[0].charAt(n2 - 1);
                    stringArray[0] = stringArray[0].substring(n2, n);
                    if (stringArray[0].equals("this")) {
                        stringArray[0] = this.info.getLibraryInfo().getName();
                        n2 = stringArray[1].indexOf("]") - 1;
                        stringArray[1] = stringArray[1].substring(0, n2);
                        string = "resource[" + c + stringArray[0] + ":" + stringArray[1] + c + "]";
                    }
                }
                catch (Exception exception) {
                    String string4 = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_ERROR", string);
                    throw new ELException(string4);
                }
            }
            stringArray = this.ctx.getELContext();
            this.expressionEvaluated = true;
            ValueExpression valueExpression = this.ctx.getApplication().getExpressionFactory().createValueExpression((ELContext)stringArray, "#{" + string + "}", String.class);
            Object object = valueExpression.getValue((ELContext)stringArray);
            String string5 = object != null ? object.toString() : "";
            this.buf.clear();
            int n3 = string5.length();
            for (int i = 0; i < n3; ++i) {
                this.buf.add(Integer.valueOf(string5.charAt(i)));
            }
        }

        public void close() throws IOException {
            if (!this.expressionEvaluated) {
                this.info.disableEL();
            }
            this.inner.close();
            super.close();
        }

        private boolean isPropertyValid(String string) {
            int n = string.indexOf(58);
            return string.indexOf(58, n + 1) == -1;
        }
    }
}

