/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManager {
    private boolean isDevelopmentMode = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development);
    private Map<String, Class<?>> classMap = new ConcurrentHashMap(32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext facesContext) {
        Object[] objectArray;
        if (facesContext == null) {
            return null;
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot.isTransient()) {
            return null;
        }
        String string = facesContext.getViewRoot().getViewId();
        StateManagementStrategy stateManagementStrategy = null;
        ViewDeclarationLanguage viewDeclarationLanguage = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, string);
        if (viewDeclarationLanguage != null) {
            stateManagementStrategy = viewDeclarationLanguage.getStateManagementStrategy(facesContext, string);
        }
        Map map = facesContext.getAttributes();
        try {
            map.put("javax.faces.IS_SAVING_STATE", Boolean.TRUE);
            if (null != stateManagementStrategy) {
                objectArray = stateManagementStrategy.saveView(facesContext);
            } else {
                Util.checkIdUniqueness(facesContext, (UIComponent)uIViewRoot, new HashSet<String>(uIViewRoot.getChildCount() << 1));
                ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(32);
                Object object = uIViewRoot.processSaveState(facesContext);
                StateManagerImpl.captureChild(arrayList, 0, (UIComponent)uIViewRoot);
                Object[] objectArray2 = arrayList.toArray();
                objectArray = new Object[]{objectArray2, object};
            }
        }
        finally {
            map.remove("javax.faces.IS_SAVING_STATE");
        }
        return objectArray;
    }

    public void writeState(FacesContext facesContext, Object object) throws IOException {
        RenderKit renderKit = facesContext.getRenderKit();
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        responseStateManager.writeState(facesContext, object);
    }

    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        UIViewRoot uIViewRoot = null;
        StateManagementStrategy stateManagementStrategy = null;
        ViewDeclarationLanguage viewDeclarationLanguage = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, string);
        if (viewDeclarationLanguage != null) {
            stateManagementStrategy = viewDeclarationLanguage.getStateManagementStrategy(facesContext, string);
        }
        if (null != stateManagementStrategy) {
            uIViewRoot = stateManagementStrategy.restoreView(facesContext, string, string2);
        } else {
            ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string2);
            Object[] objectArray = (Object[])responseStateManager.getState(facesContext, string);
            if (objectArray != null && objectArray.length >= 2) {
                UIViewRoot uIViewRoot2 = null;
                if (objectArray[0] != null) {
                    uIViewRoot2 = this.restoreTree(facesContext, string2, (Object[])((Object[])objectArray[0]).clone());
                }
                if (uIViewRoot2 != null && objectArray[1] != null) {
                    uIViewRoot2.processRestoreState(facesContext, objectArray[1]);
                }
                uIViewRoot = uIViewRoot2;
            }
        }
        return uIViewRoot;
    }

    private static void captureChild(List<TreeNode> list, int n, UIComponent uIComponent) {
        if (!uIComponent.isTransient()) {
            TreeNode treeNode = new TreeNode(n, uIComponent);
            int n2 = list.size();
            list.add(treeNode);
            StateManagerImpl.captureRest(list, n2, uIComponent);
        }
    }

    private static void captureFacet(List<TreeNode> list, int n, String string, UIComponent uIComponent) {
        if (!uIComponent.isTransient()) {
            FacetNode facetNode = new FacetNode(n, string, uIComponent);
            int n2 = list.size();
            list.add(facetNode);
            StateManagerImpl.captureRest(list, n2, uIComponent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void captureRest(List<TreeNode> list, int n, UIComponent uIComponent) {
        int n2 = uIComponent.getChildCount();
        if (n2 > 0) {
            void entry;
            List list2 = uIComponent.getChildren();
            boolean i = false;
            while (entry < n2) {
                StateManagerImpl.captureChild(list, n, (UIComponent)list2.get((int)entry));
                ++entry;
            }
        }
        if ((n2 = uIComponent.getFacetCount()) > 0) {
            for (Map.Entry entry : uIComponent.getFacets().entrySet()) {
                StateManagerImpl.captureFacet(list, n, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    private UIComponent newInstance(TreeNode treeNode) throws FacesException {
        try {
            Class clazz;
            Class clazz2 = clazz = this.classMap != null ? this.classMap.get(treeNode.componentType) : null;
            if (clazz == null) {
                clazz = Util.loadClass(treeNode.componentType, treeNode);
                if (clazz != null && this.classMap != null) {
                    this.classMap.put(treeNode.componentType, clazz);
                } else if (!this.isDevelopmentMode) {
                    throw new NullPointerException();
                }
            }
            assert (clazz != null);
            UIComponent uIComponent = (UIComponent)clazz.newInstance();
            uIComponent.setId(treeNode.id);
            return uIComponent;
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private UIViewRoot restoreTree(FacesContext facesContext, String string, Object[] objectArray) throws FacesException {
        for (int i = 0; i < objectArray.length; ++i) {
            UIComponent uIComponent;
            if (objectArray[i] instanceof FacetNode) {
                FacetNode facetNode = (FacetNode)objectArray[i];
                uIComponent = this.newInstance(facetNode);
                objectArray[i] = uIComponent;
                if (i == facetNode.parent) continue;
                ((UIComponent)objectArray[facetNode.parent]).getFacets().put(facetNode.facetName, uIComponent);
                continue;
            }
            TreeNode treeNode = (TreeNode)objectArray[i];
            uIComponent = this.newInstance(treeNode);
            objectArray[i] = uIComponent;
            if (i != treeNode.parent) {
                ((UIComponent)objectArray[treeNode.parent]).getChildren().add(uIComponent);
                continue;
            }
            assert (uIComponent instanceof UIViewRoot);
            UIViewRoot uIViewRoot = (UIViewRoot)uIComponent;
            facesContext.setViewRoot(uIViewRoot);
            uIViewRoot.setRenderKitId(string);
        }
        return (UIViewRoot)objectArray[0];
    }

    private static final class FacetNode
    extends TreeNode {
        public String facetName;
        private static final long serialVersionUID = -3777170310958005106L;

        public FacetNode() {
        }

        public FacetNode(int n, String string, UIComponent uIComponent) {
            super(n, uIComponent);
            this.facetName = string;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.facetName = objectInput.readUTF();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeUTF(this.facetName);
        }
    }

    private static class TreeNode
    implements Externalizable {
        private static final String NULL_ID = "";
        public String componentType;
        public String id;
        public int parent;
        private static final long serialVersionUID = -835775352718473281L;

        public TreeNode() {
        }

        public TreeNode(int n, UIComponent uIComponent) {
            this.parent = n;
            this.id = uIComponent.getId();
            this.componentType = uIComponent.getClass().getName();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.parent);
            objectOutput.writeUTF(this.componentType);
            if (this.id != null) {
                objectOutput.writeUTF(this.id);
            } else {
                objectOutput.writeUTF(NULL_ID);
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.parent = objectInput.readInt();
            this.componentType = objectInput.readUTF();
            this.id = objectInput.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }
    }
}

