/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
extends Resource
implements Externalizable {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private transient ResourceInfo resourceInfo;
    private transient Map<String, String> responseHeaders;
    private long initialTime;
    private long maxAge;

    public ResourceImpl() {
    }

    public ResourceImpl(ResourceInfo resourceInfo, String string, long l, long l2) {
        this.resourceInfo = resourceInfo;
        super.setResourceName(resourceInfo.getName());
        super.setLibraryName(resourceInfo.getLibraryInfo() != null ? resourceInfo.getLibraryInfo().getName() : null);
        super.setContentType(string);
        this.initialTime = l;
        this.maxAge = l2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ResourceImpl resourceImpl = (ResourceImpl)object;
        return this.resourceInfo.equals(resourceImpl.resourceInfo);
    }

    public int hashCode() {
        return this.resourceInfo.hashCode();
    }

    public InputStream getInputStream() throws IOException {
        return this.resourceInfo.getHelper().getInputStream(this.resourceInfo, FacesContext.getCurrentInstance());
    }

    public URL getURL() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return this.resourceInfo.getHelper().getURL(this.resourceInfo, facesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResponseHeaders() {
        if (this.isResourceRequest()) {
            FacesContext facesContext;
            if (this.responseHeaders == null) {
                this.responseHeaders = new HashMap<String, String>(6, 1.0f);
            }
            long l = (facesContext = FacesContext.getCurrentInstance()).isProjectStage(ProjectStage.Development) ? new Date().getTime() : new Date().getTime() + this.maxAge;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
            simpleDateFormat.setTimeZone(GMT);
            this.responseHeaders.put("Expires", simpleDateFormat.format(new Date(l)));
            URL uRL = this.getURL();
            InputStream inputStream = null;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                uRLConnection.connect();
                inputStream = uRLConnection.getInputStream();
                long l2 = uRLConnection.getLastModified();
                long l3 = uRLConnection.getContentLength();
                if (l2 == 0L) {
                    l2 = this.initialTime;
                }
                this.responseHeaders.put("Last-Modified", simpleDateFormat.format(new Date(l2)));
                if (l2 != 0L && l3 != -1L) {
                    this.responseHeaders.put("ETag", "W/\"" + l3 + '-' + l2 + '\"');
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return this.responseHeaders;
        }
        return Collections.emptyMap();
    }

    public String getRequestPath() {
        String string;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String string2 = Util.getFacesMapping(facesContext);
        String string3 = Util.isPrefixMapped(string2) ? string2 + "/javax.faces.resource" + '/' + this.getResourceName() : "/javax.faces.resource/" + this.getResourceName() + string2;
        boolean bl = false;
        if (null != this.getLibraryName()) {
            bl = true;
            string3 = string3 + "?ln=" + this.getLibraryName();
        }
        String string4 = "";
        if (this.resourceInfo.getLibraryInfo() != null && this.resourceInfo.getLibraryInfo().getVersion() != null) {
            string4 = string4 + this.resourceInfo.getLibraryInfo().getVersion().toString();
        }
        if (this.resourceInfo.getVersion() != null) {
            string4 = string4 + this.resourceInfo.getVersion().toString();
        }
        if (string4.length() > 0) {
            string3 = string3 + (bl ? "&v=" : "?v=") + string4;
            bl = true;
        }
        if ((string = this.resourceInfo.getLocalePrefix()) != null) {
            string3 = string3 + (bl ? "&loc=" : "?loc=") + string;
            bl = true;
        }
        if ("jsf.js".equals(this.getResourceName()) && "javax.faces".equals(this.getLibraryName())) {
            ProjectStage projectStage = facesContext.getApplication().getProjectStage();
            switch (projectStage) {
                case Development: {
                    string3 = string3 + (bl ? "&stage=Development" : "?stage=Development");
                    break;
                }
                case SystemTest: {
                    string3 = string3 + (bl ? "&stage=SystemTest" : "?stage=SystemTest");
                    break;
                }
                case UnitTest: {
                    string3 = string3 + (bl ? "&stage=UnitTest" : "?stage=UnitTest");
                    break;
                }
                default: {
                    assert (projectStage.equals((Object)ProjectStage.Production));
                    break;
                }
            }
        }
        string3 = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, string3);
        return string3;
    }

    public boolean userAgentNeedsUpdate(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getRequestHeaderMap();
        if (map.containsKey(IF_MODIFIED_SINCE)) {
            long l;
            long l2 = this.resourceInfo.getLastModified(facesContext);
            return l2 > (l = this.getIfModifiedHeader(facesContext.getExternalContext()));
        }
        return true;
    }

    private long getIfModifiedHeader(ExternalContext externalContext) {
        Object object = externalContext.getRequest();
        if (object instanceof HttpServletRequest) {
            return ((HttpServletRequest)object).getDateHeader(IF_MODIFIED_SINCE);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
        try {
            Date date = simpleDateFormat.parse((String)externalContext.getRequestHeaderMap().get(IF_MODIFIED_SINCE));
            return date.getTime();
        }
        catch (ParseException parseException) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.invalid_if_modified_since_header", new Object[]{externalContext.getRequestHeaderMap().get(IF_MODIFIED_SINCE)});
                if (parseException != null) {
                    LOGGER.log(Level.WARNING, "", parseException);
                }
            }
            return -1L;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getResourceName());
        objectOutput.writeObject(this.getLibraryName());
        objectOutput.writeObject(this.getContentType());
        objectOutput.writeLong(this.initialTime);
        objectOutput.writeLong(this.maxAge);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setResourceName((String)objectInput.readObject());
        this.setLibraryName((String)objectInput.readObject());
        this.setContentType((String)objectInput.readObject());
        this.initialTime = objectInput.readLong();
        this.maxAge = objectInput.readLong();
        ResourceManager resourceManager = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext()).getResourceManager();
        this.resourceInfo = resourceManager.findResource(this.getLibraryName(), this.getResourceName(), this.getContentType(), FacesContext.getCurrentInstance());
    }

    private boolean isResourceRequest() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getResourceHandler().isResourceRequest(facesContext);
    }
}

