/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class WebappResourceHelper
extends ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String BASE_RESOURCE_PATH = "/resources";
    private boolean cacheTimestamp;

    public WebappResourceHelper() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.cacheTimestamp = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
    }

    public String getBaseResourcePath() {
        return BASE_RESOURCE_PATH;
    }

    protected InputStream getNonCompressedInputStream(ResourceInfo resourceInfo, FacesContext facesContext) throws IOException {
        return facesContext.getExternalContext().getResourceAsStream(resourceInfo.getPath());
    }

    public URL getURL(ResourceInfo resourceInfo, FacesContext facesContext) {
        try {
            return facesContext.getExternalContext().getResource(resourceInfo.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public LibraryInfo findLibrary(String string, String string2, FacesContext facesContext) {
        String string3 = string2 == null ? this.getBaseResourcePath() + '/' + string : this.getBaseResourcePath() + '/' + string2 + '/' + string;
        Set set = facesContext.getExternalContext().getResourcePaths(string3);
        if (set != null && !set.isEmpty()) {
            VersionInfo versionInfo = this.getVersion(set, false);
            return new LibraryInfo(string, versionInfo, string2, this);
        }
        return null;
    }

    public ResourceInfo findResource(LibraryInfo libraryInfo, String string, String string2, boolean bl, FacesContext facesContext) {
        ResourceInfo resourceInfo;
        String string3 = libraryInfo != null ? libraryInfo.getPath() + '/' + string : (string2 == null ? this.getBaseResourcePath() + '/' + string : this.getBaseResourcePath() + '/' + string2 + '/' + string);
        try {
            if (facesContext.getExternalContext().getResource(string3) == null) {
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new FacesException((Throwable)malformedURLException);
        }
        Set set = facesContext.getExternalContext().getResourcePaths(string3);
        if (set == null || set.size() == 0) {
            resourceInfo = libraryInfo != null ? new ResourceInfo(libraryInfo, string, null, bl, this.resourceSupportsEL(string, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ResourceInfo(string, null, string2, this, bl, this.resourceSupportsEL(string, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        } else {
            VersionInfo versionInfo = this.getVersion(set, true);
            if (versionInfo == null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_determine_resource_version.", string);
                return null;
            }
            resourceInfo = libraryInfo != null ? new ResourceInfo(libraryInfo, string, versionInfo, bl, this.resourceSupportsEL(string, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ResourceInfo(string, versionInfo, string2, this, bl, this.resourceSupportsEL(string, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        }
        if (resourceInfo.isCompressable()) {
            resourceInfo = this.handleCompression(resourceInfo);
        }
        return resourceInfo;
    }
}

