/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.validator;

import com.sun.faces.ext.validator.MojarraMessageFactory;
import java.io.Serializable;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class CreditCardValidator
implements Validator,
Serializable {
    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) {
        Locale locale = facesContext.getViewRoot().getLocale();
        if (object == null) {
            return;
        }
        if (!(object instanceof String)) {
            FacesMessage facesMessage = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.creditcardValidator.NOT_STRING", new Object[]{null});
            throw new ValidatorException(facesMessage);
        }
        String string = (String)object;
        if (!string.matches("^[0-9\\ \\-]*$")) {
            FacesMessage facesMessage = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.creditcardValidator.INVALID_CHARS", new Object[]{null});
            throw new ValidatorException(facesMessage);
        }
        if (!this.luhnCheck(this.stripNonDigit(string))) {
            FacesMessage facesMessage = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.creditcardValidator.INVALID_NUMBER", new Object[]{null});
            throw new ValidatorException(facesMessage);
        }
    }

    private String stripNonDigit(String string) {
        return string.replaceAll(" ", "").replaceAll("-", "");
    }

    private boolean luhnCheck(String string) {
        int n = 0;
        boolean bl = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            int n2 = Integer.parseInt(string.substring(i, i + 1));
            if (bl && (n2 *= 2) > 9) {
                n2 = n2 % 10 + 1;
            }
            n += n2;
            bl = !bl;
        }
        return n % 10 == 0;
    }
}

