/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import com.sun.faces.util.Util;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.el.Expression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DevTools {
    private static final String TS = "&lt;";
    private static final String ERROR_TEMPLATE = "META-INF/facelet-dev-error.xml";
    private static String[] ERROR_PARTS;
    private static final String DEBUG_TEMPLATE = "META-INF/facelet-dev-debug.xml";
    private static String[] DEBUG_PARTS;
    private static final String[] IGNORE;

    private DevTools() {
        throw new IllegalStateException();
    }

    public static void debugHtml(Writer writer, FacesContext facesContext, Throwable throwable) throws IOException {
        DevTools.init();
        Date date = new Date();
        for (String string : ERROR_PARTS) {
            if ("message".equals(string)) {
                DevTools.writeMessage(writer, throwable);
                continue;
            }
            if ("trace".equals(string)) {
                DevTools.writeException(writer, throwable);
                continue;
            }
            if ("now".equals(string)) {
                writer.write(DateFormat.getDateTimeInstance().format(date));
                continue;
            }
            if ("tree".equals(string)) {
                DevTools.writeComponent(writer, (UIComponent)facesContext.getViewRoot());
                continue;
            }
            if ("vars".equals(string)) {
                DevTools.writeVariables(writer, facesContext);
                continue;
            }
            writer.write(string);
        }
    }

    public static void writeMessage(Writer writer, Throwable throwable) throws IOException {
        if (throwable != null) {
            String string = throwable.getMessage();
            if (string != null) {
                writer.write(string.replaceAll("<", TS));
            } else {
                writer.write(throwable.getClass().getName());
            }
        }
    }

    public static void writeException(Writer writer, Throwable throwable) throws IOException {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter(256);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            writer.write(stringWriter.toString().replaceAll("<", TS));
        }
    }

    public static void debugHtml(Writer writer, FacesContext facesContext) throws IOException {
        DevTools.init();
        Date date = new Date();
        for (String string : DEBUG_PARTS) {
            if ("message".equals(string)) {
                writer.write(facesContext.getViewRoot().getViewId());
                continue;
            }
            if ("now".equals(string)) {
                writer.write(DateFormat.getDateTimeInstance().format(date));
                continue;
            }
            if ("tree".equals(string)) {
                DevTools.writeComponent(writer, (UIComponent)facesContext.getViewRoot());
                continue;
            }
            if ("vars".equals(string)) {
                DevTools.writeVariables(writer, facesContext);
                continue;
            }
            writer.write(string);
        }
    }

    public static void writeVariables(Writer writer, FacesContext facesContext) throws IOException {
        Map map;
        ExternalContext externalContext = facesContext.getExternalContext();
        DevTools.writeVariables(writer, externalContext.getRequestParameterMap(), "Request Parameters");
        if (facesContext.getViewRoot() != null) {
            map = facesContext.getViewRoot().getViewMap(false);
            if (map != null) {
                DevTools.writeVariables(writer, map, "View Attributes");
            } else {
                DevTools.writeVariables(writer, Collections.emptyMap(), "View Attributes");
            }
        } else {
            DevTools.writeVariables(writer, Collections.emptyMap(), "View Attributes");
        }
        DevTools.writeVariables(writer, externalContext.getRequestMap(), "Request Attributes");
        map = externalContext.getFlash();
        try {
            map = externalContext.getFlash();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (map != null) {
            DevTools.writeVariables(writer, map, "Flash Attributes");
        } else {
            DevTools.writeVariables(writer, Collections.emptyMap(), "Flash Attributes");
        }
        if (externalContext.getSession(false) != null) {
            DevTools.writeVariables(writer, externalContext.getSessionMap(), "Session Attributes");
        } else {
            DevTools.writeVariables(writer, Collections.emptyMap(), "Session Attributes");
        }
        DevTools.writeVariables(writer, externalContext.getApplicationMap(), "Application Attributes");
    }

    public static void writeComponent(Writer writer, UIComponent uIComponent) throws IOException {
        writer.write("<dl style=\"color: #006;\"><dt style=\"border: 1px solid #DDD; padding: 4px; border-left: 2px solid #666; font-family: 'Courier New', Courier, mono; font-size: small;");
        if (uIComponent != null && DevTools.isText(uIComponent)) {
            writer.write("color: #999;");
        }
        writer.write("\">");
        if (uIComponent == null) {
            return;
        }
        boolean bl = uIComponent.getChildCount() > 0 || uIComponent.getFacets().size() > 0;
        DevTools.writeStart(writer, uIComponent, bl);
        writer.write("</dt>");
        if (bl) {
            if (uIComponent.getFacets().size() > 0) {
                for (Map.Entry uIComponent2 : uIComponent.getFacets().entrySet()) {
                    writer.write("<dd style=\"margin-top: 2px; margin-bottom: 2px;\">");
                    writer.write("<span style=\"font-family: 'Trebuchet MS', Verdana, Arial, Sans-Serif; font-size: small;\">");
                    writer.write((String)uIComponent2.getKey());
                    writer.write("</span>");
                    DevTools.writeComponent(writer, (UIComponent)uIComponent2.getValue());
                    writer.write("</dd>");
                }
            }
            if (uIComponent.getChildCount() > 0) {
                for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                    writer.write("<dd style=\"margin-top: 2px; margin-bottom: 2px;\">");
                    DevTools.writeComponent(writer, uIComponent2);
                    writer.write("</dd>");
                }
            }
            writer.write("<dt style=\"border: 1px solid #DDD; padding: 4px; border-left: 2px solid #666; font-family: 'Courier New', Courier, mono; font-size: small;\">");
            DevTools.writeEnd(writer, uIComponent);
            writer.write("</dt>");
        }
        writer.write("</dl>");
    }

    private static void init() throws IOException {
        if (ERROR_PARTS == null) {
            ERROR_PARTS = DevTools.splitTemplate(ERROR_TEMPLATE);
        }
        if (DEBUG_PARTS == null) {
            DEBUG_PARTS = DevTools.splitTemplate(DEBUG_TEMPLATE);
        }
    }

    private static String[] splitTemplate(String string) throws IOException {
        int n;
        ClassLoader classLoader = Util.getCurrentLoader(DevTools.class);
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null && (inputStream = (classLoader = DevTools.class.getClassLoader()).getResourceAsStream(string)) == null) {
            throw new FileNotFoundException(string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        String string2 = byteArrayOutputStream.toString();
        return string2.split("@@");
    }

    private static void writeVariables(Writer writer, Map<String, ?> map, String string) throws IOException {
        writer.write("<table style=\"border: 1px solid #CCC; border-collapse: collapse; border-spacing: 0px; width: 100%; text-align: left;\"><caption style=\"text-align: left; padding: 10px 0; font-size: large;\">");
        writer.write(string);
        writer.write("</caption><thead stype=\"padding: 2px; color: #030; background-color: #F9F9F9;\"><tr style=\"padding: 2px; color: #030; background-color: #F9F9F9;\"><th style=\"padding: 2px; color: #030; background-color: #F9F9F9;width: 10%; \">Name</th><th style=\"padding: 2px; color: #030; background-color: #F9F9F9;width: 90%; \">Value</th></tr></thead><tbody style=\"padding: 10px 6px;\">");
        boolean bl = false;
        if (!map.isEmpty()) {
            TreeMap treeMap = new TreeMap(map);
            for (Map.Entry entry : treeMap.entrySet()) {
                String string2 = (String)entry.getKey();
                if (string2.indexOf(46) != -1) continue;
                writer.write("<tr style=\"padding: 10px 6px;\"><td style=\"padding: 10px 6px;\">");
                writer.write(string2.replaceAll("<", TS));
                writer.write("</td><td>");
                writer.write(entry.getValue() == null ? "null" : entry.getValue().toString().replaceAll("<", TS));
                writer.write("</td></tr>");
                bl = true;
            }
        }
        if (!bl) {
            writer.write("<tr style=\"padding: 10px 6px;\"><td colspan=\"2\" style=\"padding: 10px 6px;\"><em>None</em></td></tr>");
        }
        writer.write("</tbody></table>");
    }

    private static void writeEnd(Writer writer, UIComponent uIComponent) throws IOException {
        if (!DevTools.isText(uIComponent)) {
            writer.write(TS);
            writer.write(47);
            writer.write(DevTools.getName(uIComponent));
            writer.write(62);
        }
    }

    private static void writeAttributes(Writer writer, UIComponent uIComponent) {
        try {
            ValueBinding valueBinding;
            BeanInfo beanInfo = Introspector.getBeanInfo(uIComponent.getClass());
            for (PropertyDescriptor propertyDescriptor : valueBinding = beanInfo.getPropertyDescriptors()) {
                if (propertyDescriptor.getWriteMethod() == null || Arrays.binarySearch(IGNORE, propertyDescriptor.getName()) >= 0) continue;
                Method method = propertyDescriptor.getReadMethod();
                try {
                    Object object = method.invoke((Object)uIComponent, new Object[0]);
                    if (object == null || object instanceof Collection || object instanceof Map || object instanceof Iterator) continue;
                    writer.write(" ");
                    writer.write(propertyDescriptor.getName());
                    writer.write("=\"");
                    String string = object instanceof Expression ? ((Expression)object).getExpressionString() : (object instanceof ValueBinding ? ((ValueBinding)object).getExpressionString() : (object instanceof MethodBinding ? ((MethodBinding)object).getExpressionString() : object.toString()));
                    writer.write(string.replaceAll("<", TS));
                    writer.write("\"");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ValueBinding valueBinding2 = uIComponent.getValueBinding("binding");
            if (valueBinding2 != null) {
                writer.write(" binding=\"");
                writer.write(valueBinding2.getExpressionString().replaceAll("<", TS));
                writer.write("\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeStart(Writer writer, UIComponent uIComponent, boolean bl) throws IOException {
        if (DevTools.isText(uIComponent)) {
            String string = uIComponent.toString().trim();
            writer.write(string.replaceAll("<", TS));
        } else {
            writer.write(TS);
            writer.write(DevTools.getName(uIComponent));
            DevTools.writeAttributes(writer, uIComponent);
            if (bl) {
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private static String getName(UIComponent uIComponent) {
        String string = uIComponent.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private static boolean isText(UIComponent uIComponent) {
        return uIComponent.getClass().getName().startsWith("com.sun.faces.facelets.compiler");
    }

    static {
        IGNORE = new String[]{"parent", "rendererType"};
    }
}

