/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mgbean;

import com.sun.faces.RIConstants;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.ManagedBeanCreationException;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.mgbean.ManagedBeanPreProcessingException;
import com.sun.faces.mgbean.SharedUtils;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanBuilder {
    private static Logger LOGGER = FacesLogger.MANAGEDBEAN.getLogger();
    private List<String> messages;
    private List<String> references;
    private boolean isInjectible;
    private boolean baked;
    private Class<?> beanClass;
    protected final ManagedBeanInfo beanInfo;

    public BeanBuilder(ManagedBeanInfo managedBeanInfo) {
        this.beanInfo = managedBeanInfo;
    }

    public Object build(InjectionProvider injectionProvider, FacesContext facesContext) {
        Object object = this.newBeanInstance();
        this.injectResources(object, injectionProvider);
        this.buildBean(object, facesContext);
        this.invokePostConstruct(object, injectionProvider);
        return object;
    }

    public void destroy(InjectionProvider injectionProvider, Object object) {
        block3: {
            if (this.isInjectible) {
                try {
                    injectionProvider.invokePreDestroy(object);
                }
                catch (InjectionProviderException injectionProviderException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, injectionProviderException.getMessage(), injectionProviderException);
                }
            }
        }
    }

    public boolean hasMessages() {
        return this.messages != null && !this.messages.isEmpty();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getScope() {
        return this.beanInfo.getScope();
    }

    public boolean isBaked() {
        return this.baked;
    }

    public Map<String, String> getDescriptions() {
        return this.beanInfo.getDescriptions();
    }

    public Class<?> getBeanClass() {
        return this.loadBeanClass();
    }

    public ManagedBeanInfo getManagedBeanInfo() {
        return this.beanInfo;
    }

    protected abstract void buildBean(Object var1, FacesContext var2);

    protected void baked() {
        this.baked = true;
    }

    protected Object newBeanInstance() {
        try {
            return this.loadBeanClass().newInstance();
        }
        catch (Exception exception) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", this.beanInfo.getClassName());
            throw new ManagedBeanCreationException(string, exception);
        }
    }

    protected void injectResources(Object object, InjectionProvider injectionProvider) {
        if (this.isInjectible) {
            try {
                injectionProvider.inject(object);
            }
            catch (InjectionProviderException injectionProviderException) {
                String string = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_INJECTION_ERROR", this.beanInfo.getName());
                throw new ManagedBeanCreationException(string, injectionProviderException);
            }
        }
    }

    protected void invokePostConstruct(Object object, InjectionProvider injectionProvider) {
        if (this.isInjectible) {
            try {
                injectionProvider.invokePostConstruct(object);
            }
            catch (InjectionProviderException injectionProviderException) {
                String string = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_INJECTION_ERROR", this.beanInfo.getName());
                throw new ManagedBeanCreationException(string, injectionProviderException);
            }
        }
    }

    protected Class loadClass(String string) {
        Class clazz = String.class;
        if (null != string && 0 < string.length()) {
            if (string.equals(Boolean.TYPE.getName())) {
                clazz = Boolean.TYPE;
            } else if (string.equals(Byte.TYPE.getName())) {
                clazz = Byte.TYPE;
            } else if (string.equals(Double.TYPE.getName())) {
                clazz = Double.TYPE;
            } else if (string.equals(Float.TYPE.getName())) {
                clazz = Float.TYPE;
            } else if (string.equals(Integer.TYPE.getName())) {
                clazz = Integer.TYPE;
            } else if (string.equals(Character.TYPE.getName())) {
                clazz = Character.TYPE;
            } else if (string.equals(Short.TYPE.getName())) {
                clazz = Short.TYPE;
            } else if (string.equals(Long.TYPE.getName())) {
                clazz = Long.TYPE;
            } else {
                try {
                    clazz = Util.loadClass(string, this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_NOT_FOUND_ERROR", string, this.beanInfo.getName());
                    throw new ManagedBeanPreProcessingException(string2);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_DEPENDENCY_NOT_FOUND_ERROR", string, this.beanInfo.getName(), noClassDefFoundError.getMessage());
                    throw new ManagedBeanPreProcessingException(string3);
                }
            }
        }
        return clazz;
    }

    protected Map<Expression, Expression> getBakedMap(String string, String string2, Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return new LinkedHashMap<Expression, Expression>(4, 1.0f);
        }
        Class clazz = this.loadClass(string);
        Class clazz2 = this.loadClass(string2);
        LinkedHashMap<Expression, Expression> linkedHashMap = new LinkedHashMap<Expression, Expression>(map.size(), 1.0f);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string3 = entry.getKey();
            String string4 = entry.getValue();
            linkedHashMap.put(new Expression(string3, clazz), !string4.equals("null_value") ? new Expression(string4, clazz2) : null);
        }
        return linkedHashMap;
    }

    protected List<Expression> getBakedList(String string, List<String> list) {
        Class clazz = this.loadClass(string);
        ArrayList<Expression> arrayList = new ArrayList<Expression>(list.size());
        for (String string2 : list) {
            arrayList.add(!"null_value".equals(string2) ? new Expression(string2, clazz) : null);
        }
        return arrayList;
    }

    protected void initMap(Map<Expression, Expression> map, Map map2, FacesContext facesContext) {
        for (Map.Entry<Expression, Expression> entry : map.entrySet()) {
            Expression expression = entry.getKey();
            Expression expression2 = entry.getValue();
            map2.put(expression.evaluate(facesContext.getELContext()), expression2 != null ? expression2.evaluate(facesContext.getELContext()) : null);
        }
    }

    protected void initList(List<Expression> list, List list2, FacesContext facesContext) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Expression expression = list.get(i);
            list2.add(expression != null ? expression.evaluate(facesContext.getELContext()) : null);
        }
    }

    void queueMessage(String string) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>(4);
        }
        this.messages.add(string);
    }

    void queueMessages(List<String> list) {
        if (this.messages == null) {
            this.messages = list;
        } else {
            this.messages.addAll(list);
        }
    }

    void bake() {
        this.loadBeanClass();
        this.validateScope();
    }

    List<String> getReferences() {
        return this.references;
    }

    private Class<?> loadBeanClass() {
        if (this.beanClass == null) {
            Object object;
            int n;
            String string = this.beanInfo.getClassName();
            Class clazz = this.loadClass(string);
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
            if (!applicationAssociate.isDevModeEnabled()) {
                this.beanClass = clazz;
            }
            if (!Modifier.isPublic(n = clazz.getModifiers())) {
                object = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_IS_NOT_PUBLIC_ERROR", string, this.beanInfo.getName());
                this.queueMessage((String)object);
            }
            if (Modifier.isInterface(n) || Modifier.isAbstract(n)) {
                object = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_IS_ABSTRACT_ERROR", string, this.beanInfo.getName());
                this.queueMessage((String)object);
            }
            try {
                object = clazz.getConstructor(RIConstants.EMPTY_CLASS_ARGS);
                if (!Modifier.isPublic(((Constructor)object).getModifiers())) {
                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_NO_PUBLIC_NOARG_CTOR_ERROR", string, this.beanInfo.getName());
                    this.queueMessage(string2);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_NO_PUBLIC_NOARG_CTOR_ERROR", string, this.beanInfo.getName());
                this.queueMessage(string3);
            }
            if (!this.hasMessages()) {
                this.isInjectible = this.scanForAnnotations(clazz);
            }
            return clazz;
        }
        return this.beanClass;
    }

    private void validateScope() {
        String string = this.beanInfo.getScope();
        if (!ELUtils.isScopeValid(string) && !SharedUtils.isExpression(string)) {
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_INVALID_SCOPE", this.beanInfo.getName());
            throw new ManagedBeanPreProcessingException(string2);
        }
    }

    private boolean scanForAnnotations(Class<?> clazz) {
        if (clazz != null) {
            while (clazz != Object.class) {
                int n;
                AccessibleObject[] accessibleObjectArray;
                Field[] fieldArray = clazz.getDeclaredFields();
                if (fieldArray != null) {
                    accessibleObjectArray = fieldArray;
                    int n2 = accessibleObjectArray.length;
                    for (n = 0; n < n2; ++n) {
                        AccessibleObject accessibleObject = accessibleObjectArray[n];
                        if (accessibleObject.getAnnotations().length <= 0) continue;
                        return true;
                    }
                }
                if ((accessibleObjectArray = clazz.getDeclaredMethods()) != null) {
                    AccessibleObject[] accessibleObjectArray2 = accessibleObjectArray;
                    n = accessibleObjectArray2.length;
                    for (int i = 0; i < n; ++i) {
                        AccessibleObject accessibleObject = accessibleObjectArray2[i];
                        if (((Method)accessibleObject).getDeclaredAnnotations().length <= 0) continue;
                        return true;
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Expression {
        private String expressionString;
        private Class<?> expectedType;
        private ValueExpression ve;
        private boolean validateLifespanRuntime = false;
        private String[] segment = new String[1];

        public Expression(String string, Class<?> clazz) {
            this.expressionString = string;
            this.expectedType = clazz;
            if (SharedUtils.isExpression(this.expressionString)) {
                List<String> list = ELUtils.getExpressionsFromString(this.expressionString);
                if (!list.isEmpty()) {
                    for (String string2 : list) {
                        ELUtils.getScope(string2, this.segment);
                        if (this.segment[0] != null) {
                            if (BeanBuilder.this.references == null) {
                                BeanBuilder.this.references = new ArrayList(4);
                            }
                            if (!BeanBuilder.this.references.contains(this.segment[0])) {
                                BeanBuilder.this.references.add(this.segment[0]);
                            }
                        }
                        this.segment[0] = null;
                    }
                }
                if (!SharedUtils.isExpression(BeanBuilder.this.beanInfo.getScope())) {
                    Object object = ELUtils.getNarrowestScopeFromExpression(this.expressionString);
                    if (object != null) {
                        this.validateLifespan((ELUtils.Scope)((Object)object), this.validateLifespanRuntime);
                    } else {
                        this.validateLifespanRuntime = true;
                    }
                }
            } else if (this.expressionString != null) {
                this.expressionString = "#{\"" + this.expressionString.replaceAll("[\\\\\"]", "\\\\$0") + "\"}";
            }
        }

        public Object evaluate(ELContext eLContext) {
            Object object;
            if (this.expressionString == null) {
                return null;
            }
            if (this.validateLifespanRuntime) {
                object = ELUtils.getScope(this.expressionString, this.segment);
                this.validateLifespan((ELUtils.Scope)((Object)object), true);
            }
            if (this.ve == null) {
                ValueExpression valueExpression = this.ve = this.expectedType.isPrimitive() ? ELUtils.createValueExpression(this.expressionString, this.expectedType) : ELUtils.createValueExpression(this.expressionString, Object.class);
            }
            if (this.expectedType.isPrimitive()) {
                return this.ve.getValue(eLContext);
            }
            object = this.ve.getValue(eLContext);
            return object != null ? ELUtils.coerce(object, this.expectedType) : null;
        }

        private void validateLifespan(ELUtils.Scope scope, boolean bl) {
            if (ELUtils.isScopeValid(BeanBuilder.this.beanInfo.getScope()) && !ELUtils.hasValidLifespan(scope, ELUtils.getScope(BeanBuilder.this.beanInfo.getScope()))) {
                String string = MessageUtils.getExceptionMessageString("com.sun.faces.INVALID_SCOPE_LIFESPAN", new Object[]{this.expressionString, scope, BeanBuilder.this.beanInfo.getName(), BeanBuilder.this.beanInfo.getScope()});
                if (bl) {
                    throw new ManagedBeanCreationException(string);
                }
                BeanBuilder.this.queueMessage(string);
            }
        }
    }
}

