/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mgbean;

import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.ErrorBean;
import com.sun.faces.mgbean.ManagedBeanBuilder;
import com.sun.faces.mgbean.ManagedBeanCreationException;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.mgbean.ManagedBeanPreProcessingException;
import com.sun.faces.mgbean.ManagedListBeanBuilder;
import com.sun.faces.mgbean.ManagedMapBeanBuilder;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManager
implements SystemEventListener {
    private static final Logger LOGGER = FacesLogger.MANAGEDBEAN.getLogger();
    private Map<String, BeanBuilder> managedBeans = new HashMap<String, BeanBuilder>();
    private InjectionProvider injectionProvider;
    private boolean configPreprocessed;
    private boolean lazyBeanValidation;
    private List<String> eagerBeans = new ArrayList<String>(4);

    public BeanManager(InjectionProvider injectionProvider, boolean bl) {
        this.injectionProvider = injectionProvider;
        this.lazyBeanValidation = bl;
    }

    public BeanManager(InjectionProvider injectionProvider, Map<String, BeanBuilder> map, boolean bl) {
        this(injectionProvider, bl);
        this.managedBeans = map;
    }

    public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
        ScopeContext scopeContext = ((PreDestroyCustomScopeEvent)systemEvent).getContext();
        Map map = scopeContext.getScope();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (!this.isManaged(string)) continue;
            BeanBuilder beanBuilder = this.getBuilder(string);
            beanBuilder.destroy(this.injectionProvider, entry.getValue());
        }
    }

    public boolean isListenerForSource(Object object) {
        return object instanceof ScopeContext;
    }

    public void register(ManagedBeanInfo managedBeanInfo) {
        BeanBuilder beanBuilder;
        if (managedBeanInfo.hasListEntry()) {
            if (managedBeanInfo.hasMapEntry() || managedBeanInfo.hasManagedProperties()) {
                String string = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_LIST_CONFIG_ERROR", managedBeanInfo.getName());
                beanBuilder = new ErrorBean(managedBeanInfo, string);
            } else {
                beanBuilder = new ManagedListBeanBuilder(managedBeanInfo);
            }
        } else if (managedBeanInfo.hasMapEntry()) {
            if (managedBeanInfo.hasManagedProperties()) {
                String string = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_MAP_CONFIG_ERROR", managedBeanInfo.getName());
                beanBuilder = new ErrorBean(managedBeanInfo, string);
            } else {
                beanBuilder = new ManagedMapBeanBuilder(managedBeanInfo);
            }
        } else {
            beanBuilder = new ManagedBeanBuilder(managedBeanInfo);
        }
        this.addBean(managedBeanInfo.getName(), beanBuilder);
        if (managedBeanInfo.isEager()) {
            this.eagerBeans.add(managedBeanInfo.getName());
        }
    }

    public List<String> getEagerBeanNames() {
        return this.eagerBeans;
    }

    public Map<String, BeanBuilder> getRegisteredBeans() {
        return this.managedBeans;
    }

    public boolean isManaged(String string) {
        return this.managedBeans != null && this.managedBeans.containsKey(string);
    }

    public BeanBuilder getBuilder(String string) {
        if (this.managedBeans != null) {
            return this.managedBeans.get(string);
        }
        return null;
    }

    public void preProcessesBeans() {
        if (!this.configPreprocessed && !this.lazyBeanValidation) {
            this.configPreprocessed = true;
            for (Map.Entry<String, BeanBuilder> entry : this.managedBeans.entrySet()) {
                this.preProcessBean(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isBeanInScope(String string, BeanBuilder beanBuilder, FacesContext facesContext) {
        return ScopeManager.isInScope(string, beanBuilder.getScope(), facesContext);
    }

    public Object getBeanFromScope(String string, BeanBuilder beanBuilder, FacesContext facesContext) {
        return ScopeManager.getFromScope(string, beanBuilder.getScope(), facesContext);
    }

    public Object getBeanFromScope(String string, FacesContext facesContext) {
        String string2 = this.getBuilder(string).getScope();
        return ScopeManager.getFromScope(string, string2, facesContext);
    }

    public Object create(String string, FacesContext facesContext) {
        return this.create(string, this.managedBeans.get(string), facesContext);
    }

    public Object create(String string, BeanBuilder beanBuilder, FacesContext facesContext) {
        if (beanBuilder != null) {
            if (this.lazyBeanValidation && !beanBuilder.isBaked()) {
                this.preProcessBean(string, beanBuilder);
            }
            if (beanBuilder.hasMessages()) {
                throw new ManagedBeanCreationException(this.buildMessage(string, beanBuilder.getMessages(), true));
            }
            return this.createAndPush(string, beanBuilder, facesContext);
        }
        return null;
    }

    public void destroy(String string, Object object) {
        BeanBuilder beanBuilder = this.managedBeans.get(string);
        if (beanBuilder != null) {
            beanBuilder.destroy(this.injectionProvider, object);
        }
    }

    private void addBean(String string, BeanBuilder beanBuilder) {
        if (this.configPreprocessed) {
            this.preProcessBean(string, beanBuilder);
        }
        if (LOGGER.isLoggable(Level.WARNING) && this.managedBeans.containsKey(string)) {
            LOGGER.log(Level.WARNING, "jsf.managed.bean.duplicate", new Object[]{string, this.managedBeans.get((Object)string).beanInfo.getClassName(), beanBuilder.beanInfo.getClassName()});
        }
        this.managedBeans.put(string, beanBuilder);
    }

    private void validateReferences(BeanBuilder beanBuilder, List<String> list, List<String> list2) {
        List<String> list3 = beanBuilder.getReferences();
        if (list3 != null) {
            for (String string : list3) {
                Object object;
                if (!this.isManaged(string)) continue;
                if (list.contains(string)) {
                    String[] stringArray;
                    object = new StringBuilder(64);
                    for (String string2 : stringArray = list.toArray(new String[list.size()])) {
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append(" -> ");
                    }
                    ((StringBuilder)object).append(string);
                    String object2 = MessageUtils.getExceptionMessageString("com.sun.faces.CYCLIC_REFERENCE_ERROR", stringArray[0], ((StringBuilder)object).toString());
                    list2.add(object2);
                    continue;
                }
                object = this.getBuilder(string);
                if (((BeanBuilder)object).getReferences() == null) continue;
                list.add(string);
                this.validateReferences((BeanBuilder)object, list, list2);
                list.remove(string);
            }
        }
    }

    private synchronized void preProcessBean(String string, BeanBuilder beanBuilder) {
        if (!beanBuilder.isBaked()) {
            try {
                beanBuilder.bake();
                List<String> list = beanBuilder.getReferences();
                if (list != null) {
                    for (String object2 : list) {
                        if (!this.isManaged(object2)) continue;
                        BeanBuilder beanBuilder2 = this.getBuilder(object2);
                        this.preProcessBean(object2, beanBuilder2);
                    }
                }
                ArrayList arrayList = new ArrayList();
                arrayList.add(string);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                this.validateReferences(beanBuilder, arrayList, arrayList2);
                if (!arrayList2.isEmpty()) {
                    beanBuilder.queueMessages(arrayList2);
                }
                if (beanBuilder.hasMessages() && LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, this.buildMessage(string, beanBuilder.getMessages(), false));
                }
            }
            catch (ManagedBeanPreProcessingException managedBeanPreProcessingException) {
                if (ManagedBeanPreProcessingException.Type.CHECKED.equals((Object)managedBeanPreProcessingException.getType())) {
                    beanBuilder.queueMessage(managedBeanPreProcessingException.getMessage());
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, this.buildMessage(string, beanBuilder.getMessages(), false));
                    }
                }
                String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNKNOWN_PROCESSING_ERROR", string);
                throw new ManagedBeanPreProcessingException(string2, (Throwable)((Object)managedBeanPreProcessingException));
            }
        }
    }

    private Object createAndPush(String string, BeanBuilder beanBuilder, FacesContext facesContext) {
        Object object = beanBuilder.build(this.injectionProvider, facesContext);
        ScopeManager.pushToScope(string, object, beanBuilder.getScope(), facesContext);
        return object;
    }

    private String buildMessage(String string, List<String> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (bl) {
            stringBuilder.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_ERROR", string));
        } else {
            stringBuilder.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_STARTUP_ERROR", string));
        }
        for (String string2 : list) {
            stringBuilder.append("\n     - ").append(string2);
        }
        return stringBuilder.toString();
    }

    private static class ScopeManager {
        private static final ConcurrentMap<String, ScopeHandler> handlerMap = new ConcurrentHashMap<String, ScopeHandler>(5);

        private ScopeManager() {
        }

        static void pushToScope(String string, Object object, String string2, FacesContext facesContext) {
            ScopeHandler scopeHandler = ScopeManager.getScopeHandler(string2, facesContext);
            scopeHandler.handle(string, object, facesContext);
        }

        static boolean isInScope(String string, String string2, FacesContext facesContext) {
            ScopeHandler scopeHandler = ScopeManager.getScopeHandler(string2, facesContext);
            return scopeHandler.isInScope(string, facesContext);
        }

        static Object getFromScope(String string, String string2, FacesContext facesContext) {
            ScopeHandler scopeHandler = ScopeManager.getScopeHandler(string2, facesContext);
            return scopeHandler.getFromScope(string, facesContext);
        }

        private static ScopeHandler getScopeHandler(String string, FacesContext facesContext) {
            ScopeHandler scopeHandler = (ScopeHandler)handlerMap.get(string);
            if (scopeHandler == null) {
                ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
                ValueExpression valueExpression = expressionFactory.createValueExpression(facesContext.getELContext(), string, Map.class);
                scopeHandler = new CustomScopeHandler(valueExpression);
                handlerMap.putIfAbsent(string, scopeHandler);
            }
            return scopeHandler;
        }

        static {
            handlerMap.put(ELUtils.Scope.REQUEST.toString(), new RequestScopeHandler());
            handlerMap.put(ELUtils.Scope.VIEW.toString(), new ViewScopeHandler());
            handlerMap.put(ELUtils.Scope.SESSION.toString(), new SessionScopeHandler());
            handlerMap.put(ELUtils.Scope.APPLICATION.toString(), new ApplicationScopeHandler());
            handlerMap.put(ELUtils.Scope.NONE.toString(), new NoneScopeHandler());
        }

        private static class CustomScopeHandler
        implements ScopeHandler {
            private ValueExpression scope;

            CustomScopeHandler(ValueExpression valueExpression) {
                this.scope = valueExpression;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String string, Object object, FacesContext facesContext) {
                Map map = (Map)this.scope.getValue(this.getELContext(facesContext));
                if (map != null) {
                    CustomScopeHandler customScopeHandler = this;
                    synchronized (customScopeHandler) {
                        map.put(string, object);
                    }
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.managed.bean.custom.scope.eval.null", new Object[]{this.scope.getExpressionString()});
                }
            }

            public boolean isInScope(String string, FacesContext facesContext) {
                Map map = (Map)this.scope.getValue(this.getELContext(facesContext));
                if (map != null) {
                    return map.containsKey(string);
                }
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.managed.bean.custom.scope.eval.null.existence", new Object[]{this.scope.getExpressionString()});
                }
                return true;
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                Map map = (Map)this.scope.getValue(this.getELContext(facesContext));
                if (map != null) {
                    return map.get(string);
                }
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.managed.bean.custom.scope.eval.null.existence", new Object[]{this.scope.getExpressionString()});
                }
                return null;
            }

            private ELContext getELContext(FacesContext facesContext) {
                return new CustomScopeELContext(facesContext.getELContext());
            }

            private static final class CustomScopeELContext
            extends ELContext {
                private ELContext delegate;

                public CustomScopeELContext(ELContext eLContext) {
                    this.delegate = eLContext;
                }

                public void putContext(Class clazz, Object object) {
                    this.delegate.putContext(clazz, object);
                }

                public Object getContext(Class clazz) {
                    return this.delegate.getContext(clazz);
                }

                public Locale getLocale() {
                    return this.delegate.getLocale();
                }

                public void setLocale(Locale locale) {
                    this.delegate.setLocale(locale);
                }

                public ELResolver getELResolver() {
                    return this.delegate.getELResolver();
                }

                public FunctionMapper getFunctionMapper() {
                    return this.delegate.getFunctionMapper();
                }

                public VariableMapper getVariableMapper() {
                    return this.delegate.getVariableMapper();
                }
            }
        }

        private static class ApplicationScopeHandler
        implements ScopeHandler {
            private ApplicationScopeHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String string, Object object, FacesContext facesContext) {
                Object object2 = facesContext.getExternalContext().getContext();
                synchronized (object2) {
                    facesContext.getExternalContext().getApplicationMap().put(string, object);
                }
            }

            public boolean isInScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getApplicationMap().containsKey(string);
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getApplicationMap().get(string);
            }
        }

        private static class SessionScopeHandler
        implements ScopeHandler {
            private SessionScopeHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String string, Object object, FacesContext facesContext) {
                Object object2 = facesContext.getExternalContext().getSession(true);
                synchronized (object2) {
                    facesContext.getExternalContext().getSessionMap().put(string, object);
                }
            }

            public boolean isInScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getSessionMap().containsKey(string);
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getSessionMap().get(string);
            }
        }

        private static class ViewScopeHandler
        implements ScopeHandler {
            private ViewScopeHandler() {
            }

            public void handle(String string, Object object, FacesContext facesContext) {
                facesContext.getViewRoot().getViewMap().put(string, object);
            }

            public boolean isInScope(String string, FacesContext facesContext) {
                Map map = facesContext.getViewRoot().getViewMap(false);
                return map != null && map.containsKey(string);
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                Map map = facesContext.getViewRoot().getViewMap(false);
                return map != null ? map.get(string) : null;
            }
        }

        private static class RequestScopeHandler
        implements ScopeHandler {
            private RequestScopeHandler() {
            }

            public void handle(String string, Object object, FacesContext facesContext) {
                facesContext.getExternalContext().getRequestMap().put(string, object);
            }

            public boolean isInScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestMap().containsKey(string);
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestMap().get(string);
            }
        }

        private static class NoneScopeHandler
        implements ScopeHandler {
            private NoneScopeHandler() {
            }

            public void handle(String string, Object object, FacesContext facesContext) {
            }

            public boolean isInScope(String string, FacesContext facesContext) {
                return false;
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                return null;
            }
        }

        private static interface ScopeHandler {
            public void handle(String var1, Object var2, FacesContext var3);

            public boolean isInScope(String var1, FacesContext var2);

            public Object getFromScope(String var1, FacesContext var2);
        }
    }
}

