/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.Util;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedEventManager {
    private Map<String, Class<? extends SystemEvent>> namedEvents = new ConcurrentHashMap<String, Class<? extends SystemEvent>>();
    private Map<String, Set<Class<? extends SystemEvent>>> duplicateNames = new ConcurrentHashMap<String, Set<Class<? extends SystemEvent>>>();

    public NamedEventManager() {
        this.namedEvents.put("javax.faces.event.PreRenderComponent", PreRenderComponentEvent.class);
        this.namedEvents.put("javax.faces.event.PreRenderView", PreRenderViewEvent.class);
        this.namedEvents.put("javax.faces.event.PostAddToView", PostAddToViewEvent.class);
        this.namedEvents.put("javax.faces.event.PreValidate", PreValidateEvent.class);
        this.namedEvents.put("javax.faces.event.PostValidate", PostValidateEvent.class);
        this.namedEvents.put("preRenderComponent", PreRenderComponentEvent.class);
        this.namedEvents.put("preRenderView", PreRenderViewEvent.class);
        this.namedEvents.put("postAddToView", PostAddToViewEvent.class);
        this.namedEvents.put("preValidate", PreValidateEvent.class);
        this.namedEvents.put("postValidate", PostValidateEvent.class);
    }

    public void addNamedEvent(String string, Class<? extends SystemEvent> clazz) {
        this.namedEvents.put(string, clazz);
    }

    public Class<? extends SystemEvent> getNamedEvent(String string) {
        Class clazz = this.namedEvents.get(string);
        if (clazz == null) {
            try {
                clazz = Util.loadClass(string, this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new FacesException("An unknown event type was specified:  " + string, (Throwable)classNotFoundException);
            }
        }
        if (!ComponentSystemEvent.class.isAssignableFrom(clazz)) {
            throw new ClassCastException();
        }
        return clazz;
    }

    public void addDuplicateName(String string, Class<? extends SystemEvent> clazz) {
        Class<? extends SystemEvent> clazz2 = this.namedEvents.remove(string);
        Set<Class<? extends SystemEvent>> set = this.duplicateNames.get(string);
        if (set == null) {
            set = new HashSet<Class<? extends SystemEvent>>();
            this.duplicateNames.put(string, set);
        }
        set.add(clazz);
        if (clazz2 != null) {
            set.add(clazz2);
        }
    }

    public boolean isDuplicateNamedEvent(String string) {
        return this.namedEvents.get(string) != null || this.duplicateNames.get(string) != null;
    }
}

