/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClasspathResourceHelper;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceCache;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.application.resource.WebappResourceHelper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class ResourceManager {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern CONFIG_MIMETYPE_PATTERN = Pattern.compile("[a-z-]*/[a-z0-9.\\*-]*");
    private ResourceHelper webappHelper = new WebappResourceHelper();
    private ClasspathResourceHelper classpathHelper = new ClasspathResourceHelper();
    private ResourceCache cache;
    private List<Pattern> compressableTypes;
    private ReentrantLock lock = new ReentrantLock();

    public ResourceManager(ResourceCache resourceCache) {
        this.cache = resourceCache;
        this.initCompressableTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceInfo findResource(String string, String string2, String string3, FacesContext facesContext) {
        String string4 = this.getLocalePrefix(facesContext);
        ResourceInfo resourceInfo = this.getFromCache(string2, string, string4);
        if (resourceInfo != null) return resourceInfo;
        boolean bl = this.isCompressable(string3, facesContext);
        if (bl) {
            this.lock.lock();
            try {
                resourceInfo = this.getFromCache(string2, string, string4);
                if (resourceInfo != null || (resourceInfo = this.doLookup(string, string2, string4, bl, facesContext)) == null) return resourceInfo;
                this.addToCache(resourceInfo);
                return resourceInfo;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            resourceInfo = this.doLookup(string, string2, string4, bl, facesContext);
            if (resourceInfo == null) return resourceInfo;
            this.addToCache(resourceInfo);
        }
        return resourceInfo;
    }

    private ResourceInfo doLookup(String string, String string2, String string3, boolean bl, FacesContext facesContext) {
        String string4;
        LibraryInfo libraryInfo = null;
        if (string != null && !ResourceManager.nameContainsForbiddenSequence(string)) {
            libraryInfo = this.findLibrary(string, string3, facesContext);
            if (libraryInfo == null && string3 != null) {
                libraryInfo = this.findLibrary(string, null, facesContext);
            }
            if (libraryInfo == null) {
                libraryInfo = this.findLibraryOnClasspathWithZipDirectoryEntryScan(string, string3, facesContext, false);
                if (libraryInfo == null && string3 != null) {
                    libraryInfo = this.findLibraryOnClasspathWithZipDirectoryEntryScan(string, null, facesContext, false);
                }
                if (null == libraryInfo) {
                    return null;
                }
            }
        } else if (ResourceManager.nameContainsForbiddenSequence(string)) {
            return null;
        }
        if (ResourceManager.nameContainsForbiddenSequence(string4 = this.trimLeadingSlash(string2))) {
            return null;
        }
        ResourceInfo resourceInfo = this.findResource(libraryInfo, string4, string3, bl, facesContext);
        if (resourceInfo == null && string3 != null) {
            resourceInfo = this.findResource(libraryInfo, string4, null, bl, facesContext);
        }
        if (resourceInfo == null && libraryInfo != null && libraryInfo.getHelper() instanceof WebappResourceHelper) {
            LibraryInfo libraryInfo2 = this.classpathHelper.findLibrary(string, string3, facesContext);
            if (libraryInfo2 != null) {
                VersionInfo versionInfo = libraryInfo.getVersion();
                VersionInfo versionInfo2 = libraryInfo2.getVersion();
                if (versionInfo == null && versionInfo2 == null) {
                    libraryInfo = libraryInfo2;
                } else if (versionInfo == null && versionInfo2 != null) {
                    libraryInfo = null;
                } else if (versionInfo != null && versionInfo2 == null) {
                    libraryInfo = null;
                } else if (versionInfo.compareTo(versionInfo2) == 0) {
                    libraryInfo = libraryInfo2;
                }
            }
            if (libraryInfo != null && (resourceInfo = this.findResource(libraryInfo, string4, string3, bl, facesContext)) == null && string3 != null) {
                resourceInfo = this.findResource(libraryInfo, string4, null, bl, facesContext);
            }
        }
        return resourceInfo;
    }

    private static boolean nameContainsForbiddenSequence(String string) {
        if (null == string) {
            return false;
        }
        boolean bl = false;
        bl = (string = string.toLowerCase()).startsWith("..") || string.contains("../") || string.contains("..\\") || string.startsWith("/") || string.startsWith("\\") || string.contains("..%2f") || string.contains("..%5c") || string.startsWith("%2f") || string.startsWith("%5c") || string.contains("..\\u002f") || string.contains("..\\u005c") || string.startsWith("\\u002f") || string.startsWith("\\u005c");
        return bl;
    }

    private ResourceInfo getFromCache(String string, String string2, String string3) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(string, string2, string3);
    }

    private void addToCache(ResourceInfo resourceInfo) {
        if (this.cache == null) {
            return;
        }
        this.cache.add(resourceInfo);
    }

    LibraryInfo findLibrary(String string, String string2, FacesContext facesContext) {
        LibraryInfo libraryInfo = this.webappHelper.findLibrary(string, string2, facesContext);
        if (libraryInfo == null) {
            libraryInfo = this.classpathHelper.findLibrary(string, string2, facesContext);
        }
        return libraryInfo;
    }

    LibraryInfo findLibraryOnClasspathWithZipDirectoryEntryScan(String string, String string2, FacesContext facesContext, boolean bl) {
        return this.classpathHelper.findLibraryWithZipDirectoryEntryScan(string, string2, facesContext, bl);
    }

    private ResourceInfo findResource(LibraryInfo libraryInfo, String string, String string2, boolean bl, FacesContext facesContext) {
        if (libraryInfo != null) {
            return libraryInfo.getHelper().findResource(libraryInfo, string, string2, bl, facesContext);
        }
        ResourceInfo resourceInfo = this.webappHelper.findResource(null, string, string2, bl, facesContext);
        if (resourceInfo == null) {
            resourceInfo = this.classpathHelper.findResource(null, string, string2, bl, facesContext);
        }
        return resourceInfo;
    }

    private String getLocalePrefix(FacesContext facesContext) {
        String string = null;
        String string2 = facesContext.getApplication().getMessageBundle();
        if (null != string2) {
            Locale locale = facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, locale, Util.getCurrentLoader(ResourceManager.class));
                string = resourceBundle.getString("javax.faces.resource.localePrefix");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    private String trimLeadingSlash(String string) {
        if (string.charAt(0) == '/') {
            return string.substring(1);
        }
        return string;
    }

    private boolean isCompressable(String string, FacesContext facesContext) {
        if (string == null || facesContext.isProjectStage(ProjectStage.Development)) {
            return false;
        }
        if (this.compressableTypes != null && !this.compressableTypes.isEmpty()) {
            for (Pattern pattern : this.compressableTypes) {
                boolean bl = pattern.matcher(string).matches();
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private void initCompressableTypes() {
        String[] stringArray;
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.CompressableMimeTypes);
        if (string != null && string.length() > 0 && (stringArray = Util.split(string, ",")) != null) {
            for (String string2 : stringArray) {
                String string3 = string2.trim();
                if (!this.isPatternValid(string3)) continue;
                if (string3.endsWith("/*")) {
                    string3 = string3.substring(0, string3.indexOf("/*"));
                    string3 = string3 + "/[a-z0-9.-]*";
                }
                if (this.compressableTypes == null) {
                    this.compressableTypes = new ArrayList<Pattern>(stringArray.length);
                }
                try {
                    this.compressableTypes.add(Pattern.compile(string3));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.resource.mime.type.configration.invalid", new Object[]{string3, patternSyntaxException.getPattern()});
                }
            }
        }
    }

    private boolean isPatternValid(String string) {
        return CONFIG_MIMETYPE_PATTERN.matcher(string).matches();
    }
}

